/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Util.BiomeDescriptor;
import CustomOreGen.Util.BlockDescriptor;
import CustomOreGen.Util.GeometryStream;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSubstitution
extends WorldGenerator
implements IOreDistribution {
    @DistributionSettingMap.DistributionSetting(name="Name", inherited=false, info="Descriptive distribution name.")
    public String name;
    @DistributionSettingMap.DistributionSetting(name="DisplayName", inherited=false, info="Distribution name for display in user interfaces.")
    public String displayName;
    @DistributionSettingMap.DistributionSetting(name="Seed", inherited=false, info="Distribution random number seed.")
    public long seed;
    @DistributionSettingMap.DistributionSetting(name="OreBlock", info="Ore block(s) - total weight must not be more than 100%")
    public final BlockDescriptor oreBlock;
    @DistributionSettingMap.DistributionSetting(name="ReplaceableBlock", info="List of replaceable blocks")
    public final BlockDescriptor replaceableBlocks;
    @DistributionSettingMap.DistributionSetting(name="TargetBiome", info="List of valid target biomes")
    public final BiomeDescriptor biomes;
    @DistributionSettingMap.DistributionSetting(name="additionalRange", info="Distance outside of current chunk to scan in every pass, in meters")
    public int additionalRange;
    @DistributionSettingMap.DistributionSetting(name="minHeight", info="Minimum substitution height")
    public int minHeight;
    @DistributionSettingMap.DistributionSetting(name="maxHeight", info="Maximum substitution height")
    public int maxHeight;
    @DistributionSettingMap.DistributionSetting(name="minSurfRelHeight", info="Minimum surface-relative substitution height")
    public int minSurfRelHeight;
    @DistributionSettingMap.DistributionSetting(name="maxSurfRelHeight", info="Maximum surface-relative substitution height")
    public int maxSurfRelHeight;
    @DistributionSettingMap.DistributionSetting(name="populatedChunks", info="Chunks populated during current game session.")
    public int populatedChunks;
    @DistributionSettingMap.DistributionSetting(name="placedBlocks", info="Blocks placed during current game session.")
    public long placedBlocks;
    protected boolean _valid;
    protected final boolean _canGenerate;
    protected static final DistributionSettingMap settingMap = new DistributionSettingMap(WorldGenSubstitution.class);

    public WorldGenSubstitution(int distributionID, boolean canGenerate) {
        this.oreBlock = new BlockDescriptor(Integer.toString(Block.field_71981_t.field_71990_ca));
        this.replaceableBlocks = new BlockDescriptor();
        this.biomes = new BiomeDescriptor(".*");
        this.additionalRange = 0;
        this.minHeight = Integer.MIN_VALUE;
        this.maxHeight = Integer.MAX_VALUE;
        this.minSurfRelHeight = Integer.MIN_VALUE;
        this.maxSurfRelHeight = Integer.MAX_VALUE;
        this.populatedChunks = 0;
        this.placedBlocks = 0L;
        this._valid = false;
        this.name = "Substitute_" + distributionID;
        this.seed = new Random(distributionID).nextLong();
        this._canGenerate = canGenerate;
    }

    @Override
    public void inheritFrom(IOreDistribution inherits) throws IllegalArgumentException {
        if (inherits == null || !(inherits instanceof WorldGenSubstitution)) {
            throw new IllegalArgumentException("Invalid source distribution '" + inherits + "'");
        }
        settingMap.inheritAll((WorldGenSubstitution)inherits, this);
        this._valid = false;
    }

    public Map getDistributionSettings() {
        return settingMap.getDescriptions();
    }

    @Override
    public Object getDistributionSetting(String settingName) {
        return settingMap.get(this, settingName);
    }

    @Override
    public void setDistributionSetting(String settingName, Object value) throws IllegalArgumentException, IllegalAccessException {
        settingMap.set(this, settingName, value);
    }

    @Override
    public void generate(World world, int chunkX, int chunkZ) {
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ) {
        if (this._canGenerate && this._valid && this.oreBlock != null) {
            Random random = new Random(world.func_72905_C());
            long xSeed = random.nextLong() >> 3;
            long zSeed = random.nextLong() >> 3;
            random.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ world.func_72905_C() ^ this.seed);
            this.func_76484_a(world, random, chunkX * 16, 0, chunkZ * 16);
        }
    }

    @Override
    public void cull() {
    }

    @Override
    public void clear() {
        this.populatedChunks = 0;
        this.placedBlocks = 0L;
    }

    @Override
    public GeometryStream getDebuggingGeometry(World world, int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public boolean validate() throws IllegalStateException {
        float biomeMatchWeight;
        float replBlockMatchWeight;
        this._valid = true;
        float oreBlockMatchWeight = this.oreBlock.getTotalMatchWeight();
        if (oreBlockMatchWeight <= 0.0f) {
            if (this._canGenerate) {
                this._valid = false;
                throw new IllegalStateException("Ore block descriptor for " + this + " is empty or does not match any registered blocks.");
            }
        } else if (oreBlockMatchWeight > 1.0f) {
            this._valid = false;
            throw new IllegalStateException("Ore block descriptor for " + this + " is overspecified with a total match weight of " + oreBlockMatchWeight * 100.0f + "%.");
        }
        if ((replBlockMatchWeight = this.replaceableBlocks.getTotalMatchWeight()) <= 0.0f) {
            // empty if block
        }
        if ((biomeMatchWeight = this.biomes.getTotalMatchWeight()) <= 0.0f) {
            // empty if block
        }
        if (this.additionalRange < 0) {
            this._valid = false;
            throw new IllegalStateException("Invalid additional scan range '" + this.additionalRange + "' for " + this);
        }
        if (this.minHeight > this.maxHeight) {
            this._valid = false;
            throw new IllegalStateException("Invalid height range [" + this.minHeight + "," + this.maxHeight + "] for " + this);
        }
        if (this.minSurfRelHeight > this.maxSurfRelHeight) {
            this._valid = false;
            throw new IllegalStateException("Invalid height range [" + this.minSurfRelHeight + "," + this.maxSurfRelHeight + "] for " + this);
        }
        return this._valid && this._canGenerate;
    }

    public boolean func_76484_a(World world, Random random, int depositX, int depositY, int depositZ) {
        if (this._canGenerate && this._valid && this.oreBlock != null) {
            int depositCX = depositX / 16;
            int depositCZ = depositZ / 16;
            int cRange = (this.additionalRange + 15) / 16;
            int hRange = (this.additionalRange + 7) / 8;
            int minh = Math.max(0, this.minHeight);
            int maxh = Math.min(world.func_72800_K() - 1, this.maxHeight);
            for (int dCX = -cRange; dCX <= cRange; ++dCX) {
                for (int dCZ = -cRange; dCZ <= cRange; ++dCZ) {
                    int chunkX = depositCX + dCX;
                    int chunkZ = depositCZ + dCZ;
                    if (!world.func_72899_e(chunkX * 16, 0, chunkZ * 16)) continue;
                    Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                    int minX = dCX < 0 && -dCX * 2 > hRange ? 8 : 0;
                    int minZ = dCZ < 0 && -dCZ * 2 > hRange ? 8 : 0;
                    int maxX = dCX > 0 && dCX * 2 > hRange ? 8 : 16;
                    int maxZ = dCZ > 0 && dCZ * 2 > hRange ? 8 : 16;
                    for (int x = minX; x < maxX; ++x) {
                        for (int z = minZ; z < maxZ; ++z) {
                            BiomeGenBase biome = chunk.func_76591_a(x, z, world.field_73011_w.field_76578_c);
                            if (biome != null && !(this.biomes.getWeight(biome) > 0.5f)) continue;
                            int xzminh = minh;
                            int xzmaxh = maxh;
                            if (this.minSurfRelHeight != Integer.MIN_VALUE || this.maxSurfRelHeight != Integer.MAX_VALUE) {
                                int surfh = this.findSurfaceHeight(chunk, x, z);
                                xzminh = Math.max(xzminh, this.minSurfRelHeight + surfh);
                                xzmaxh = Math.min(xzmaxh, this.maxSurfRelHeight + Math.min(surfh, Integer.MAX_VALUE - this.maxSurfRelHeight));
                            }
                            for (int y = xzminh; y <= xzmaxh; ++y) {
                                int currentBlock = chunk.func_76610_a(x, y, z);
                                int fastCheck = this.replaceableBlocks.matchesBlock_fast(currentBlock);
                                if (fastCheck == 0 || fastCheck == -1 && !this.replaceableBlocks.matchesBlock(currentBlock, chunk.func_76628_c(x, y, z), random)) continue;
                                int match = this.oreBlock.getMatchingBlock(random);
                                int matchID = match >>> 16;
                                int matchMeta = match & 0xFFFF;
                                if (match == -1 || matchID != 0 && !Block.field_71973_m[matchID].func_71854_d(world, x, y, z) || !chunk.func_76592_a(x, y, z, matchID, matchMeta)) continue;
                                ++this.placedBlocks;
                                world.func_72845_h(chunkX * 16 + x, y, chunkZ * 16 + z);
                            }
                        }
                    }
                }
            }
            ++this.populatedChunks;
            return true;
        }
        return false;
    }

    private boolean isSurfaceBlock(int id) {
        Material material = id == 0 ? Material.field_76249_a : Block.field_71973_m[id].field_72018_cp;
        return material == Material.field_76267_y || material == Material.field_76247_b || material == Material.field_76248_c || material == Material.field_76260_u || material == Material.field_76246_e || material == Material.field_76251_o;
    }

    private int findSurfaceHeight(Chunk chunk, int x, int z) {
        int surfh;
        for (surfh = chunk.func_76611_b(x, z); surfh > 0 && !this.isSurfaceBlock(chunk.func_76610_a(x, surfh, z)); --surfh) {
        }
        return surfh;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getNarayanWord() {
        return "Change";
    }

    @Override
    public double getOresPerChunk() {
        return this.maxHeight - this.minHeight;
    }
}

