/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Server.DistributionSettingMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlockDescriptor
implements DistributionSettingMap.Copyable<BlockDescriptor> {
    protected LinkedList<Descriptor> _descriptors = new LinkedList();
    protected Map<Integer, Float> _matches = new Hashtable<Integer, Float>();
    protected boolean _compiled = false;
    protected float[] _fastMatch = new float[256];

    public BlockDescriptor() {
        this.clear();
    }

    public BlockDescriptor(String descriptor) {
        this.set(descriptor);
    }

    @Override
    public void copyFrom(BlockDescriptor source) {
        this._descriptors = new LinkedList<Descriptor>(source._descriptors);
        this._matches = new Hashtable<Integer, Float>(source._matches);
        this._compiled = source._compiled;
        this._fastMatch = (float[])source._fastMatch.clone();
    }

    public BlockDescriptor set(String descriptor) {
        this.clear();
        if (descriptor != null) {
            this._descriptors.add(new Descriptor(descriptor, 1.0f, false));
        }
        return this;
    }

    public BlockDescriptor add(String descriptor) {
        return this.add(descriptor, 1.0f, false);
    }

    public BlockDescriptor add(String descriptor, float weight) {
        return this.add(descriptor, weight, false);
    }

    public BlockDescriptor add(String descriptor, float weight, boolean describesOre) {
        if (descriptor != null && weight != 0.0f) {
            this._compiled = false;
            this._descriptors.add(new Descriptor(descriptor, weight, describesOre));
        }
        return this;
    }

    public BlockDescriptor clear() {
        this._compiled = false;
        this._descriptors.clear();
        return this;
    }

    public List getDescriptors() {
        return Collections.unmodifiableList(this._descriptors);
    }

    protected void add(int blockID, int metaData, float weight) {
        if (weight != 0.0f) {
            Integer key = blockID << 16 | metaData & Short.MAX_VALUE;
            Float currentValue = this._matches.get(key);
            if (currentValue != null) {
                weight += currentValue.floatValue();
            }
            this._matches.put(key, Float.valueOf(weight));
            if (blockID >= 0 && blockID < this._fastMatch.length) {
                if (metaData == Short.MAX_VALUE && !Float.isNaN(this._fastMatch[blockID])) {
                    int n = blockID;
                    this._fastMatch[n] = this._fastMatch[n] + weight;
                } else {
                    this._fastMatch[blockID] = Float.NaN;
                }
            }
        }
    }

    public void add(BlockDescriptor desc, float weight) {
        for (Descriptor d : desc._descriptors) {
            this.add(d.description, d.weight * weight, d.describesOre);
        }
    }

    protected float[] regexMatch(String id, String name) {
        float[] weights = new float[17];
        for (Descriptor desc : this._descriptors) {
            if (desc.describesOre) continue;
            if (!(id != null && desc.getPattern().matcher(id).matches() || name != null && desc.getPattern().matcher(name).matches())) {
                for (int m = 0; m < 16; ++m) {
                    if ((id == null || !desc.getPattern().matcher(id + ":" + m).matches()) && (name == null || !desc.getPattern().matcher(name + ":" + m).matches())) continue;
                    ++desc.matches;
                    int n = m;
                    weights[n] = weights[n] + desc.weight;
                }
                continue;
            }
            ++desc.matches;
            weights[16] = weights[16] + desc.weight;
        }
        return weights;
    }

    protected void compileMatches() {
        if (!this._compiled) {
            this._compiled = true;
            this._matches.clear();
            Arrays.fill(this._fastMatch, 0.0f);
            for (Descriptor desc : this._descriptors) {
                desc.matches = 0;
            }
            float[] var10 = this.regexMatch("0", "air");
            this.add(0, Short.MAX_VALUE, var10[16]);
            for (Block block : Block.field_71973_m) {
                if (block == null || block.field_71990_ca == 0) continue;
                String id = Integer.toString(block.field_71990_ca);
                String name = block.func_71917_a() == null ? null : block.func_71917_a().replace("tile.", "");
                float[] weights = this.regexMatch(id, name);
                this.add(block.field_71990_ca, Short.MAX_VALUE, weights[16]);
                for (int m = 0; m < 16; ++m) {
                    this.add(block.field_71990_ca, m, weights[m]);
                }
            }
            for (Descriptor desc : this._descriptors) {
                if (!desc.describesOre) continue;
                for (ItemStack ore : OreDictionary.getOres((String)desc.description)) {
                    boolean isBlock = ore.field_77993_c < Block.field_71973_m.length;
                    if (!isBlock) continue;
                    this.add(ore.field_77993_c, ore.func_77960_j(), desc.weight);
                }
            }
        }
    }

    public Map getMatches() {
        this.compileMatches();
        return Collections.unmodifiableMap(this._matches);
    }

    public float getWeight_fast(int blockID) {
        this.compileMatches();
        return blockID >= 0 && blockID < this._fastMatch.length ? this._fastMatch[blockID] : Float.NaN;
    }

    public float getWeight(int blockID, int metaData) {
        Float metaValue;
        this.compileMatches();
        float value = 0.0f;
        Float noMetaValue = this._matches.get(blockID << 16 | Short.MAX_VALUE);
        if (noMetaValue != null) {
            value = noMetaValue.floatValue();
        }
        if (metaData != Short.MAX_VALUE && (metaValue = this._matches.get(blockID << 16 | metaData & Short.MAX_VALUE)) != null) {
            value += metaValue.floatValue();
        }
        return value;
    }

    public int matchesBlock_fast(int blockID) {
        float weight = this.getWeight_fast(blockID);
        return Float.isNaN(weight) ? -1 : (weight <= 0.0f ? 0 : (weight < 1.0f ? -1 : 1));
    }

    public boolean matchesBlock(int blockID, int metaData, Random rand) {
        float weight = this.getWeight(blockID, metaData);
        if (weight <= 0.0f) {
            return false;
        }
        if (weight < 1.0f) {
            if (rand == null) {
                rand = new Random();
            }
            return rand.nextFloat() < weight;
        }
        return true;
    }

    public int getMatchingBlock(Random rand) {
        this.compileMatches();
        float value = -1.0f;
        for (Map.Entry<Integer, Float> entry : this._matches.entrySet()) {
            float weight = entry.getValue().floatValue();
            int blockID = entry.getKey() >>> 16;
            int metaData = entry.getKey() & Short.MAX_VALUE;
            if (metaData >= Short.MAX_VALUE) {
                metaData = 0;
            }
            if (!(weight > 0.0f)) continue;
            if (weight >= 1.0f) {
                return blockID << 16 | metaData;
            }
            if (value < 0.0f) {
                if (rand == null) {
                    rand = new Random();
                }
                value = rand.nextFloat();
            }
            if (!((value -= weight) < 0.0f)) continue;
            return blockID << 16 | metaData;
        }
        return -1;
    }

    public float getTotalMatchWeight() {
        this.compileMatches();
        float weight = 0.0f;
        for (float val : this._matches.values()) {
            if (!(val > 0.0f)) continue;
            weight += val;
        }
        return weight;
    }

    public String toString() {
        switch (this._descriptors.size()) {
            case 0: {
                return "[no blocks]";
            }
            case 1: {
                return this._descriptors.get(0).toString();
            }
        }
        return this._descriptors.toString();
    }

    public String[] toDetailedString() {
        this.compileMatches();
        String[] breakdown = new String[this._matches.size() + 1];
        breakdown[0] = this._matches.size() + " block matches";
        if (this._matches.size() > 0) {
            breakdown[0] = breakdown[0] + ':';
        }
        int i = 1;
        for (Map.Entry<Integer, Float> entry : this._matches.entrySet()) {
            float weight = entry.getValue().floatValue();
            int blockID = entry.getKey() >>> 16;
            int metaData = entry.getKey() & Short.MAX_VALUE;
            Block block = Block.field_71973_m[blockID];
            breakdown[i] = block == null ? (blockID == 0 ? "Air" : "[??]") : block.func_71931_t();
            breakdown[i] = breakdown[i] + " (" + blockID;
            if (metaData != Short.MAX_VALUE) {
                breakdown[i] = breakdown[i] + ":" + metaData;
            }
            breakdown[i] = breakdown[i] + ") - " + weight;
            ++i;
        }
        return breakdown;
    }

    private class Descriptor {
        public final String description;
        public final float weight;
        public final boolean describesOre;
        public int matches = 0;
        private Pattern pattern = null;

        public Descriptor(String description, float weight, boolean describesOre) {
            this.description = description;
            this.weight = weight;
            this.describesOre = describesOre;
        }

        public Pattern getPattern() {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.description, 2);
            }
            return this.pattern;
        }

        public String toString() {
            return this.description + " - " + Float.toString(this.weight);
        }
    }
}

