/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.api;

import com.google.common.base.Optional;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import ttftcuts.atg.api.IGenMod;
import ttftcuts.atg.api.events.ATGBiomeEvent;
import ttftcuts.atg.api.events.ATGBiomeGroupAddEvent;
import ttftcuts.atg.api.events.ATGBiomeGroupEvent;
import ttftcuts.atg.api.events.ATGBiomeGroupRequestEvent;
import ttftcuts.atg.api.events.ATGBiomeModEvent;
import ttftcuts.atg.api.events.ATGBiomeModRequestEvent;
import ttftcuts.atg.api.events.ATGBiomeRequestEvent;
import ttftcuts.atg.api.events.ATGBiomeRocksEvent;
import ttftcuts.atg.api.events.ATGGeneratorInfoEvent;
import ttftcuts.atg.api.events.listenable.ATGBiomeGroupAssignmentEvent;

public abstract class ATGBiomes {
    public static BiomeGenBase getBiome(String biomeName) {
        ATGBiomeRequestEvent event = new ATGBiomeRequestEvent(biomeName);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.biome.isPresent()) {
            return null;
        }
        return (BiomeGenBase)event.biome.get();
    }

    public static List<String> getGroupFromBiome(BiomeGenBase biome) {
        ATGBiomeGroupRequestEvent event = new ATGBiomeGroupRequestEvent(biome);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.groups;
    }

    public static List<Double> getGeneratorInfo(double x, double z) {
        ATGGeneratorInfoEvent event = new ATGGeneratorInfoEvent(x, z);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.info;
    }

    public static void addBiomeGroup(BiomeType type, String name, double temp, double moisture, double height, double minHeight, double maxHeight, long salt, boolean generate) {
        ATGBiomeGroupAddEvent event = new ATGBiomeGroupAddEvent(type, name, temp, moisture, height, minHeight, maxHeight, salt, generate);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.response == ATGBiomeGroupAddEvent.ResponseType.FAILED) {
            // empty if block
        }
    }

    public static void addBiomeGroup(BiomeType type, String name, double temp, double moisture, double height, double minHeight, double maxHeight, long salt) {
        ATGBiomes.addBiomeGroup(type, name, temp, moisture, height, minHeight, maxHeight, salt, true);
    }

    public static void addBiomeGroup(BiomeType type, String name, double temp, double moisture, double height, long salt) {
        ATGBiomes.addBiomeGroup(type, name, temp, moisture, height, 0.0, 1.0, salt);
    }

    public static void addBiomeGroup(BiomeType type, String name, double temp, double moisture, double height) {
        ATGBiomes.addBiomeGroup(type, name, temp, moisture, height, 0L);
    }

    public static void modGroupSuitability(BiomeType type, String name, double modifier) {
        ATGBiomeGroupEvent event = new ATGBiomeGroupEvent(ATGBiomeGroupEvent.EventType.SUITABILITY, type, name, modifier);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.response == ATGBiomeGroupEvent.ResponseType.FAILED) {
            // empty if block
        }
    }

    public static void addBiome(BiomeType type, String group, BiomeGenBase biome, double weight) {
        ATGBiomeEvent event = new ATGBiomeEvent(type, group, biome, null, weight);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void replaceBiome(BiomeType type, String group, BiomeGenBase toReplace, BiomeGenBase replacement, double weight) {
        ATGBiomeEvent event = new ATGBiomeEvent(type, group, replacement, toReplace, weight);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void addSubBiome(BiomeGenBase biome, BiomeGenBase subBiome, double weight) {
        ATGBiomeModEvent event = new ATGBiomeModEvent(ATGBiomeModEvent.EventType.SUBBIOME, biome, null, subBiome, weight);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void addGenMod(BiomeGenBase biome, IGenMod mod) {
        ATGBiomeModEvent event = new ATGBiomeModEvent(ATGBiomeModEvent.EventType.GENMOD, biome, mod, null, 0.0);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static Optional<IGenMod> getGenMod(BiomeGenBase biome) {
        ATGBiomeModRequestEvent event = new ATGBiomeModRequestEvent(biome);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.mod;
    }

    public static void setBiomeRocks(BiomeGenBase biome, int rockChance, int bigRockChance, int rocksPerChunk) {
        ATGBiomeRocksEvent event = new ATGBiomeRocksEvent(biome, rockChance, bigRockChance, rocksPerChunk);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void enableBiomeGroupAssignmentEvent() {
        ATGBiomeGroupAssignmentEvent.ATGGroupActivationEvent event = new ATGBiomeGroupAssignmentEvent.ATGGroupActivationEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static enum BiomeType {
        LAND,
        COAST,
        SEA;

    }
}

