/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.blocks.component.SmelteryComponent;
import tconstruct.blocks.component.SmelteryScan;
import tconstruct.blocks.logic.TankAirLogic;
import tconstruct.common.TContent;
import tconstruct.inventory.AdaptiveSmelteryContainer;
import tconstruct.library.blocks.AdaptiveInventoryLogic;
import tconstruct.library.component.IComponentHolder;
import tconstruct.library.component.LogicComponent;
import tconstruct.library.component.MultiFluidTank;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;

public class AdaptiveSmelteryLogic
extends AdaptiveInventoryLogic
implements IActiveLogic,
IMasterLogic,
IComponentHolder,
IFluidHandler {
    byte direction;
    boolean updateFluids = false;
    boolean recheckStructure = false;
    boolean updateAir = false;
    SmelteryScan structure = new SmelteryScan(this, TContent.smeltery, TContent.lavaTank);
    MultiFluidTank multitank = new MultiFluidTank();
    SmelteryComponent smeltery = new SmelteryComponent(this, this.structure, this.multitank, 800);
    HashMap<CoordTuple, LiquidDataInstance> airUpdates = new HashMap();
    int tick = 0;
    static final int pixelLayer = 162;

    public MultiFluidTank getMultiTank() {
        return this.multitank;
    }

    public SmelteryComponent getSmeltery() {
        return this.smeltery;
    }

    public void func_70316_g() {
        ++this.tick;
        if (this.tick % 4 == 0) {
            this.smeltery.heatItems();
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.tick % 20 == 0) {
                if (this.structure.isComplete()) {
                    this.smeltery.update();
                }
                if (this.updateFluids) {
                    this.distributeFluids();
                    this.updateFluids = false;
                }
                if (this.updateAir) {
                    this.updateAir();
                    this.updateAir = false;
                }
                if (this.recheckStructure) {
                    this.structure.recheckStructure();
                    this.recheckStructure = false;
                }
            }
            if (this.tick >= 60) {
                if (!this.structure.isComplete()) {
                    this.structure.checkValidStructure();
                    if (this.structure.isComplete()) {
                        this.validateSmeltery();
                    }
                }
                this.tick = 0;
            }
            if (this.airUpdates.size() > 0) {
                this.updateFluidBlocks();
            }
        }
    }

    public void setUpdateFluids() {
        this.updateFluids = true;
    }

    @Override
    public List<LogicComponent> getComponents() {
        ArrayList<LogicComponent> ret = new ArrayList<LogicComponent>(3);
        ret.add(this.structure);
        ret.add(this.multitank);
        ret.add(this.smeltery);
        return ret;
    }

    public void func_70308_a(World world) {
        super.func_70308_a(world);
        this.structure.setWorld(world);
        this.smeltery.setWorld(world);
    }

    @Override
    public void notifyChange(IServantLogic servant, int x, int y, int z) {
        if (!this.field_70331_k.field_72995_K) {
            this.recheckStructure = true;
        }
    }

    @Override
    public void placeBlock(EntityLivingBase entity, ItemStack itemstack) {
        this.structure.checkValidStructure();
        if (this.structure.isComplete()) {
            this.validateSmeltery();
        }
    }

    void validateSmeltery() {
        this.adjustInventory(this.structure.getAirSize(), true);
        this.smeltery.adjustSize(this.structure.getAirSize(), true);
        this.multitank.setCapacity(this.structure.getAirSize() * 2592);
        this.smeltery.setActiveLavaTank(this.structure.lavaTanks.get(0));
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void removeBlock() {
        this.structure.cleanup();
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(int side) {
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    @Override
    public boolean getActive() {
        return this.structure.isComplete();
    }

    @Override
    public void setActive(boolean flag) {
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.updateWorldBlock(slot, itemstack);
        this.updateAir = true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                this.updateWorldBlock(slot, this.inventory[slot]);
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.updateWorldBlock(slot, this.inventory[slot]);
            return split;
        }
        return null;
    }

    public void func_70296_d() {
        this.smeltery.updateTemperatures();
        this.updateAir = true;
        super.func_70296_d();
    }

    void updateWorldBlock(int slot, ItemStack itemstack) {
        TileEntity te;
        CoordTuple air = this.structure.getAirByIndex(slot);
        if (air != null && (te = this.field_70331_k.func_72796_p(air.x, air.y, air.z)) != null && te instanceof TankAirLogic) {
            ((TankAirLogic)te).func_70299_a(0, itemstack);
        }
    }

    public void distributeFluids() {
        int size = this.structure.getAirLayerSize();
        block0: for (FluidStack fluid : this.multitank.fluidlist) {
            LiquidData data = new LiquidData(fluid.amount, size);
            int baseY = ((CoordTuple)this.structure.airCoords.get((int)0)).y;
            int layerSize = this.structure.getAirLayerSize();
            for (int i = 0; i < this.structure.airCoords.size(); ++i) {
                FluidStack newFluid;
                int open;
                LiquidDataInstance instance;
                CoordTuple coord = (CoordTuple)this.structure.airCoords.get(i);
                int height = 16 * (coord.y - baseY);
                int position = i % layerSize;
                if (!this.airUpdates.containsKey(coord)) {
                    instance = new LiquidDataInstance();
                    this.airUpdates.put(coord, instance);
                } else {
                    instance = this.airUpdates.get(coord);
                }
                if (instance.openLayers() <= 0) continue;
                if (position > data.blocksWithExtra) {
                    open = data.layers - height + 1;
                    if (open < 1) continue;
                    if (open > instance.openLayers()) {
                        open = instance.openLayers();
                    }
                    newFluid = fluid.copy();
                    newFluid.amount = 162 * open;
                    instance.addFluid(open, newFluid);
                    data.totalAmount -= newFluid.amount;
                    if (data.totalAmount > 0) continue;
                    continue block0;
                }
                if (position == data.blocksWithExtra && data.leftovers > 0) {
                    open = data.layers - height + 1;
                    if (open < 1) continue;
                    boolean full = false;
                    if (open > instance.openLayers()) {
                        open = instance.openLayers();
                        full = true;
                    }
                    FluidStack newFluid2 = fluid.copy();
                    newFluid2.amount = 162 * open;
                    if (!full) {
                        newFluid2.amount += data.leftovers;
                    }
                    instance.addFluid(open, newFluid2);
                    data.totalAmount -= newFluid2.amount;
                    if (data.totalAmount > 0) continue;
                    continue block0;
                }
                open = data.layers - height;
                if (open < 1) continue;
                if (open > instance.openLayers()) {
                    open = instance.openLayers();
                }
                newFluid = fluid.copy();
                newFluid.amount = 162 * open;
                instance.addFluid(open, newFluid);
                data.totalAmount -= newFluid.amount;
                if (data.totalAmount <= 0) continue block0;
            }
        }
    }

    protected void updateFluidBlocks() {
        Iterator<Map.Entry<CoordTuple, LiquidDataInstance>> iter = this.airUpdates.entrySet().iterator();
        for (int count = 0; iter.hasNext() && count < 40; count = (int)((byte)(count + 1))) {
            Map.Entry<CoordTuple, LiquidDataInstance> pairs = iter.next();
            CoordTuple coord = pairs.getKey();
            TileEntity te = this.field_70331_k.func_72796_p(coord.x, coord.y, coord.z);
            if (te instanceof TankAirLogic) {
                ((TankAirLogic)te).overrideFluids(pairs.getValue().fluids);
            }
            iter.remove();
        }
    }

    public void updateAir() {
        for (CoordTuple loc : this.structure.airCoords) {
            this.field_70331_k.func_72845_h(loc.x, loc.y, loc.z);
        }
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new AdaptiveSmelteryContainer(inventoryplayer, this);
    }

    public int getTempForSlot(int slot) {
        return this.smeltery.activeTemps[slot];
    }

    public int getMeltingPointForSlot(int slot) {
        return this.smeltery.meltingTemps[slot];
    }

    @Override
    public String getDefaultName() {
        return "crafters.Smeltery";
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.multitank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.multitank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.multitank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.multitank.getMultiTankInfo();
    }

    public int getFillState() {
        return 1;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readNetworkNBT(tags);
        this.structure.readFromNBT(tags);
        this.multitank.readFromNBT(tags);
        this.smeltery.readFromNBT(tags);
    }

    public void readNetworkNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.adjustInventory(tags.func_74762_e("InvSize"), false);
        super.readInventoryFromNBT(tags);
        this.structure.readNetworkNBT(tags);
        this.multitank.readNetworkNBT(tags);
        this.smeltery.readNetworkNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeNetworkNBT(tags);
        this.structure.writeToNBT(tags);
        this.multitank.writeToNBT(tags);
        this.smeltery.writeToNBT(tags);
    }

    public void writeNetworkNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74768_a("InvSize", this.inventory.length);
        super.writeInventoryToNBT(tags);
        this.structure.writeNetworkNBT(tags);
        this.multitank.writeNetworkNBT(tags);
        this.smeltery.writeNetworkNBT(tags);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readNetworkNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNetworkNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    class LiquidDataInstance {
        public ArrayList<FluidStack> fluids = new ArrayList();
        int layers = 0;

        LiquidDataInstance() {
        }

        public int openLayers() {
            return 16 - this.layers;
        }

        public void addFluid(int l, FluidStack fluid) {
            this.layers += l;
            this.fluids.add(fluid);
        }
    }

    class LiquidData {
        public int totalAmount;
        public int layers;
        public int leftovers;
        public int blocksWithExtra;

        LiquidData(int amount, int blocks) {
            this.totalAmount = amount;
            int layerAmount = 162 * blocks;
            this.layers = amount / layerAmount;
            this.leftovers = amount % 162;
            this.blocksWithExtra = amount % layerAmount / 162;
        }
    }
}

