/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.blocks.logic.CastingBasinLogic;
import tconstruct.blocks.logic.CastingTableLogic;
import tconstruct.blocks.logic.FaucetLogic;
import tconstruct.blocks.logic.LavaTankLogic;

public class CastingChannelLogic
extends TileEntity
implements IFluidHandler {
    public static final int fillMax = 144;
    public static final int outputMax = 144;
    FluidTank internalTank = new FluidTank(144);
    HashMap<ForgeDirection, FluidTank> subTanks = new HashMap();
    public ForgeDirection lastProvider;
    public ArrayList<ForgeDirection> validOutputs = new ArrayList();
    public int ticks = 0;
    public int recentlyFilledDelay;

    public CastingChannelLogic() {
        this.lastProvider = ForgeDirection.UNKNOWN;
        this.validOutputs.add(ForgeDirection.DOWN);
        this.validOutputs.add(ForgeDirection.NORTH);
        this.validOutputs.add(ForgeDirection.SOUTH);
        this.validOutputs.add(ForgeDirection.EAST);
        this.validOutputs.add(ForgeDirection.WEST);
        this.subTanks.put(ForgeDirection.NORTH, new FluidTank(36));
        this.subTanks.put(ForgeDirection.SOUTH, new FluidTank(36));
        this.subTanks.put(ForgeDirection.WEST, new FluidTank(36));
        this.subTanks.put(ForgeDirection.EAST, new FluidTank(36));
    }

    public void func_70316_g() {
        ++this.ticks;
        boolean flagActiveFaucet = false;
        TileEntity possibleFaucet = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        if (possibleFaucet != null && possibleFaucet instanceof FaucetLogic) {
            flagActiveFaucet = ((FaucetLogic)possibleFaucet).active;
        }
        if (this.ticks == 6 && !flagActiveFaucet) {
            this.distributeFluids();
        }
        if (this.ticks >= 12 && !flagActiveFaucet) {
            if (this.recentlyFilledDelay != 0) {
                --this.recentlyFilledDelay;
            }
            if (this.recentlyFilledDelay == 0 || this.lastProvider == ForgeDirection.UP) {
                this.outputFluids();
            }
            this.ticks = 0;
        }
    }

    public void changeOutputs(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        ForgeDirection toggle = ForgeDirection.UNKNOWN;
        if (side == 0 || side == 1) {
            if ((double)hitX > 0.3125 && (double)hitX < 0.6875 && hitZ > 0.0f && (double)hitZ < 0.3125) {
                toggle = ForgeDirection.NORTH;
            }
            if ((double)hitX > 0.3125 && (double)hitX < 0.6875 && (double)hitZ > 0.6875 && hitZ < 1.0f) {
                toggle = ForgeDirection.SOUTH;
            }
            if ((double)hitZ > 0.3125 && (double)hitZ < 0.6875 && hitX > 0.0f && (double)hitX < 0.3125) {
                toggle = ForgeDirection.WEST;
            }
            if ((double)hitZ > 0.3125 && (double)hitZ < 0.6875 && (double)hitX > 0.6875 && hitX < 1.0f) {
                toggle = ForgeDirection.EAST;
            }
            if (side == 0 && (double)hitX > 0.3125 && (double)hitX < 0.6875 && (double)hitZ > 0.3125 && (double)hitZ < 0.6875) {
                toggle = ForgeDirection.DOWN;
            }
        } else {
            if (side == 2) {
                if (hitX > 0.0f && (double)hitX < 0.3125) {
                    toggle = ForgeDirection.WEST;
                }
                if ((double)hitX > 0.6875 && hitX < 1.0f) {
                    toggle = ForgeDirection.EAST;
                }
            }
            if (side == 3) {
                if (hitX > 0.0f && (double)hitX < 0.3125) {
                    toggle = ForgeDirection.WEST;
                }
                if ((double)hitX > 0.6875 && hitX < 1.0f) {
                    toggle = ForgeDirection.EAST;
                }
            }
            if (side == 4) {
                if (hitZ > 0.0f && (double)hitZ < 0.3125) {
                    toggle = ForgeDirection.NORTH;
                }
                if ((double)hitZ > 0.6875 && hitZ < 1.0f) {
                    toggle = ForgeDirection.SOUTH;
                }
            }
            if (side == 5) {
                if (hitZ > 0.0f && (double)hitZ < 0.3125) {
                    toggle = ForgeDirection.NORTH;
                }
                if ((double)hitZ > 0.6875 && hitZ < 1.0f) {
                    toggle = ForgeDirection.SOUTH;
                }
            }
        }
        if (toggle != ForgeDirection.UNKNOWN && toggle != ForgeDirection.UP && (tile = this.field_70331_k.func_72796_p(this.field_70329_l + toggle.offsetX, this.field_70330_m + toggle.offsetY, this.field_70327_n + toggle.offsetZ)) instanceof IFluidHandler) {
            if (this.validOutputs.contains(toggle)) {
                this.validOutputs.remove(toggle);
                if (tile instanceof CastingChannelLogic && toggle != ForgeDirection.DOWN) {
                    ((CastingChannelLogic)tile).validOutputs.remove(toggle.getOpposite());
                }
            } else {
                this.validOutputs.add(toggle);
                if (tile instanceof CastingChannelLogic && toggle != ForgeDirection.DOWN && !((CastingChannelLogic)tile).validOutputs.contains(toggle.getOpposite())) {
                    ((CastingChannelLogic)tile).validOutputs.add(toggle.getOpposite());
                }
            }
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private void distributeFluids() {
        FluidTank inputTank;
        Set<ForgeDirection> connected = this.getOutputs().keySet();
        if (connected.contains(ForgeDirection.DOWN)) {
            connected.remove(ForgeDirection.DOWN);
        }
        if (connected.contains(this.lastProvider)) {
            connected.remove(this.lastProvider);
        }
        int output = Math.min(this.internalTank.getFluidAmount(), 12);
        int connectedAmount = connected.size();
        if (connectedAmount < 1) {
            connectedAmount = 1;
        }
        int scaledAmount = output / connectedAmount;
        for (ForgeDirection dirOut : connected) {
            if (this.internalTank.getFluid() == null) break;
            FluidStack tempFS = new FluidStack(this.internalTank.getFluid().getFluid(), scaledAmount);
            int fit = this.subTanks.get(dirOut).fill(tempFS, false);
            if (fit > 0) {
                fit = this.internalTank.drain((int)fit, (boolean)true).amount;
            }
            tempFS.amount = fit;
            fit = this.subTanks.get(dirOut).fill(tempFS, true);
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if ((inputTank = this.subTanks.get(this.lastProvider)) != null && inputTank.getFluid() != null) {
            FluidStack tempFS = new FluidStack(inputTank.getFluid().getFluid(), Math.min(inputTank.getFluidAmount(), 12));
            int fit = this.internalTank.fill(tempFS, false);
            if (fit > 0) {
                fit = inputTank.drain((int)fit, (boolean)true).amount;
            }
            tempFS.amount = fit;
            fit = this.internalTank.fill(tempFS, true);
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    private void outputFluids() {
        HashMap<ForgeDirection, TileEntity> connected = this.getOutputs();
        if (connected.containsKey(this.lastProvider)) {
            connected.remove(this.lastProvider);
        }
        if (connected.containsKey(ForgeDirection.DOWN) && this.internalTank.getFluid() != null) {
            int output = Math.min(this.internalTank.getFluid().amount, 12);
            FluidStack tempFS = new FluidStack(this.internalTank.getFluid().getFluid(), output);
            int fittingBelow = ((IFluidHandler)connected.get(ForgeDirection.DOWN)).fill(ForgeDirection.UP, tempFS, false);
            if (fittingBelow > 0) {
                fittingBelow = this.drain((ForgeDirection)ForgeDirection.DOWN, (int)fittingBelow, (boolean)true).amount;
            }
            tempFS.amount = fittingBelow;
            fittingBelow = ((IFluidHandler)connected.get(ForgeDirection.DOWN)).fill(ForgeDirection.UP, tempFS, true);
            connected.remove(ForgeDirection.DOWN);
        }
        if (connected.size() != 0) {
            for (ForgeDirection dir : connected.keySet()) {
                if (this.subTanks.get(dir) == null || this.subTanks.get(dir).getFluid() == null) continue;
                FluidStack tempFS = new FluidStack(this.subTanks.get(dir).getFluid().getFluid(), Math.min(this.subTanks.get(dir).getFluidAmount(), 12));
                int fit = ((IFluidHandler)connected.get(dir)).fill(dir.getOpposite(), tempFS, false);
                if (fit > 0) {
                    fit = this.drain((ForgeDirection)dir, (int)fit, (boolean)true).amount;
                }
                tempFS.amount = fit;
                fit = ((IFluidHandler)connected.get(dir)).fill(dir.getOpposite(), tempFS, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float tankBelow() {
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (te instanceof CastingChannelLogic) {
            return -0.5f;
        }
        if (te instanceof LavaTankLogic) {
            return -1.0f;
        }
        if (te instanceof CastingBasinLogic) {
            return -0.75f;
        }
        if (te instanceof CastingTableLogic) {
            return -0.125f;
        }
        if (te instanceof IFluidHandler) {
            return 0.0f;
        }
        return 0.5f;
    }

    public HashMap<ForgeDirection, TileEntity> getOutputs() {
        HashMap<ForgeDirection, TileEntity> map = new HashMap<ForgeDirection, TileEntity>();
        for (ForgeDirection fd : this.validOutputs) {
            int tX = this.field_70329_l + fd.offsetX;
            int tY = this.field_70330_m + fd.offsetY;
            int tZ = this.field_70327_n + fd.offsetZ;
            TileEntity tile = this.field_70331_k.func_72796_p(tX, tY, tZ);
            if (tile == null || !(tile instanceof IFluidHandler)) continue;
            map.put(fd, tile);
        }
        return map;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (doFill) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.lastProvider = from;
            if (this.internalTank.getFluid() == null) {
                this.recentlyFilledDelay = 2;
            }
        }
        if (from == ForgeDirection.UP) {
            return this.internalTank.fill(resource, doFill);
        }
        if (from == ForgeDirection.NORTH || from == ForgeDirection.SOUTH || from == ForgeDirection.WEST || from == ForgeDirection.EAST) {
            return this.subTanks.get(from).fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.DOWN) {
            return this.internalTank.drain(maxDrain, doDrain);
        }
        if (from == ForgeDirection.NORTH || from == ForgeDirection.SOUTH || from == ForgeDirection.WEST || from == ForgeDirection.EAST) {
            return this.subTanks.get(from).drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.DOWN) {
            return false;
        }
        if (from == ForgeDirection.UP) {
            return true;
        }
        return this.validOutputs.contains(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UP) {
            return false;
        }
        return this.validOutputs.contains(from);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == null || from == ForgeDirection.UP || from == ForgeDirection.DOWN || from == ForgeDirection.UNKNOWN) {
            return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.internalTank)};
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.subTanks.get(from))};
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        NBTTagCompound nbtTank = tags.func_74775_l("internalTank");
        if (nbtTank != null) {
            this.internalTank.readFromNBT(nbtTank);
        }
        for (ForgeDirection fdSub : this.subTanks.keySet()) {
            NBTTagCompound nbtSubTank = tags.func_74775_l("subTank_" + fdSub.name());
            if (nbtSubTank == null) continue;
            this.subTanks.get(fdSub).readFromNBT(nbtSubTank);
        }
        int[] validFDs = tags.func_74759_k("validOutputs");
        if (validFDs != null) {
            this.validOutputs = new ArrayList();
            for (int i : validFDs) {
                this.validOutputs.add(this.convertIntToFD(i));
            }
        }
        this.lastProvider = this.convertIntToFD(tags.func_74762_e("LastProvider"));
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        NBTTagCompound nbtTank = new NBTTagCompound();
        this.internalTank.writeToNBT(nbtTank);
        tags.func_74766_a("internalTank", nbtTank);
        for (ForgeDirection fdSub : this.subTanks.keySet()) {
            NBTTagCompound nbtSubTank = new NBTTagCompound();
            this.subTanks.get(fdSub).writeToNBT(nbtSubTank);
            tags.func_74766_a("subTank_" + fdSub.name(), nbtSubTank);
        }
        int[] validFDs = new int[this.validOutputs.size()];
        int it = 0;
        for (ForgeDirection fd : this.validOutputs) {
            if (fd != null) {
                validFDs[it] = this.convertFDToInt(fd);
            }
            ++it;
        }
        tags.func_74783_a("validOutputs", validFDs);
        tags.func_74768_a("LastProvider", this.convertFDToInt(this.lastProvider));
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int convertFDToInt(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return -1;
    }

    public ForgeDirection convertIntToFD(int i) {
        switch (i) {
            case 0: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.UP;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }
}

