/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.common.TContent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;

public class Battleaxe
extends HarvestTool {
    static Material[] materials = new Material[]{Material.field_76245_d, Material.field_76255_k, Material.field_76265_p, Material.field_76268_x, Material.field_76266_z};

    public Battleaxe(int itemID) {
        super(itemID, 4);
        this.func_77655_b("InfiTool.Battleaxe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    public boolean func_77660_a(ItemStack itemstack, World world, int bID, int x, int y, int z, EntityLivingBase player) {
        Block block = Block.field_71973_m[bID];
        if (block != null && block.field_72018_cp == Material.field_76257_i) {
            return false;
        }
        return AbilityHelper.onBlockChanged(itemstack, world, bID, x, y, z, player, this.random);
    }

    @Override
    public Item getHeadItem() {
        return TContent.broadAxeHead;
    }

    @Override
    public Item getHandleItem() {
        return TContent.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.broadAxeHead;
    }

    @Override
    public Item getExtraItem() {
        return TContent.toughBinding;
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public float getDurabilityModifier() {
        return 2.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_battleaxe_fronthead";
            }
            case 1: {
                return "_battleaxe_fronthead_broken";
            }
            case 2: {
                return "_battleaxe_handle";
            }
            case 3: {
                return "_battleaxe_backhead";
            }
            case 4: {
                return "_battleaxe_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_battleaxe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "battleaxe";
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"weapon", "harvest", "melee", "slicing"};
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int useCount) {
        int time = this.func_77626_a(stack) - useCount;
        int boost = time / 100;
        if (boost > 2) {
            boost = 2;
        }
        player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, time * 4, boost));
        player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, time * 4, boost));
        player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, time * 4, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, time * 2, 0));
        if (time > 5 && player.field_70122_E) {
            float increase;
            player.func_71020_j(0.2f);
            player.func_70031_b(true);
            float speed = 0.025f * (float)time;
            if (speed > 0.925f) {
                speed = 0.925f;
            }
            if ((increase = (float)(0.02 * (double)time + 0.2)) > 0.56f) {
                increase = 0.56f;
            }
            player.field_70181_x += (double)increase;
            player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
            player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        AbilityHelper.knockbackEntity(mob, 1.5);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this) {
            player.field_71158_b.field_78900_b *= 5.0f;
            player.field_71158_b.field_78902_a *= 5.0f;
        }
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        World world = player.field_70170_p;
        int woodID = world.func_72798_a(x, y, z);
        Block wood = Block.field_71973_m[woodID];
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int meta = world.func_72805_g(x, y, z);
        for (int yPos = y + 1; yPos < y + 9; ++yPos) {
            int blockID = world.func_72798_a(x, yPos, z);
            Block block = Block.field_71973_m[blockID];
            if (tags.func_74767_n("Broken") || block == null || block.field_72018_cp != Material.field_76245_d) break;
            int localblockID = world.func_72798_a(x, yPos, z);
            int localMeta = world.func_72805_g(x, yPos, z);
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            if (hlvl > tags.func_74762_e("HarvestLevel")) continue;
            boolean cancelHarvest = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.beforeBlockBreak(this, stack, x, yPos, z, (EntityLivingBase)player)) continue;
                cancelHarvest = true;
            }
            if (cancelHarvest || block == null || block.field_72018_cp != Material.field_76245_d) continue;
            localMeta = world.func_72805_g(x, yPos, z);
            if (!player.field_71075_bZ.field_75098_d) {
                if (block.removeBlockByPlayer(world, player, x, yPos, z)) {
                    block.func_71898_d(world, x, yPos, z, localMeta);
                }
                block.func_71893_a(world, player, x, yPos, z, localMeta);
                block.func_71846_a(world, x, yPos, z, localMeta, player);
                this.func_77660_a(stack, world, localblockID, x, yPos, z, (EntityLivingBase)player);
                continue;
            }
            world.func_94571_i(x, yPos, z);
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, woodID + (meta << 12));
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @Override
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        return false;
    }

    @Override
    public boolean isOffhandHandDual(ItemStack off) {
        return false;
    }

    @Override
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Override
    public boolean willAllowOffhandWeapon() {
        return false;
    }

    @Override
    public boolean willAllowShield() {
        return false;
    }

    @Override
    public boolean isOffhandHandDualWeapon() {
        return false;
    }

    @Override
    public boolean sheatheOnBack() {
        return true;
    }
}

