/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorMod;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.tools.ToolMod;
import tconstruct.library.util.IToolPart;

public class ToolBuilder {
    public static ToolBuilder instance = new ToolBuilder();
    public HashMap<String, ToolRecipe> recipeList = new HashMap();
    public List<ToolRecipe> combos = new ArrayList<ToolRecipe>();
    public HashMap<String, String> modifiers = new HashMap();
    public List<ToolMod> toolMods = new ArrayList<ToolMod>();
    public List<ArmorMod> armorMods = new ArrayList<ArmorMod>();

    public static void addNormalToolRecipe(ToolCore output, Item head, Item handle) {
        ToolRecipe recipe = ToolBuilder.instance.recipeList.get(output.getToolName());
        if (recipe != null) {
            recipe.addHeadItem(head);
            recipe.addHandleItem(handle);
        } else {
            recipe = new ToolRecipe(head, handle, output);
            ToolBuilder.instance.combos.add(recipe);
            ToolBuilder.instance.recipeList.put(output.getToolName(), recipe);
        }
    }

    public static void addNormalToolRecipe(ToolCore output, Item head, Item handle, Item accessory) {
        ToolRecipe recipe = ToolBuilder.instance.recipeList.get(output.getToolName());
        if (recipe != null) {
            recipe.addHeadItem(head);
            recipe.addHandleItem(handle);
            recipe.addAccessoryItem(accessory);
        } else {
            recipe = new ToolRecipe(head, handle, accessory, output);
            ToolBuilder.instance.combos.add(recipe);
            ToolBuilder.instance.recipeList.put(output.getToolName(), recipe);
        }
    }

    public static void addNormalToolRecipe(ToolCore output, Item head, Item handle, Item accessory, Item extra) {
        ToolRecipe recipe = ToolBuilder.instance.recipeList.get(output.getToolName());
        if (recipe != null) {
            recipe.addHeadItem(head);
            recipe.addHandleItem(handle);
            recipe.addAccessoryItem(accessory);
            recipe.addExtraItem(extra);
        } else {
            recipe = new ToolRecipe(head, handle, accessory, extra, output);
            ToolBuilder.instance.combos.add(recipe);
            ToolBuilder.instance.recipeList.put(output.getToolName(), recipe);
        }
    }

    public static void addCustomToolRecipe(ToolRecipe recipe) {
        ToolBuilder.instance.combos.add(recipe);
    }

    public static void addToolRecipe(ToolCore output, Item ... items) {
        if (items.length == 2) {
            ToolBuilder.addNormalToolRecipe(output, items[0], items[1]);
        }
        if (items.length == 3) {
            ToolBuilder.addNormalToolRecipe(output, items[0], items[1], items[2]);
        }
        if (items.length == 4) {
            ToolBuilder.addNormalToolRecipe(output, items[0], items[1], items[2], items[3]);
        }
    }

    public ToolCore getMatchingRecipe(Item head, Item handle, Item accessory, Item extra) {
        for (ToolRecipe recipe : this.combos) {
            if (!recipe.validHead(head) || !recipe.validHandle(handle) || !recipe.validAccessory(accessory) || !recipe.validExtra(extra)) continue;
            return recipe.getType();
        }
        return null;
    }

    public ItemStack buildTool(ItemStack headStack, ItemStack handleStack, ItemStack accessoryStack, String name) {
        return this.buildTool(headStack, handleStack, accessoryStack, null, name);
    }

    public int getMaterialID(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        Item item = stack.func_77973_b();
        if (item == Item.field_77669_D) {
            return 0;
        }
        if (item == Item.field_77755_aX) {
            return 5;
        }
        if (item instanceof IToolPart) {
            return ((IToolPart)item).getMaterialID(stack);
        }
        return -1;
    }

    public ItemStack buildTool(ItemStack headStack, ItemStack handleStack, ItemStack accessoryStack, ItemStack extraStack, String name) {
        ToolCore item;
        if (headStack != null && headStack.func_77973_b() instanceof ToolCore) {
            return this.modifyTool(headStack, handleStack, accessoryStack, extraStack, name);
        }
        if (headStack == null || handleStack == null) {
            return null;
        }
        boolean validMaterials = true;
        int head = -1;
        int handle = -1;
        int accessory = -1;
        int extra = -1;
        head = this.getMaterialID(headStack);
        if (head == -1) {
            validMaterials = false;
        }
        if ((handle = this.getMaterialID(handleStack)) == -1) {
            validMaterials = false;
        }
        if (!validMaterials) {
            return null;
        }
        if (accessoryStack == null) {
            item = this.getMatchingRecipe(headStack.func_77973_b(), handleStack.func_77973_b(), null, null);
        } else {
            accessory = this.getMaterialID(accessoryStack);
            if (accessory == -1) {
                return null;
            }
            if (extraStack != null) {
                extra = this.getMaterialID(extraStack);
                if (extra == -1) {
                    return null;
                }
                item = this.getMatchingRecipe(headStack.func_77973_b(), handleStack.func_77973_b(), accessoryStack.func_77973_b(), extraStack.func_77973_b());
            } else {
                item = this.getMatchingRecipe(headStack.func_77973_b(), handleStack.func_77973_b(), accessoryStack.func_77973_b(), null);
            }
        }
        if (item == null) {
            return null;
        }
        ToolMaterial headMat = null;
        ToolMaterial handleMat = null;
        ToolMaterial accessoryMat = null;
        ToolMaterial extraMat = null;
        headMat = TConstructRegistry.getMaterial(head);
        handleMat = TConstructRegistry.getMaterial(handle);
        if (accessory != -1) {
            accessoryMat = TConstructRegistry.getMaterial(accessory);
        }
        if (extra != -1) {
            extraMat = TConstructRegistry.getMaterial(extra);
        }
        int durability = headMat.durability();
        int heads = 1;
        int handles = 0;
        float modifier = 1.0f;
        int attack = headMat.attack();
        if (item.durabilityTypeHandle() == 2) {
            ++heads;
            durability += handleMat.durability();
            attack += handleMat.attack();
        } else if (item.durabilityTypeHandle() == 1) {
            ++handles;
            modifier = handleMat.handleDurability();
        }
        if (accessory != -1) {
            if (item.durabilityTypeAccessory() == 2) {
                ++heads;
                durability += accessoryMat.durability();
                attack += accessoryMat.attack();
            } else if (item.durabilityTypeAccessory() == 1) {
                ++handles;
                modifier += accessoryMat.handleDurability();
            }
        }
        if (extra != -1) {
            if (item.durabilityTypeExtra() == 2) {
                ++heads;
                durability += extraMat.durability();
                attack += extraMat.attack();
            } else if (item.durabilityTypeExtra() == 1) {
                ++handles;
                modifier += extraMat.handleDurability();
            }
        }
        if (handles > 0) {
            modifier = (float)((double)modifier * (0.5 + (double)handles * 0.5));
            modifier /= (float)handles;
        }
        durability = (int)((double)(durability / heads) * (0.5 + (double)heads * 0.5) * (double)modifier * (double)item.getDurabilityModifier());
        if ((attack = attack / heads + item.getDamageVsEntity(null)) % heads != 0) {
            ++attack;
        }
        Object tool = new ItemStack((Item)item);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74766_a("InfiTool", new NBTTagCompound());
        compound.func_74775_l("InfiTool").func_74768_a("Head", head);
        compound.func_74775_l("InfiTool").func_74768_a("RenderHead", head);
        compound.func_74775_l("InfiTool").func_74768_a("Handle", handle);
        compound.func_74775_l("InfiTool").func_74768_a("RenderHandle", handle);
        if (accessory != -1) {
            compound.func_74775_l("InfiTool").func_74768_a("Accessory", accessory);
            compound.func_74775_l("InfiTool").func_74768_a("RenderAccessory", accessory);
        }
        if (extra != -1) {
            compound.func_74775_l("InfiTool").func_74768_a("Extra", extra);
            compound.func_74775_l("InfiTool").func_74768_a("RenderExtra", extra);
        }
        compound.func_74775_l("InfiTool").func_74768_a("Damage", 0);
        compound.func_74775_l("InfiTool").func_74768_a("TotalDurability", durability);
        compound.func_74775_l("InfiTool").func_74768_a("BaseDurability", durability);
        compound.func_74775_l("InfiTool").func_74768_a("BonusDurability", 0);
        compound.func_74775_l("InfiTool").func_74776_a("ModDurability", 0.0f);
        compound.func_74775_l("InfiTool").func_74757_a("Broken", false);
        compound.func_74775_l("InfiTool").func_74768_a("Attack", attack);
        compound.func_74775_l("InfiTool").func_74768_a("MiningSpeed", headMat.toolSpeed());
        compound.func_74775_l("InfiTool").func_74768_a("HarvestLevel", headMat.harvestLevel());
        if (item.durabilityTypeHandle() == 2) {
            compound.func_74775_l("InfiTool").func_74768_a("MiningSpeedHandle", handleMat.toolSpeed());
            compound.func_74775_l("InfiTool").func_74768_a("HarvestLevelHandle", handleMat.harvestLevel());
        }
        if (accessory != -1 && item.durabilityTypeAccessory() == 2) {
            compound.func_74775_l("InfiTool").func_74768_a("MiningSpeed2", accessoryMat.toolSpeed());
            compound.func_74775_l("InfiTool").func_74768_a("HarvestLevel2", accessoryMat.harvestLevel());
        }
        if (extra != -1 && item.durabilityTypeExtra() == 2) {
            compound.func_74775_l("InfiTool").func_74768_a("MiningSpeedExtra", extraMat.toolSpeed());
            compound.func_74775_l("InfiTool").func_74768_a("HarvestLevelExtra", extraMat.harvestLevel());
        }
        compound.func_74775_l("InfiTool").func_74768_a("Unbreaking", this.buildReinforced(headMat, handleMat, accessoryMat, extraMat));
        compound.func_74775_l("InfiTool").func_74776_a("Shoddy", this.buildShoddy(headMat, handleMat, accessoryMat, extraMat));
        int modifiers = item.getModifierAmount();
        modifiers = accessory == -1 ? (modifiers += head == 9 ? 2 : 0) : (modifiers += (head == 9 ? 1 : 0) + (accessory == 9 ? 1 : 0));
        modifiers += handle == 9 ? 1 : 0;
        compound.func_74775_l("InfiTool").func_74768_a("Modifiers", modifiers += extra == 9 ? 1 : 0);
        if (name != null && !name.equals("")) {
            compound.func_74766_a("display", new NBTTagCompound());
            compound.func_74775_l("display").func_74778_a("Name", "\u00a7f" + name);
        }
        ToolCraftEvent.NormalTool event = new ToolCraftEvent.NormalTool(item, compound, new ToolMaterial[]{headMat, handleMat, accessoryMat, extraMat});
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DEFAULT) {
            tool.func_77982_d(compound);
        } else {
            tool = event.getResult() == Event.Result.ALLOW ? event.getResultStack() : null;
        }
        return tool;
    }

    @Deprecated
    public ItemStack modifyTool(ItemStack input, ItemStack topSlot, ItemStack bottomSlot, ItemStack extraStack, String name) {
        if (extraStack != null) {
            return null;
        }
        ItemStack tool = input.func_77946_l();
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_82580_o("Built");
        if (topSlot == null && bottomSlot == null) {
            return tool;
        }
        boolean built = false;
        for (ToolMod mod : this.toolMods) {
            ItemStack[] slots;
            if (!mod.matches(slots = new ItemStack[]{topSlot, bottomSlot}, tool)) continue;
            built = true;
            mod.addMatchingEffect(tool);
            mod.modify(slots, tool);
        }
        tags = tool.func_77978_p();
        if (name != null && !name.equals("") && !tags.func_74764_b("display")) {
            tags.func_74766_a("display", new NBTTagCompound());
            tags.func_74775_l("display").func_74778_a("Name", "\u00a7f" + name);
        }
        if (built) {
            return tool;
        }
        return null;
    }

    public ItemStack modifyTool(ItemStack input, ItemStack[] slots, String name) {
        ItemStack tool = input.func_77946_l();
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_82580_o("Built");
        boolean built = false;
        for (ToolMod mod : this.toolMods) {
            if (!mod.matches(slots, tool)) continue;
            built = true;
            mod.addMatchingEffect(tool);
            mod.modify(slots, tool);
        }
        tags = tool.func_77978_p();
        if (name != null && !name.equals("") && !tags.func_74764_b("display")) {
            tags.func_74766_a("display", new NBTTagCompound());
            tags.func_74775_l("display").func_74778_a("Name", "\u00a7f" + name);
        }
        if (built) {
            return tool;
        }
        return null;
    }

    public ItemStack modifyArmor(ItemStack input, ItemStack[] slots, String name) {
        ItemStack armor = input.func_77946_l();
        if (!armor.func_77942_o()) {
            this.addArmorTag(input);
        }
        NBTTagCompound tags = armor.func_77978_p().func_74775_l("TinkerArmor");
        tags.func_82580_o("Built");
        boolean built = false;
        for (ArmorMod mod : this.armorMods) {
            if (!mod.matches(slots, armor)) continue;
            built = true;
            mod.addMatchingEffect(armor);
            mod.modify(slots, armor);
        }
        tags = armor.func_77978_p();
        if (name != null && !name.equals("") && !tags.func_74764_b("display")) {
            tags.func_74766_a("display", new NBTTagCompound());
            tags.func_74775_l("display").func_74778_a("Name", "\u00a7f" + name);
        }
        if (built) {
            return armor;
        }
        return null;
    }

    public void addArmorTag(ItemStack armor) {
        NBTTagCompound baseTag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        NBTTagCompound armorTag = new NBTTagCompound();
        armorTag.func_74768_a("Modifiers", 30);
        baseTag.func_74782_a("TinkerArmor", (NBTBase)armorTag);
        armor.func_77982_d(baseTag);
    }

    int buildReinforced(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat, ToolMaterial extraMat) {
        int reinforced = 0;
        int dHead = headMat.reinforced();
        int dHandle = handleMat.reinforced();
        int dAccessory = 0;
        if (accessoryMat != null) {
            dAccessory = accessoryMat.reinforced();
        }
        int dExtra = 0;
        if (extraMat != null) {
            dExtra = extraMat.reinforced();
        }
        if (dHead > reinforced) {
            reinforced = dHead;
        }
        if (dHandle > reinforced) {
            reinforced = dHandle;
        }
        if (dAccessory > reinforced) {
            reinforced = dAccessory;
        }
        if (dExtra > reinforced) {
            reinforced = dExtra;
        }
        return reinforced;
    }

    float buildShoddy(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat, ToolMaterial extraMat) {
        float sHead = headMat.shoddy();
        float sHandle = handleMat.shoddy();
        if (extraMat != null) {
            float sAccessory = accessoryMat.shoddy();
            float sExtra = extraMat.shoddy();
            return (sHead + sHandle + sAccessory + sExtra) / 4.0f;
        }
        if (accessoryMat != null) {
            float sAccessory = accessoryMat.shoddy();
            return (sHead + sHandle + sAccessory) / 3.0f;
        }
        return (sHead + sHandle) / 2.0f;
    }

    public static void registerToolMod(ToolMod mod) {
        if (mod == null) {
            throw new NullPointerException("Tool modifier cannot be null.");
        }
        ToolBuilder.instance.toolMods.add(mod);
    }

    public static void registerArmorMod(ArmorMod mod) {
        if (mod == null) {
            throw new NullPointerException("Armor modifier cannot be null.");
        }
        ToolBuilder.instance.armorMods.add(mod);
    }
}

