/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;

public abstract class ToolMod {
    public final String key;
    public final List stacks;
    public final int effectIndex;
    public static Random random = new Random();

    public ToolMod(ItemStack[] items, int effect, String dataKey) {
        ArrayList<ItemStack> itemstacks = new ArrayList<ItemStack>();
        for (int iter = 0; iter < items.length; ++iter) {
            itemstacks.add(items[iter]);
        }
        this.stacks = itemstacks;
        this.effectIndex = effect;
        this.key = dataKey;
    }

    public boolean matches(ItemStack[] input, ItemStack tool) {
        if (!this.canModify(tool, input)) {
            return false;
        }
        ArrayList list = new ArrayList(this.stacks);
        for (int iter = 0; iter < input.length; ++iter) {
            ItemStack craftingStack = input[iter];
            if (craftingStack == null) continue;
            boolean canCraft = false;
            for (ItemStack removeStack : list) {
                if (craftingStack.field_77993_c != removeStack.field_77993_c || removeStack.func_77960_j() != Short.MAX_VALUE && craftingStack.func_77960_j() != removeStack.func_77960_j()) continue;
                canCraft = true;
                list.remove(removeStack);
                break;
            }
            if (canCraft) continue;
            return false;
        }
        return list.isEmpty();
    }

    protected String getTagName() {
        return "InfiTool";
    }

    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        return tags.func_74762_e("Modifiers") > 0;
    }

    public abstract void modify(ItemStack[] var1, ItemStack var2);

    public void addMatchingEffect(ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        if (tags.func_74764_b("Effect6") || tags.func_74764_b(this.key)) {
            return;
        }
        if (tags.func_74764_b("Effect5")) {
            tags.func_74768_a("Effect6", this.effectIndex);
        } else if (tags.func_74764_b("Effect4")) {
            tags.func_74768_a("Effect5", this.effectIndex);
        } else if (tags.func_74764_b("Effect3")) {
            tags.func_74768_a("Effect4", this.effectIndex);
        } else if (tags.func_74764_b("Effect2")) {
            tags.func_74768_a("Effect3", this.effectIndex);
        } else if (tags.func_74764_b("Effect1")) {
            tags.func_74768_a("Effect2", this.effectIndex);
        } else {
            tags.func_74768_a("Effect1", this.effectIndex);
        }
    }

    protected int addModifierTip(ItemStack tool, String modifierTip) {
        String tip;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        int tipNum = 0;
        while (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) {
        }
        tags.func_74778_a(tip, "");
        String modTip = "ModifierTip" + tipNum;
        tags.func_74778_a(modTip, modifierTip);
        return tipNum;
    }

    protected int addToolTip(ItemStack tool, String tooltip, String modifierTip) {
        String tip;
        String tag;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        int tipNum = 0;
        do {
            if (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) continue;
            tags.func_74778_a(tip, tooltip);
            String modTip = "ModifierTip" + tipNum;
            tags.func_74778_a(modTip, modifierTip);
            return tipNum;
        } while (!(tag = tags.func_74779_i(tip)).contains(tooltip));
        tags.func_74778_a(tip, this.getProperName(tooltip, tag));
        String modTip = "ModifierTip" + tipNum;
        tag = tags.func_74779_i(modTip);
        tags.func_74778_a(modTip, this.getProperName(modifierTip, tag));
        return tipNum;
    }

    protected String getProperName(String tooltip, String tag) {
        if (tag.equals(tooltip)) {
            return tooltip + " II";
        }
        if (tag.equals(tooltip + " II")) {
            return tooltip + " III";
        }
        if (tag.equals(tooltip + " III")) {
            return tooltip + " IV";
        }
        if (tag.equals(tooltip + " IV")) {
            return tooltip + " V";
        }
        if (tag.equals(tooltip + " V")) {
            return tooltip + " VI";
        }
        if (tag.equals(tooltip + " VI")) {
            return tooltip + " VII";
        }
        if (tag.equals(tooltip + " VII")) {
            return tooltip + " VIII";
        }
        if (tag.equals(tooltip + " VIII")) {
            return tooltip + " IX";
        }
        if (tag.equals(tooltip + " IX")) {
            return tooltip + " X";
        }
        return tooltip + " X+";
    }

    public boolean validType(ToolCore tool) {
        return true;
    }

    public boolean areItemsEquivalent(ItemStack stack1, ItemStack stack2) {
        if (stack1.field_77993_c != stack2.field_77993_c) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public boolean areItemStacksEquivalent(ItemStack stack1, ItemStack stack2) {
        if (stack1.field_77993_c != stack2.field_77993_c) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

