/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorModTypeFilter;
import tconstruct.library.armor.EnumArmorPart;

public class AModKnockbackResistance
extends ArmorModTypeFilter {
    final boolean modifierType;
    final int modifyAmount = 2;
    private static final UUID head = UUID.fromString("4188779d-69d4-487c-b307-c4c182522c44");
    private static final UUID chest = UUID.fromString("4188779d-69d4-487c-b307-c4c182522c45");
    private static final UUID pants = UUID.fromString("4188779d-69d4-487c-b307-c4c182522c46");
    private static final UUID shoes = UUID.fromString("4188779d-69d4-487c-b307-c4c182522c47");

    public AModKnockbackResistance(int effect, EnumSet<EnumArmorPart> armorTypes, ItemStack[] items, int[] values, boolean type) {
        super(effect, "ExoKnockback" + (type ? "Percent" : "Flat"), armorTypes, items, values);
        this.modifierType = type;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        int amount = this.matchingItems(input) * 2;
        return tags.func_74762_e("Modifiers") >= amount;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack armor) {
        NBTTagList attributes;
        NBTTagCompound baseTag = armor.func_77978_p();
        NBTTagCompound armorTag = armor.func_77978_p().func_74775_l(this.getTagName());
        int modifiers = armorTag.func_74762_e("Modifiers");
        armorTag.func_74768_a("Modifiers", modifiers -= this.matchingAmount(input) * 2);
        int amount = this.matchingAmount(input);
        if (armorTag.func_74764_b(this.key)) {
            amount += armorTag.func_74762_e(this.key);
        }
        armorTag.func_74768_a(this.key, amount);
        if (baseTag.func_74764_b("AttributeModifiers")) {
            attributes = baseTag.func_74761_m("AttributeModifiers");
            for (int iter = 0; iter < attributes.func_74745_c(); ++iter) {
                NBTTagCompound tag = (NBTTagCompound)attributes.func_74743_b(iter);
                if (!tag.func_74779_i("AttributeName").equals("generic.knockbackResistance")) continue;
                attributes.func_74744_a(iter);
            }
        } else {
            attributes = new NBTTagList();
            baseTag.func_74782_a("AttributeModifiers", (NBTBase)attributes);
        }
        attributes.func_74742_a((NBTBase)this.getAttributeTag("generic.knockbackResistance", this.key, (double)amount * 0.01, this.modifierType, this.getUUIDFromItem(armor)));
    }

    UUID getUUIDFromItem(ItemStack stack) {
        ArmorCore item = (ArmorCore)stack.func_77973_b();
        switch (item.armorPart) {
            case HELMET: {
                return head;
            }
            case CHEST: {
                return chest;
            }
            case PANTS: {
                return pants;
            }
            case SHOES: {
                return shoes;
            }
        }
        return null;
    }
}

