/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.EnumMobType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.LandmineExplodeLogic;
import tconstruct.blocks.logic.TileEntityLandmine;
import tconstruct.client.block.RenderLandmine;
import tconstruct.common.TProxyCommon;
import tconstruct.util.landmine.Helper;

public class BlockLandmine
extends BlockContainer {
    boolean explodeOnBroken = false;

    public BlockLandmine(int par1) {
        super(par1, Material.field_76262_s);
        this.func_71907_b(true);
        this.func_71905_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.0625f, 0.9375f);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityLandmine te;
        if (world.func_72798_a(x, y, z) == this.field_71990_ca && world.func_72796_p(x, y, z) instanceof TileEntityLandmine && (te = (TileEntityLandmine)world.func_72796_p(x, y, z)) != null && te.func_70301_a(3) != null) {
            return field_71984_q[te.func_70301_a((int)3).field_77993_c];
        }
        return super.getLightValue(world, x, y, z);
    }

    public int func_71859_p_(World par1World) {
        return 20;
    }

    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntityLandmine te = (TileEntityLandmine)par1IBlockAccess.func_72796_p(par2, par3, par4);
        ItemStack camo = te.func_70301_a(3);
        if (camo != null && camo.field_77993_c < field_71973_m.length) {
            return Block.field_71973_m[camo.field_77993_c].func_71858_a(par5, camo.func_77960_j());
        }
        return this.func_71858_a(par5, par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return RenderLandmine.model;
    }

    public void func_71921_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        super.func_71921_a(par1World, par2, par3, par4, par5EntityPlayer);
        if (this.explodeOnBroken) {
            this.checkExplosion(par1World, par2, par3, par4, true);
        }
    }

    public void func_94332_a(IconRegister par1IconRegister) {
        this.field_94336_cN = par1IconRegister.func_94245_a("tinker:Landmine");
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        par5EntityPlayer.openGui((Object)TConstruct.instance, TProxyCommon.landmineID, par1World, par2, par3, par4);
        return true;
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        TileEntityLandmine tileentity = (TileEntityLandmine)par1World.func_72796_p(par2, par3, par4);
        int metadata = par1World.func_72805_g(par2, par3, par4);
        if (!(tileentity == null || this.explodeOnBroken && this.hasItems(par1World, par2, par3, par4) || par6 == 193 || tileentity.isExploding)) {
            int id = this.field_71990_ca;
            if (id > 0) {
                ItemStack is = new ItemStack(id, 1, this.func_71899_b(tileentity.triggerType));
                if (tileentity.func_94042_c()) {
                    is.func_82834_c(tileentity.func_70303_b());
                }
                this.func_71929_a(par1World, par2, par3, par4, new ItemStack(id, 1, this.func_71899_b(tileentity.triggerType)));
            }
            for (int j1 = 0; j1 < tileentity.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileentity.func_70301_a(j1);
                if (itemstack == null) continue;
                while (itemstack.field_77994_a > 0) {
                    int ss = itemstack.field_77994_a;
                    itemstack.field_77994_a -= ss;
                    EntityItem entityitem = new EntityItem(par1World, (double)par2, (double)par3, (double)par4, new ItemStack(itemstack.field_77993_c, ss, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = f3;
                    entityitem.field_70181_x = f3 + 0.2f;
                    entityitem.field_70179_y = f3;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_96440_m(par2, par3, par4, par5);
        } else if (this.explodeOnBroken) {
            this.checkExplosion(par1World, par2, par3, par4, true);
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
    }

    public boolean func_71918_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public boolean func_71850_a_(World par1World, int par2, int par3, int par4, int par5) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)par5);
        return dir == ForgeDirection.DOWN && par1World.isBlockSolidOnSide(par2, par3 + 1, par4, ForgeDirection.DOWN) || dir == ForgeDirection.UP && par1World.isBlockSolidOnSide(par2, par3 - 1, par4, ForgeDirection.UP) || dir == ForgeDirection.NORTH && par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST) || dir == ForgeDirection.EAST && par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST);
    }

    public boolean func_71930_b(World par1World, int par2, int par3, int par4) {
        return par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH) || par1World.isBlockSolidOnSide(par2, par3 - 1, par4, ForgeDirection.UP) || par1World.isBlockSolidOnSide(par2, par3 + 1, par4, ForgeDirection.DOWN);
    }

    public int func_85104_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int j1 = par9 & 8;
        int k1 = par9 & 7;
        int b0 = -1;
        if (par5 == 0 && par1World.isBlockSolidOnSide(par2, par3 + 1, par4, ForgeDirection.DOWN)) {
            b0 = 0;
        }
        if (par5 == 1 && par1World.isBlockSolidOnSide(par2, par3 - 1, par4, ForgeDirection.UP)) {
            b0 = 5;
        }
        if (par5 == 2 && par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH)) {
            b0 = 4;
        }
        if (par5 == 3 && par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH)) {
            b0 = 3;
        }
        if (par5 == 4 && par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST)) {
            b0 = 2;
        }
        if (par5 == 5 && par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST)) {
            b0 = 1;
        }
        return b0 + j1;
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = par1World.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        int j1 = l & 8;
        if (i1 == BlockLandmine.invertMetadata(1)) {
            if ((MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 1) == 0) {
                par1World.func_72921_c(par2, par3, par4, 5 | j1, 2);
            } else {
                par1World.func_72921_c(par2, par3, par4, 6 | j1, 2);
            }
        } else if (i1 == BlockLandmine.invertMetadata(0)) {
            if ((MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 1) == 0) {
                par1World.func_72921_c(par2, par3, par4, 7 | j1, 2);
            } else {
                par1World.func_72921_c(par2, par3, par4, 0 | j1, 2);
            }
        }
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityLandmine)par1World.func_72796_p(par2, par3, par4)).setGuiDisplayName(par6ItemStack.func_82833_r());
        }
    }

    public static int invertMetadata(int par0) {
        switch (par0) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void func_71863_a(World par1World, int par2, int par3, int par4, int par5) {
        this.checkPlacement(par1World, par2, par3, par4, par5);
        this.checkExplosion(par1World, par2, par3, par4, false);
    }

    public void checkPlacement(World par1World, int par2, int par3, int par4, int par5) {
        if (this.checkIfAttachedToBlock(par1World, par2, par3, par4)) {
            int i1 = par1World.func_72805_g(par2, par3, par4) & 7;
            boolean flag = false;
            if (!par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST) && i1 == 1) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST) && i1 == 2) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH) && i1 == 3) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH) && i1 == 4) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3 - 1, par4, ForgeDirection.UP) && i1 == 5) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3 - 1, par4, ForgeDirection.UP) && i1 == 6) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3 + 1, par4, ForgeDirection.DOWN) && i1 == 0) {
                flag = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3 + 1, par4, ForgeDirection.DOWN) && i1 == 7) {
                flag = true;
            }
            if (flag) {
                this.func_71897_c(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
                par1World.func_94571_i(par2, par3, par4);
            }
        }
    }

    private boolean checkIfAttachedToBlock(World par1World, int par2, int par3, int par4) {
        if (!this.func_71930_b(par1World, par2, par3, par4)) {
            this.func_71897_c(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
            par1World.func_94571_i(par2, par3, par4);
            return false;
        }
        return true;
    }

    public void func_71847_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.field_72995_K) {
            this.checkExplosion(par1World, par2, par3, par4, false);
        }
    }

    public void func_71869_a(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (!par1World.field_72995_K) {
            this.checkExplosion(par1World, par2, par3, par4, false);
        }
    }

    public void checkExplosion(World par1World, int par2, int par3, int par4, boolean skipCheck) {
        if ((skipCheck || this.getMineState(par1World, par2, par3, par4) > 0) && this.hasItems(par1World, par2, par3, par4)) {
            TileEntityLandmine te = (TileEntityLandmine)par1World.func_72796_p(par2, par3, par4);
            if (te.soundcountything <= 0) {
                par1World.func_72908_a((double)par2 + 0.5, (double)par3 + 0.1, (double)par4 + 0.5, "random.click", 0.3f, 0.6f);
                te.setSoundPlayed();
            }
            new LandmineExplodeLogic(par1World, par2, par3, par4, this.getMineTriggerer(par1World, par2, par3, par4)).explode();
        }
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    private boolean hasItems(World par1World, int par2, int par3, int par4) {
        TileEntityLandmine te = (TileEntityLandmine)par1World.func_72796_p(par2, par3, par4);
        return te != null && te.func_70301_a(0) != null || te.func_70301_a(1) != null || te.func_70301_a(2) != null;
    }

    protected int getMineState(World par1World, int par2, int par3, int par4) {
        EnumMobType triggerMobType;
        TileEntityLandmine te = (TileEntityLandmine)par1World.func_72796_p(par2, par3, par4);
        if (te == null) {
            return 0;
        }
        switch (te.triggerType) {
            case 0: {
                triggerMobType = EnumMobType.everything;
                break;
            }
            case 1: {
                triggerMobType = EnumMobType.mobs;
                break;
            }
            case 2: {
                triggerMobType = EnumMobType.players;
                break;
            }
            default: {
                triggerMobType = null;
            }
        }
        if (triggerMobType != null) {
            List list = null;
            if (triggerMobType == EnumMobType.everything) {
                list = par1World.func_72839_b((Entity)null, this.getSensitiveAABB(par1World, par2, par3, par4));
            }
            if (triggerMobType == EnumMobType.mobs) {
                list = par1World.func_72872_a(EntityLivingBase.class, this.getSensitiveAABB(par1World, par2, par3, par4));
            }
            if (triggerMobType == EnumMobType.players) {
                list = par1World.func_72872_a(EntityPlayer.class, this.getSensitiveAABB(par1World, par2, par3, par4));
            }
            if (list != null && !list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.func_82144_au()) continue;
                    return 1;
                }
            }
        }
        return par1World.func_72864_z(par2, par3, par4) ? 1 : 0;
    }

    protected AxisAlignedBB getSensitiveAABB(World par1World, int par2, int par3, int par4) {
        float f = 0.125f;
        int l = par1World.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        float minX = (float)par2 + f;
        float minY = par3;
        float minZ = (float)par4 + f;
        float maxX = (float)(par2 + 1) - f;
        float maxY = (float)par3 + 0.25f;
        float maxZ = (float)(par4 + 1) - f;
        ForgeDirection dir = Helper.convertMetaToForgeOrientation(i1);
        switch (dir) {
            case DOWN: {
                break;
            }
            case UP: {
                minY = (float)par3 + 0.75f;
                maxY = par3 + 1;
                break;
            }
            default: {
                minX = par2;
                minY = par3;
                minZ = par4;
                maxX = par2 + 1;
                maxY = par3 + 1;
                maxZ = par4 + 1;
            }
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public Entity getMineTriggerer(World par1World, int par2, int par3, int par4) {
        EnumMobType triggerMobType;
        TileEntityLandmine te = (TileEntityLandmine)par1World.func_72796_p(par2, par3, par4);
        if (te == null) {
            return null;
        }
        switch (te.triggerType) {
            case 0: {
                triggerMobType = EnumMobType.everything;
                break;
            }
            case 1: {
                triggerMobType = EnumMobType.mobs;
                break;
            }
            case 2: {
                triggerMobType = EnumMobType.players;
                break;
            }
            default: {
                triggerMobType = null;
            }
        }
        if (triggerMobType != null) {
            List list = null;
            if (triggerMobType == EnumMobType.everything) {
                list = par1World.func_72839_b((Entity)null, AxisAlignedBB.func_72332_a().func_72299_a((double)par2 + 0.0, (double)par3 + 0.0, (double)par4 + 0.0, (double)par2 + 1.0, (double)par3 + 1.0, (double)par4 + 1.0));
            }
            if (triggerMobType == EnumMobType.mobs) {
                list = par1World.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72332_a().func_72299_a((double)par2 + 0.0, (double)par3 + 0.0, (double)par4 + 0.0, (double)par2 + 1.0, (double)par3 + 1.0, (double)par4 + 1.0));
            }
            if (triggerMobType == EnumMobType.players) {
                list = par1World.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)par2 + 0.0, (double)par3 + 0.0, (double)par4 + 0.0, (double)par2 + 1.0, (double)par3 + 1.0, (double)par4 + 1.0));
            }
            if (list != null && !list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.func_82144_au()) continue;
                    return entity;
                }
            }
        }
        return new EntityTNTPrimed(par1World, (double)par2, (double)par3, (double)par4, (EntityLivingBase)null);
    }

    public boolean func_85103_a(Explosion par1Explosion) {
        return false;
    }

    public void func_71902_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int l = par1IBlockAccess.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        ForgeDirection dir = Helper.convertMetaToForgeOrientation(i1);
        switch (dir) {
            case DOWN: {
                this.func_71905_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.0625f, 0.9375f);
                break;
            }
            case UP: {
                this.func_71905_a(0.0625f, 0.9375f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
                break;
            }
            case NORTH: {
                this.func_71905_a(0.0625f, 0.0625f, 0.0f, 0.9375f, 0.9375f, 0.0625f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(0.0625f, 0.0625f, 0.9375f, 0.9375f, 0.9375f, 1.0f);
                break;
            }
            case EAST: {
                this.func_71905_a(0.9375f, 0.0625f, 0.0625f, 1.0f, 0.9375f, 0.9375f);
                break;
            }
            case WEST: {
                this.func_71905_a(0.0f, 0.0625f, 0.0625f, 0.0625f, 0.9375f, 0.9375f);
            }
        }
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityLandmine();
    }
}

