/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityLivingData;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.TConstruct;
import tconstruct.achievements.TAchievements;
import tconstruct.blocks.LiquidMetalFinite;
import tconstruct.blocks.TankAirBlock;
import tconstruct.common.TContent;
import tconstruct.entity.BlueSlime;
import tconstruct.items.tools.FryingPan;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.Weapon;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.player.TPlayerStats;

public class TEventHandler {
    Random random = new Random();
    private Object evt;

    @ForgeSubscribe
    public void craftTool(ToolCraftEvent.NormalTool event) {
        int modifiers;
        int accessory;
        int handle;
        int head;
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        if (PHConstruct.denyMattock && event.tool == TContent.mattock && !this.allowCrafting(head = toolTag.func_74762_e("Head"), handle = toolTag.func_74762_e("Handle"), accessory = toolTag.func_74762_e("Accessory"))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        int thaum = 0;
        if (toolTag.func_74762_e("Head") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Handle") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Accessory") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Extra") == 31) {
            ++thaum;
        }
        if (thaum >= 3 || !toolTag.func_74764_b("Accessory") && thaum >= 2) {
            modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", modifiers += 2);
        } else if (thaum >= 1) {
            modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", ++modifiers);
        }
        if (event.tool == TContent.shortbow) {
            BowMaterial top = TConstructRegistry.getBowMaterial(toolTag.func_74762_e("Head"));
            BowMaterial bottom = TConstructRegistry.getBowMaterial(toolTag.func_74762_e("Accessory"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(toolTag.func_74762_e("Handle"), BowstringMaterial.class);
            if (top != null && bottom != null && string != null) {
                if (toolTag.func_74762_e("Handle") == 1) {
                    int modifiers2 = toolTag.func_74762_e("Modifiers");
                    toolTag.func_74768_a("Modifiers", ++modifiers2);
                }
                int durability = (int)((float)((top.durability + bottom.durability) / 2) * string.durabilityModifier);
                toolTag.func_74768_a("TotalDurability", durability);
                toolTag.func_74768_a("BaseDurability", durability);
                int drawSpeed = (int)((float)((top.drawspeed + bottom.drawspeed) / 2) * string.drawspeedModifier);
                toolTag.func_74768_a("DrawSpeed", drawSpeed);
                toolTag.func_74768_a("BaseDrawSpeed", drawSpeed);
                float flightSpeed = (top.flightSpeedMax + bottom.flightSpeedMax) / 2.0f * string.flightSpeedModifier;
                toolTag.func_74776_a("FlightSpeed", flightSpeed);
            }
        }
        if (event.tool == TContent.arrow) {
            ArrowMaterial head2 = TConstructRegistry.getArrowMaterial(toolTag.func_74762_e("Head"));
            ArrowMaterial shaft = TConstructRegistry.getArrowMaterial(toolTag.func_74762_e("Handle"));
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(toolTag.func_74762_e("Accessory"), FletchingMaterial.class);
            if (head2 != null && shaft != null && fletching != null) {
                float mass = head2.mass / 5.0f + shaft.mass + fletching.mass;
                float shatter = (head2.breakChance + shaft.breakChance + fletching.breakChance) / 4.0f;
                float accuracy = (head2.accuracy + shaft.accuracy + fletching.accuracy) / 3.0f;
                ItemStack arrow = new ItemStack((Item)event.tool, 4);
                toolTag.func_74768_a("TotalDurability", 0);
                toolTag.func_74776_a("Mass", mass);
                toolTag.func_74776_a("BreakChance", shatter);
                toolTag.func_74776_a("Accuracy", accuracy);
                toolTag.func_74768_a("Unbreaking", 10);
                arrow.func_77982_d(event.toolTag);
                event.overrideResult(arrow);
            }
        }
    }

    private boolean allowCrafting(int head, int handle, int accessory) {
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        for (int i = 0; i < nonMetals.length; ++i) {
            if (head != nonMetals[i] && handle != nonMetals[i] && accessory != nonMetals[i]) continue;
            return false;
        }
        return true;
    }

    @ForgeSubscribe
    public void craftPart(PartBuilderEvent.NormalPart event) {
        ItemStack result;
        if (event.pattern.func_77973_b() == TContent.woodPattern && event.pattern.func_77960_j() == 23 && (result = TEventHandler.craftBowString(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
        if (event.pattern.func_77973_b() == TContent.woodPattern && event.pattern.func_77960_j() == 24 && (result = TEventHandler.craftFletching(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
    }

    public static ItemStack craftBowString(ItemStack stack) {
        if (stack.field_77994_a < 3) {
            return null;
        }
        BowstringMaterial mat = (BowstringMaterial)TConstructRegistry.getCustomMaterial(stack, BowstringMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static ItemStack craftFletching(ItemStack stack) {
        if (TEventHandler.matchesLeaves(stack)) {
            FletchingMaterial leaves = (FletchingMaterial)TConstructRegistry.getCustomMaterial(new ItemStack((Block)Block.field_71952_K), FletchingMaterial.class);
            return leaves.craftingItem.func_77946_l();
        }
        FletchingMaterial mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchingMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static boolean matchesLeaves(ItemStack stack) {
        if (stack.field_77993_c >= 4096) {
            return false;
        }
        Block block = Block.field_71973_m[stack.field_77993_c];
        return block != null && block.isLeaves(null, 0, 0, 0);
    }

    @ForgeSubscribe
    public void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entityLiving instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entityLiving).func_71045_bC()) != null && stack.func_77973_b() == TContent.cutlass && player.func_71039_bw()) {
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
        }
    }

    @ForgeSubscribe
    public void onLivingDrop(LivingDropsEvent event) {
        ItemStack stack;
        int i;
        EntityPlayer player;
        if (event.entityLiving == null) {
            return;
        }
        if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)event.source.func_76346_g()).func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof FryingPan) {
            for (i = 0; i < event.drops.size(); ++i) {
                ItemStack is = ((EntityItem)event.drops.get(i)).func_92059_d();
                if (FurnaceRecipes.func_77602_a().getSmeltingResult(is) == null || !(FurnaceRecipes.func_77602_a().getSmeltingResult(is).func_77973_b() instanceof ItemFood)) continue;
                NBTTagCompound stackCompound = is.func_77978_p();
                if (stackCompound == null) {
                    stackCompound = new NBTTagCompound();
                }
                stackCompound.func_74757_a("frypanKill", true);
                is.func_77982_d(stackCompound);
            }
        }
        if (this.random.nextInt(200) == 0 && event.entityLiving instanceof IMob && event.source.field_76373_n.equals("player")) {
            ItemStack dropStack = new ItemStack(TContent.heartCanister, 1, 1);
            EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_70293_c = 10;
            event.drops.add(entityitem);
        }
        if (event.entityLiving instanceof IBossDisplayData) {
            BlueSlime slime;
            if (event.entityLiving instanceof BlueSlime && (slime = (BlueSlime)event.entityLiving).getSlimeSize() < 8) {
                return;
            }
            int count = event.entityLiving instanceof EntityDragon ? 5 : 1;
            for (i = 0; i < count; ++i) {
                ItemStack dropStack = new ItemStack(TContent.heartCanister, 1, 3);
                EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
                entityitem.field_70293_c = 10;
                event.drops.add(entityitem);
            }
        }
        if (!event.entityLiving.func_70631_g_() && event.entityLiving.getClass() == EntityChicken.class) {
            int amount = this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + 1;
            for (int iter = 0; iter < amount; ++iter) {
                this.addDrops(event, new ItemStack(Item.field_77676_L, 1));
            }
        }
        if (event.recentlyHit) {
            if (event.entityLiving.getClass() == EntitySkeleton.class) {
                EntityPlayer player2;
                EntitySkeleton enemy = (EntitySkeleton)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player2 = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    int beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 10) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, enemy.func_82202_m()));
                    }
                }
                if (enemy.func_82202_m() == 1 && this.random.nextInt(Math.max(1, 5 - event.lootingLevel)) == 0) {
                    this.addDrops(event, new ItemStack(TContent.materials, 1, 8));
                }
            }
            if (event.entityLiving.getClass() == EntityZombie.class) {
                EntityPlayer player3;
                EntityZombie enemy = (EntityZombie)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player3 = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    int beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 10) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 2));
                    }
                }
            }
            if (event.entityLiving.getClass() == EntityCreeper.class) {
                EntityPlayer player4;
                EntityCreeper enemy = (EntityCreeper)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player4 = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    int beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 5) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 4));
                    }
                }
            }
        }
        if (event.entityLiving.getClass() == EntityGhast.class) {
            if (PHConstruct.uhcGhastDrops) {
                for (EntityItem o : event.drops) {
                    if (o.func_92059_d().field_77993_c != Item.field_77732_bp.field_77779_bT) continue;
                    o.func_92058_a(new ItemStack(Item.field_77717_p, 1));
                }
            } else {
                this.addDrops(event, new ItemStack(Item.field_77732_bp, 1));
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            TPlayerStats stats;
            EntityPlayer source;
            player = (EntityPlayer)event.entityLiving;
            if (PHConstruct.dropPlayerHeads) {
                ItemStack dropStack = new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 3);
                NBTTagCompound nametag = new NBTTagCompound();
                nametag.func_74778_a("SkullOwner", player.field_71092_bJ);
                dropStack.func_77982_d(nametag);
                this.addDrops(event, dropStack);
            } else if (event.source.field_76373_n.equals("player") && (stack = (source = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                int beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (stack.func_77973_b() == TContent.cleaver) {
                    beheading += 2;
                }
                if (beheading > 0 && this.random.nextInt(100) < beheading * 50) {
                    ItemStack dropStack = new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 3);
                    NBTTagCompound nametag = new NBTTagCompound();
                    nametag.func_74778_a("SkullOwner", player.field_71092_bJ);
                    dropStack.func_77982_d(nametag);
                    this.addDrops(event, dropStack);
                }
            }
            GameRules rules = player.field_70170_p.func_82736_K();
            if (!(rules != null && rules.func_82766_b("keepInventory") || (stats = TConstruct.playerTracker.getPlayerStats(player.field_71092_bJ)) == null)) {
                stats.armor.dropItems();
                stats.knapsack.dropItems();
            }
        }
    }

    @ForgeSubscribe
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayer murderer;
        ItemStack stack;
        Entity cause = event.source.func_76364_f();
        if (cause != null && cause instanceof EntityPlayer && (stack = (murderer = (EntityPlayer)cause).func_70694_bm()) != null && stack.func_77973_b() instanceof Weapon) {
            murderer.func_71064_a((StatBase)TAchievements.achievements.get("tconstruct.enemySlayer"), 1);
        }
    }

    void addDrops(LivingDropsEvent event, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
        entityitem.field_70293_c = 10;
        event.drops.add(entityitem);
    }

    @ForgeSubscribe
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase living = event.entityLiving;
        if (living.getClass() == EntitySpider.class && this.random.nextInt(100) == 0) {
            EntityCreeper creeper = new EntityCreeper(living.field_70170_p);
            TEventHandler.spawnEntityLiving(living.field_70165_t, living.field_70163_u + 1.0, living.field_70161_v, (EntityLiving)creeper, living.field_70170_p);
            if (living.field_70153_n != null) {
                creeper.func_70078_a(living.field_70153_n);
            } else {
                creeper.func_70078_a((Entity)living);
            }
            EntityXPOrb orb = new EntityXPOrb(living.field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, this.random.nextInt(20) + 20);
            orb.func_70078_a((Entity)creeper);
        }
    }

    public static void spawnEntityLiving(double x, double y, double z, EntityLiving entity, World world) {
        if (!world.field_72995_K) {
            entity.func_70107_b(x, y, z);
            entity.func_110161_a((EntityLivingData)null);
            world.func_72838_d((Entity)entity);
        }
    }

    @ForgeSubscribe
    public void bonemealEvent(BonemealEvent event) {
        if (!event.world.field_72995_K && event.ID == TContent.slimeSapling.field_71990_ca && TContent.slimeSapling.boneFertilize(event.world, event.X, event.Y, event.Z, event.world.field_73012_v, event.entityPlayer)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @ForgeSubscribe
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        if (evt.Name == "crystalQuartz") {
            TContent.modAttack.addStackToMatchList(evt.Ore, 2);
        } else if (evt.Name == "crystalCerusQuartz") {
            TContent.modAttack.addStackToMatchList(evt.Ore, 24);
        }
    }

    @ForgeSubscribe
    public void bucketFill(FillBucketEvent evt) {
        if (evt.current.func_77973_b() == Item.field_77788_aw && evt.target.field_72313_a == EnumMovingObjectType.TILE) {
            int hitX = evt.target.field_72311_b;
            int hitY = evt.target.field_72312_c;
            int hitZ = evt.target.field_72309_d;
            if (evt.entityPlayer != null && !evt.entityPlayer.func_82247_a(hitX, hitY, hitZ, evt.target.field_72310_e, evt.current)) {
                return;
            }
            int bID = evt.world.func_72798_a(hitX, hitY, hitZ);
            for (int id = 0; id < TContent.fluidBlocks.length; ++id) {
                if (bID != TContent.fluidBlocks[id].field_71990_ca) continue;
                if (evt.entityPlayer.field_71075_bZ.field_75098_d) {
                    evt.world.func_94571_i(hitX, hitY, hitZ);
                    continue;
                }
                if (TContent.fluidBlocks[id] instanceof LiquidMetalFinite) {
                    evt.world.func_94571_i(hitX, hitY, hitZ);
                } else {
                    evt.world.func_94571_i(hitX, hitY, hitZ);
                }
                evt.setResult(Event.Result.ALLOW);
                evt.result = new ItemStack(TContent.buckets, 1, id);
            }
        }
    }

    @ForgeSubscribe
    public void playerInteract(PlayerInteractEvent event) {
        Block block;
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (block = Block.field_71973_m[event.entity.field_70170_p.func_72798_a(event.x, event.y, event.z)]) instanceof TankAirBlock) {
            event.setCanceled(true);
        }
    }
}

