/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

public class ModClassLoader
extends URLClassLoader {
    private static final List<String> STANDARD_LIBRARIES = ImmutableList.of((Object)"jinput.jar", (Object)"lwjgl.jar", (Object)"lwjgl_util.jar");
    private LaunchClassLoader mainClassLoader;

    public ModClassLoader(ClassLoader parent) {
        super(new URL[0], (ClassLoader)null);
        this.mainClassLoader = (LaunchClassLoader)parent;
    }

    public void addFile(File modFile) throws MalformedURLException {
        URL url = modFile.toURI().toURL();
        this.mainClassLoader.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.mainClassLoader.loadClass(name);
    }

    public File[] getParentSources() {
        List urls = this.mainClassLoader.getSources();
        File[] sources = new File[urls.size()];
        try {
            for (int i = 0; i < urls.size(); ++i) {
                sources[i] = new File(((URL)urls.get(i)).toURI());
            }
            return sources;
        }
        catch (URISyntaxException e) {
            FMLLog.log(Level.ERROR, e, "Unable to process our input to locate the minecraft code", new Object[0]);
            throw new LoaderException(e);
        }
    }

    public List<String> getDefaultLibraries() {
        return STANDARD_LIBRARIES;
    }

    public void clearNegativeCacheFor(Set<String> classList) {
        this.mainClassLoader.clearNegativeEntries(classList);
    }

    public ModAPITransformer addModAPITransformer(ASMDataTable dataTable) {
        this.mainClassLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.ModAPITransformer");
        List transformers = this.mainClassLoader.getTransformers();
        ModAPITransformer modAPI = (ModAPITransformer)transformers.get(transformers.size() - 1);
        modAPI.initTable(dataTable);
        return modAPI;
    }
}

