/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.simpleimpl;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.logging.log4j.Level;

public class SimpleChannelHandlerWrapper<REQ extends IMessage, REPLY extends IMessage>
extends SimpleChannelInboundHandler<REQ> {
    private IMessageHandler<REQ, REPLY> messageHandler;
    private Side side;

    public SimpleChannelHandlerWrapper(Class<? extends IMessageHandler<REQ, REPLY>> handler, Side side, Class<REQ> requestType) {
        super(requestType);
        try {
            this.messageHandler = handler.newInstance();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        this.side = side;
    }

    protected void channelRead0(ChannelHandlerContext ctx, REQ msg) throws Exception {
        es iNetHandler = (es)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        MessageContext context = new MessageContext(iNetHandler, this.side);
        REPLY result = this.messageHandler.onMessage(msg, context);
        if (result != null) {
            ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.REPLY);
            ctx.writeAndFlush(result).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "SimpleChannelHandlerWrapper exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

