/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_entityClasses", name="Dynamic Lights on specified Entities", version="1.0.0", dependencies="required-after:DynamicLights")
public class EntityClassLightSource {
    private Minecraft mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList<EntityLightAdapter> trackedItems;
    private Thread thread;
    private boolean threadRunning;
    private Configuration config;
    private HashMap<Class<? extends Entity>, Integer> lightValueMap;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.lightValueMap = new HashMap();
        this.config = new Configuration(evt.getSuggestedConfigurationFile());
        this.config.load();
        Property updateI = this.config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all Entities in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        this.config.save();
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedItems = new ArrayList();
        this.threadRunning = false;
    }

    private int getLightFromEntity(Entity e) {
        if (e != null && e.func_70089_S()) {
            if (this.lightValueMap.containsKey(e.getClass())) {
                return this.lightValueMap.get(e.getClass());
            }
            this.config.load();
            int value = this.config.get("general", e.getClass().getSimpleName(), 0).getInt();
            this.config.save();
            this.lightValueMap.put(e.getClass(), value);
            return value;
        }
        return 0;
    }

    private class EntityLightAdapter
    implements IDynamicLightSource {
        private final Entity entity;
        private final int lightLevel;

        public EntityLightAdapter(Entity e, int light) {
            this.lightLevel = light;
            this.entity = e;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Entity[] list;

        public EntityListChecker(List<Entity> input) {
            this.list = new Entity[input.size()];
            for (int i = 0; i < this.list.length; ++i) {
                this.list[i] = input.get(i);
            }
        }

        @Override
        public void run() {
            ArrayList<EntityLightAdapter> newList = new ArrayList<EntityLightAdapter>();
            for (Entity ent : this.list) {
                int light = EntityClassLightSource.this.getLightFromEntity(ent);
                if (light <= 0) continue;
                boolean found = false;
                Iterator iter = EntityClassLightSource.this.trackedItems.iterator();
                EntityLightAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityLightAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                DynamicLights.addLightSource(new EntityLightAdapter(ent, light));
            }
            EntityClassLightSource.this.trackedItems = newList;
            EntityClassLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet<TickType> ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (((EntityClassLightSource)EntityClassLightSource.this).mcinstance.field_71441_e != null && System.currentTimeMillis() > EntityClassLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                EntityClassLightSource.this.nextUpdate = System.currentTimeMillis() + EntityClassLightSource.this.updateInterval;
                if (!EntityClassLightSource.this.threadRunning) {
                    EntityClassLightSource.this.thread = new EntityListChecker(((EntityClassLightSource)EntityClassLightSource.this).mcinstance.field_71441_e.field_72996_f);
                    EntityClassLightSource.this.thread.setPriority(1);
                    EntityClassLightSource.this.thread.start();
                    EntityClassLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet<TickType> ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_entityClasses";
        }
    }
}

