/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.gui.ContainerAdvancedCraftingTable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAdvancedCraftingTable
extends GuiBuildCraft {
    public static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/assembly_advancedworkbench.png");
    TileAdvancedCraftingTable workbench;

    public GuiAdvancedCraftingTable(InventoryPlayer playerInventory, TileAdvancedCraftingTable advancedWorkbench) {
        super(new ContainerAdvancedCraftingTable(playerInventory, advancedWorkbench), advancedWorkbench, TEXTURE);
        this.workbench = advancedWorkbench;
        this.field_74194_b = 175;
        this.field_74195_c = 240;
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        super.func_74189_g(par1, par2);
        String title = StringUtils.localize("tile.assemblyWorkbenchBlock");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 97, 0x404040);
    }

    @Override
    protected void func_74185_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(TEXTURE);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.field_74194_b, this.field_74195_c);
        if (this.workbench.getStoredEnergy() > 0.0f) {
            int progress = this.workbench.getProgressScaled(24);
            this.func_73729_b(cornerX + 93, cornerY + 32, 176, 0, progress + 1, 18);
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new AssemblyWorkbenchLedger());
    }

    class AssemblyWorkbenchLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public AssemblyWorkbenchLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiAdvancedCraftingTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiAdvancedCraftingTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiAdvancedCraftingTable.this.field_73886_k.func_78276_b(String.format("%2.1f MJ", Float.valueOf(GuiAdvancedCraftingTable.this.workbench.getRequiredEnergy())), x + 22, y + 32, this.textColour);
            GuiAdvancedCraftingTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiAdvancedCraftingTable.this.field_73886_k.func_78276_b(String.format("%2.1f MJ", Float.valueOf(GuiAdvancedCraftingTable.this.workbench.getStoredEnergy())), x + 22, y + 56, this.textColour);
            GuiAdvancedCraftingTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiAdvancedCraftingTable.this.field_73886_k.func_78276_b(String.format("%3.2f MJ/t", Float.valueOf((float)GuiAdvancedCraftingTable.this.workbench.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%3.2f MJ/t", Float.valueOf((float)GuiAdvancedCraftingTable.this.workbench.getRecentEnergyAverage() / 100.0f));
        }
    }
}

