/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.utils.Localization;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportPower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SideOnly(value=Side.CLIENT)
public class PipeToolTipManager {
    private static final Map<Class<? extends Pipe>, String> toolTips = new HashMap<Class<? extends Pipe>, String>();

    public static void addToolTip(Class<? extends Pipe> pipe, String toolTip) {
        toolTips.put(pipe, toolTip);
    }

    public static List<String> getToolTip(Class<? extends Pipe> pipe) {
        String tip;
        String localized;
        ArrayList<String> tips = new ArrayList<String>();
        String tipTag = "tip." + pipe.getSimpleName();
        if (Localization.hasKey(tipTag) && (localized = Localization.get(tipTag)) != null) {
            String[] lines = localized.split("\\n");
            tips.addAll(Arrays.asList(lines));
        }
        if ((tip = toolTips.get(pipe)) != null) {
            tips.add(tip);
        }
        return tips;
    }

    static {
        for (Map.Entry<Class<? extends Pipe>, Integer> pipe : PipeTransportPower.powerCapacities.entrySet()) {
            PipeToolTipManager.addToolTip(pipe.getKey(), String.format("%d MJ/t", pipe.getValue()));
        }
    }
}

