/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.utils.EnumColor;
import buildcraft.transport.TravelingItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;

public class PacketPipeTransportContent
extends BuildCraftPacket {
    private TravelingItem item;
    private int entityId;
    private ForgeDirection input;
    private ForgeDirection output;
    private int itemId;
    private byte stackSize;
    private int itemDamage;
    private EnumColor color;
    private float itemX;
    private float itemY;
    private float itemZ;
    private float speed;
    private boolean hasNBT;
    public int posX;
    public int posY;
    public int posZ;

    public PacketPipeTransportContent() {
    }

    public PacketPipeTransportContent(TravelingItem item) {
        this.item = item;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeFloat((float)this.item.xCoord);
        data.writeFloat((float)this.item.yCoord);
        data.writeFloat((float)this.item.zCoord);
        data.writeShort(this.item.id);
        data.writeByte((byte)this.item.input.ordinal());
        data.writeByte((byte)this.item.output.ordinal());
        data.writeShort(this.item.getItemStack().field_77993_c);
        data.writeByte((byte)this.item.getItemStack().field_77994_a);
        data.writeShort(this.item.getItemStack().func_77960_j());
        data.writeByte(this.item.color != null ? this.item.color.ordinal() : -1);
        data.writeFloat(this.item.getSpeed());
        data.writeBoolean(this.item.getItemStack().func_77942_o());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.itemX = data.readFloat();
        this.itemY = data.readFloat();
        this.itemZ = data.readFloat();
        this.posX = MathHelper.func_76141_d((float)this.itemX);
        this.posY = MathHelper.func_76141_d((float)this.itemY);
        this.posZ = MathHelper.func_76141_d((float)this.itemZ);
        this.entityId = data.readShort();
        this.input = ForgeDirection.getOrientation((int)data.readByte());
        this.output = ForgeDirection.getOrientation((int)data.readByte());
        this.itemId = data.readShort();
        this.stackSize = data.readByte();
        this.itemDamage = data.readShort();
        byte c = data.readByte();
        if (c != -1) {
            this.color = EnumColor.fromId(c);
        }
        this.speed = data.readFloat();
        this.hasNBT = data.readBoolean();
    }

    public int getTravellingItemId() {
        return this.entityId;
    }

    public ForgeDirection getInputOrientation() {
        return this.input;
    }

    public ForgeDirection getOutputOrientation() {
        return this.output;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public double getItemX() {
        return this.itemX;
    }

    public double getItemY() {
        return this.itemY;
    }

    public double getItemZ() {
        return this.itemZ;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean hasNBT() {
        return this.hasNBT;
    }

    @Override
    public int getID() {
        return 2;
    }
}

