/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.biomes.TFGenTallGrass;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenDarkCanopyTree;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFDarkForestBiomeDecorator
extends TFBiomeDecorator {
    TFTreeGenerator darkCanopyTreeGen = new TFGenDarkCanopyTree();
    TFGenTallGrass worldGenDeadBush;
    WorldGenTallGrass worldGenForestGrass;
    WorldGenTallGrass worldGenMushgloom;

    public TFDarkForestBiomeDecorator(TFBiomeDarkForest tfBiomeDarkForest) {
        super(tfBiomeDarkForest);
        this.worldGenDeadBush = new TFGenTallGrass(TFBlocks.plant.field_71990_ca, 11, 8);
        this.worldGenForestGrass = new WorldGenTallGrass(TFBlocks.plant.field_71990_ca, 10);
        this.worldGenMushgloom = new WorldGenTallGrass(TFBlocks.plant.field_71990_ca, 9);
    }

    @Override
    public void func_76796_a(World world, Random rand, int mapX, int mapZ) {
        TFFeature nearFeature = TFFeature.getNearestFeature(mapX >> 4, mapZ >> 4, world);
        if (nearFeature.chunkDecorationsEnabled) {
            int ry;
            int rz;
            int rx;
            int ry2;
            int rz2;
            int rx2;
            int i;
            int nc = (int)this.canopyPerChunk + (rand.nextFloat() < this.canopyPerChunk - (float)((int)this.canopyPerChunk) ? 1 : 0);
            for (i = 0; i < nc; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = world.func_72976_f(rx2, rz2);
                this.darkCanopyTreeGen.func_76484_a(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.field_76832_z; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = this.getGroundLevel(world, rx2, rz2);
                WorldGenerator var5 = this.field_76812_e.func_76740_a(rand);
                var5.func_76487_a(1.0, 1.0, 1.0);
                var5.func_76484_a(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.field_76804_C; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = rand.nextInt(128);
                this.worldGenDeadBush.func_76484_a(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.field_76804_C; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = rand.nextInt(128);
                this.worldGenForestGrass.func_76484_a(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.field_76798_D; ++i) {
                if (rand.nextInt(8) == 0) {
                    rx2 = mapX + rand.nextInt(16) + 8;
                    rz2 = mapZ + rand.nextInt(16) + 8;
                    ry2 = this.getGroundLevel(world, rx2, rz2);
                    this.field_76828_s.func_76484_a(world, rand, rx2, ry2, rz2);
                }
                if (rand.nextInt(16) == 0) {
                    rx2 = mapX + rand.nextInt(16) + 8;
                    rz2 = mapZ + rand.nextInt(16) + 8;
                    ry2 = this.getGroundLevel(world, rx2, rz2);
                    this.field_76827_t.func_76484_a(world, rand, rx2, ry2, rz2);
                }
                if (rand.nextInt(24) != 0) continue;
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = this.getGroundLevel(world, rx2, rz2);
                this.worldGenMushgloom.func_76484_a(world, rand, rx2, ry2, rz2);
            }
            if (rand.nextInt(4) == 0) {
                rx = mapX + rand.nextInt(16) + 8;
                rz = mapZ + rand.nextInt(16) + 8;
                ry = rand.nextInt(128);
                this.field_76828_s.func_76484_a(world, rand, rx, ry, rz);
            }
            if (rand.nextInt(8) == 0) {
                rx = mapX + rand.nextInt(16) + 8;
                rz = mapZ + rand.nextInt(16) + 8;
                ry = rand.nextInt(128);
                this.field_76827_t.func_76484_a(world, rand, rx, ry, rz);
            }
            if (rand.nextInt(32) == 0) {
                rx = mapX + rand.nextInt(16) + 8;
                rz = mapZ + rand.nextInt(16) + 8;
                ry = this.getGroundLevel(world, rx, rz);
                new WorldGenPumpkin().func_76484_a(world, rand, rx, ry, rz);
            }
        }
        this.decorateUnderground(world, rand, mapX, mapZ);
        this.decorateOnlyOres(world, rand, mapX, mapZ);
    }

    public int getGroundLevel(World world, int x, int z) {
        Chunk chunk = world.func_72938_d(x, z);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.WORLDHEIGHT - 1; ++y) {
            int blockID = chunk.func_76610_a(x & 0xF, y, z & 0xF);
            if (blockID == Block.field_71980_u.field_71990_ca) {
                return y + 1;
            }
            if (blockID != Block.field_71979_v.field_71990_ca && blockID != Block.field_71981_t.field_71990_ca && blockID != Block.field_71940_F.field_71990_ca) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }
}

