/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.item.TFItems;

public class BlockTFNagastone
extends Block {
    private static Icon FACE_LEFT;
    private static Icon FACE_RIGHT;
    private static Icon CROSS_SECTION;
    private static Icon FACE_FRONT;
    private static Icon TOP_TIP;
    private static Icon TOP_LONG;
    private static Icon BOTTOM_TIP;
    private static Icon BOTTOM_LONG;
    private static Icon LEFT_DOWN;
    private static Icon RIGHT_DOWN;
    private static Icon LEFT_UP;
    private static Icon RIGHT_UP;
    private static Icon TIP_LEFT;
    private static Icon LONG_SIDE;
    private static Icon TIP_RIGHT;
    private static Icon TURN_TOP;

    public BlockTFNagastone(int par1) {
        super(par1, Material.field_76246_e);
        this.func_71848_c(1.5f);
        this.func_71894_b(10.0f);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(TFItems.creativeTab);
    }

    public int func_71857_b() {
        return TwilightForestMod.proxy.getNagastoneBlockRenderID();
    }

    public void func_71860_a(World par1World, int x, int y, int z, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int connect;
        int metadata = par1World.func_72805_g(x, y, z) & 0xC;
        int direction = 0;
        if (metadata > 0 && this.placePerfectFitBody(par1World, x, y, z)) {
            return;
        }
        if (metadata == 0 && this.placePerfectFitHead(par1World, x, y, z)) {
            return;
        }
        int pistonOrient = BlockPistonBase.func_72116_b((World)par1World, (int)x, (int)y, (int)z, (EntityLivingBase)((EntityPlayer)par5EntityLiving));
        switch (pistonOrient) {
            case 0: 
            case 1: {
                direction = 2;
                break;
            }
            case 2: 
            case 3: {
                direction = 1;
                break;
            }
            case 4: 
            case 5: {
                direction = 0;
            }
        }
        if (metadata > 0 && (direction == 0 || direction == 1) && par1World.func_72798_a(x, y - 1, z) == this.field_71990_ca) {
            metadata = 4;
        }
        if (metadata > 0 && (direction == 0 || direction == 1) && par1World.func_72798_a(x, y + 1, z) == this.field_71990_ca) {
            metadata = 8;
        }
        if (metadata == 0 || metadata == 4 || metadata == 8) {
            direction = BlockTFNagastone.determineOrientation(par1World, x, y, z, (EntityPlayer)par5EntityLiving);
        }
        if (metadata > 0 && direction == 2 && (connect = this.getOnlyNSEWConnection(par1World, x, y, z)) != -1) {
            metadata = pistonOrient == 0 ? 4 : 8;
            direction = connect;
        }
        if (metadata == 12 && (connect = this.getOnlyConnection(par1World, x, y, z)) != -1) {
            switch (connect) {
                case 0: 
                case 1: {
                    direction = 1;
                    break;
                }
                case 2: 
                case 3: {
                    direction = 0;
                    break;
                }
                case 4: 
                case 5: {
                    direction = 2;
                }
            }
        }
        par1World.func_72921_c(x, y, z, metadata | direction, 3);
    }

    public void func_71863_a(World par1World, int x, int y, int z, int neighborID) {
        int type = par1World.func_72805_g(x, y, z) & 0xC;
        if (type == 0) {
            this.placePerfectFitHead(par1World, x, y, z);
        } else {
            this.placePerfectFitBody(par1World, x, y, z);
        }
    }

    public boolean placePerfectFitBody(World world, int x, int y, int z) {
        int firstConnection = this.getPosibleConnection(world, x, y, z, -1, -1);
        int secondConnection = this.getPosibleConnection(world, x, y, z, firstConnection, -1);
        if (firstConnection == -1 || secondConnection == -1) {
            return false;
        }
        if (this.getPosibleConnection(world, x, y, z, firstConnection, secondConnection) != -1) {
            return false;
        }
        if (firstConnection == 2 && secondConnection == 3 || firstConnection == 3 && secondConnection == 2) {
            world.func_72921_c(x, y, z, 12, 3);
            return true;
        }
        if (firstConnection + secondConnection == 1) {
            world.func_72921_c(x, y, z, 13, 3);
            return true;
        }
        if (firstConnection + secondConnection == 9) {
            world.func_72921_c(x, y, z, 14, 3);
            return true;
        }
        if (firstConnection == 4) {
            world.func_72921_c(x, y, z, 4 | secondConnection, 3);
            return true;
        }
        if (firstConnection == 5) {
            world.func_72921_c(x, y, z, 8 | secondConnection, 3);
            return true;
        }
        if (secondConnection == 4) {
            world.func_72921_c(x, y, z, 4 | firstConnection, 3);
            return true;
        }
        if (secondConnection == 5) {
            world.func_72921_c(x, y, z, 8 | firstConnection, 3);
            return true;
        }
        world.func_72921_c(x, y, z, 15, 3);
        return true;
    }

    public boolean placePerfectFitHead(World world, int x, int y, int z) {
        int connect = this.getOnlyNSEWConnection(world, x, y, z);
        if (connect != -1) {
            switch (connect) {
                case 0: {
                    world.func_72832_d(x, y, z, this.field_71990_ca, 1, 3);
                    return true;
                }
                case 1: {
                    world.func_72832_d(x, y, z, this.field_71990_ca, 0, 3);
                    return true;
                }
                case 2: {
                    world.func_72832_d(x, y, z, this.field_71990_ca, 3, 3);
                    return true;
                }
                case 3: {
                    world.func_72832_d(x, y, z, this.field_71990_ca, 2, 3);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int getOnlyNSEWConnection(World world, int x, int y, int z) {
        int firstConnection = this.getPosibleConnection(world, x, y, z, -1, -1);
        int secondConnection = this.getPosibleConnection(world, x, y, z, firstConnection, -1);
        if (firstConnection > 0 && firstConnection < 4 && (secondConnection < 0 || secondConnection > 3)) {
            return firstConnection;
        }
        return -1;
    }

    public int getOnlyConnection(World world, int x, int y, int z) {
        int firstConnection = this.getPosibleConnection(world, x, y, z, -1, -1);
        int secondConnection = this.getPosibleConnection(world, x, y, z, firstConnection, -1);
        if (firstConnection > 0 && firstConnection < 6 && secondConnection == -1) {
            return firstConnection;
        }
        return -1;
    }

    public int getPosibleConnection(World world, int x, int y, int z, int exclude1, int exclude2) {
        for (int i = 0; i < 6; ++i) {
            if (i == exclude1 || i == exclude2 || !this.isNagaStoneInDirection(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public boolean isNagaStoneInDirection(World par1World, int x, int y, int z, int direction) {
        switch (direction) {
            case 0: {
                return par1World.func_72798_a(x, y, z - 1) == this.field_71990_ca;
            }
            case 1: {
                return par1World.func_72798_a(x, y, z + 1) == this.field_71990_ca;
            }
            case 2: {
                return par1World.func_72798_a(x - 1, y, z) == this.field_71990_ca;
            }
            case 3: {
                return par1World.func_72798_a(x + 1, y, z) == this.field_71990_ca;
            }
            case 4: {
                return par1World.func_72798_a(x, y - 1, z) == this.field_71990_ca;
            }
            case 5: {
                return par1World.func_72798_a(x, y + 1, z) == this.field_71990_ca;
            }
        }
        return false;
    }

    public static int determineOrientation(World par0World, int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        int rot = MathHelper.func_76128_c((double)((double)(par4EntityPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return rot == 0 ? 0 : (rot == 1 ? 3 : (rot == 2 ? 1 : (rot == 3 ? 2 : 0)));
    }

    public Icon func_71858_a(int side, int meta) {
        int type = meta & 0xC;
        int orient = meta & 3;
        if (type == 0) {
            if (orient == 0) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return FACE_FRONT;
                    }
                    case 3: {
                        return CROSS_SECTION;
                    }
                    case 4: {
                        return FACE_LEFT;
                    }
                    case 5: {
                        return FACE_RIGHT;
                    }
                }
            } else if (orient == 1) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return CROSS_SECTION;
                    }
                    case 3: {
                        return FACE_FRONT;
                    }
                    case 4: {
                        return FACE_RIGHT;
                    }
                    case 5: {
                        return FACE_LEFT;
                    }
                }
            } else if (orient == 2) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return FACE_RIGHT;
                    }
                    case 3: {
                        return FACE_LEFT;
                    }
                    case 4: {
                        return FACE_FRONT;
                    }
                    case 5: {
                        return CROSS_SECTION;
                    }
                }
            } else if (orient == 3) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return FACE_LEFT;
                    }
                    case 3: {
                        return FACE_RIGHT;
                    }
                    case 4: {
                        return CROSS_SECTION;
                    }
                    case 5: {
                        return FACE_FRONT;
                    }
                }
            }
        }
        if (type == 4) {
            if (orient == 0) {
                switch (side) {
                    case 0: {
                        return CROSS_SECTION;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return CROSS_SECTION;
                    }
                    case 3: {
                        return TIP_RIGHT;
                    }
                    case 4: {
                        return LEFT_DOWN;
                    }
                    case 5: {
                        return RIGHT_DOWN;
                    }
                }
            } else if (orient == 1) {
                switch (side) {
                    case 0: {
                        return CROSS_SECTION;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return TIP_LEFT;
                    }
                    case 3: {
                        return CROSS_SECTION;
                    }
                    case 4: {
                        return RIGHT_DOWN;
                    }
                    case 5: {
                        return LEFT_DOWN;
                    }
                }
            } else if (orient == 2) {
                switch (side) {
                    case 0: {
                        return CROSS_SECTION;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return RIGHT_DOWN;
                    }
                    case 3: {
                        return LEFT_DOWN;
                    }
                    case 4: {
                        return CROSS_SECTION;
                    }
                    case 5: {
                        return TIP_LEFT;
                    }
                }
            } else if (orient == 3) {
                switch (side) {
                    case 0: {
                        return CROSS_SECTION;
                    }
                    case 1: {
                        return TOP_TIP;
                    }
                    case 2: {
                        return LEFT_DOWN;
                    }
                    case 3: {
                        return RIGHT_DOWN;
                    }
                    case 4: {
                        return TIP_RIGHT;
                    }
                    case 5: {
                        return CROSS_SECTION;
                    }
                }
            }
        }
        if (type == 8) {
            if (orient == 0) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return CROSS_SECTION;
                    }
                    case 2: {
                        return CROSS_SECTION;
                    }
                    case 3: {
                        return TIP_LEFT;
                    }
                    case 4: {
                        return LEFT_UP;
                    }
                    case 5: {
                        return RIGHT_UP;
                    }
                }
            } else if (orient == 1) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return CROSS_SECTION;
                    }
                    case 2: {
                        return TIP_RIGHT;
                    }
                    case 3: {
                        return CROSS_SECTION;
                    }
                    case 4: {
                        return RIGHT_UP;
                    }
                    case 5: {
                        return LEFT_UP;
                    }
                }
            } else if (orient == 2) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return CROSS_SECTION;
                    }
                    case 2: {
                        return RIGHT_UP;
                    }
                    case 3: {
                        return LEFT_UP;
                    }
                    case 4: {
                        return CROSS_SECTION;
                    }
                    case 5: {
                        return TIP_LEFT;
                    }
                }
            } else if (orient == 3) {
                switch (side) {
                    case 0: {
                        return BOTTOM_TIP;
                    }
                    case 1: {
                        return CROSS_SECTION;
                    }
                    case 2: {
                        return LEFT_UP;
                    }
                    case 3: {
                        return RIGHT_UP;
                    }
                    case 4: {
                        return TIP_LEFT;
                    }
                    case 5: {
                        return CROSS_SECTION;
                    }
                }
            }
        }
        if (type == 12) {
            if (orient == 0) {
                switch (side) {
                    case 0: {
                        return BOTTOM_LONG;
                    }
                    case 1: {
                        return TOP_LONG;
                    }
                    case 2: {
                        return LONG_SIDE;
                    }
                    case 3: {
                        return LONG_SIDE;
                    }
                    case 4: {
                        return CROSS_SECTION;
                    }
                    case 5: {
                        return CROSS_SECTION;
                    }
                }
            } else if (orient == 1) {
                switch (side) {
                    case 0: {
                        return BOTTOM_LONG;
                    }
                    case 1: {
                        return TOP_LONG;
                    }
                    case 2: {
                        return CROSS_SECTION;
                    }
                    case 3: {
                        return CROSS_SECTION;
                    }
                    case 4: {
                        return LONG_SIDE;
                    }
                    case 5: {
                        return LONG_SIDE;
                    }
                }
            } else if (orient == 2) {
                switch (side) {
                    case 0: {
                        return CROSS_SECTION;
                    }
                    case 1: {
                        return CROSS_SECTION;
                    }
                    case 2: {
                        return LONG_SIDE;
                    }
                    case 3: {
                        return LONG_SIDE;
                    }
                    case 4: {
                        return LONG_SIDE;
                    }
                    case 5: {
                        return LONG_SIDE;
                    }
                }
            } else if (orient == 3) {
                switch (side) {
                    case 0: {
                        return CROSS_SECTION;
                    }
                    case 1: {
                        return TURN_TOP;
                    }
                    case 2: {
                        return LONG_SIDE;
                    }
                    case 3: {
                        return LONG_SIDE;
                    }
                    case 4: {
                        return LONG_SIDE;
                    }
                    case 5: {
                        return LONG_SIDE;
                    }
                }
            }
        }
        return null;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 13));
    }

    public int func_71899_b(int meta) {
        if (meta < 4) {
            return 1;
        }
        return 13;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        FACE_LEFT = par1IconRegister.func_94245_a("TwilightForest:nagastone_face_left");
        FACE_RIGHT = par1IconRegister.func_94245_a("TwilightForest:nagastone_face_right");
        CROSS_SECTION = par1IconRegister.func_94245_a("TwilightForest:nagastone_cross_section");
        FACE_FRONT = par1IconRegister.func_94245_a("TwilightForest:nagastone_face_front");
        TOP_TIP = par1IconRegister.func_94245_a("TwilightForest:nagastone_top_tip");
        TOP_LONG = par1IconRegister.func_94245_a("TwilightForest:nagastone_tip_long");
        BOTTOM_TIP = par1IconRegister.func_94245_a("TwilightForest:nagastone_bottom_tip");
        BOTTOM_LONG = par1IconRegister.func_94245_a("TwilightForest:nagastone_bottom_long");
        LEFT_DOWN = par1IconRegister.func_94245_a("TwilightForest:nagastone_left_down");
        RIGHT_DOWN = par1IconRegister.func_94245_a("TwilightForest:nagastone_right_down");
        LEFT_UP = par1IconRegister.func_94245_a("TwilightForest:nagastone_left_up");
        RIGHT_UP = par1IconRegister.func_94245_a("TwilightForest:nagastone_right_up");
        TIP_LEFT = par1IconRegister.func_94245_a("TwilightForest:nagastone_tip_left");
        LONG_SIDE = par1IconRegister.func_94245_a("TwilightForest:nagastone_long_side");
        TIP_RIGHT = par1IconRegister.func_94245_a("TwilightForest:nagastone_tip_right");
        TURN_TOP = par1IconRegister.func_94245_a("TwilightForest:nagastone_turn_top");
    }
}

