/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapInfo;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.TFPacketHandler;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.item.TFItems;
import twilightforest.world.TFWorldChunkManager;

public class ItemTFMagicMap
extends ItemMap {
    protected static final String STR_ID = "magicmap";

    protected ItemTFMagicMap(int par1) {
        super(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMagicMapData getMPMapData(short par0, World par1World) {
        String mapName = "magicmap_" + par0;
        TFMagicMapData mapData = (TFMagicMapData)par1World.func_72943_a(TFMagicMapData.class, mapName);
        if (mapData == null) {
            mapData = new TFMagicMapData(mapName);
            par1World.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public TFMagicMapData getMapData(ItemStack par1ItemStack, World par2World) {
        String mapName = "magicmap_" + par1ItemStack.func_77960_j();
        TFMagicMapData mapData = (TFMagicMapData)par2World.func_72943_a(TFMagicMapData.class, mapName);
        if (mapData == null && !par2World.field_72995_K) {
            par1ItemStack.func_77964_b(par2World.func_72841_b(STR_ID));
            mapName = "magicmap_" + par1ItemStack.func_77960_j();
            mapData = new TFMagicMapData(mapName);
            mapData.field_76201_a = par2World.func_72912_H().func_76079_c();
            mapData.field_76199_b = par2World.func_72912_H().func_76074_e();
            mapData.field_76197_d = (byte)4;
            mapData.field_76200_c = par2World.field_73011_w.field_76574_g;
            mapData.func_76185_a();
            par2World.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public void updateMapData(World par1World, Entity par2Entity, TFMagicMapData par3MapData) {
        if (par1World.field_73011_w.field_76574_g == par3MapData.field_76200_c && par2Entity instanceof EntityPlayer) {
            int xSize = 128;
            int zSize = 128;
            int scaleFactor = 1 << par3MapData.field_76197_d;
            int xCenter = par3MapData.field_76201_a;
            int zCenter = par3MapData.field_76199_b;
            int xDraw = MathHelper.func_76128_c((double)(par2Entity.field_70165_t - (double)xCenter)) / scaleFactor + xSize / 2;
            int zDraw = MathHelper.func_76128_c((double)(par2Entity.field_70161_v - (double)zCenter)) / scaleFactor + zSize / 2;
            int drawSize = 512 / scaleFactor;
            MapInfo mapInfo = par3MapData.func_82568_a((EntityPlayer)par2Entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                double lastElevation = 0.0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte existingColor;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = (xCenter / scaleFactor + xStep - xSize / 2) * scaleFactor;
                    int zDraw2 = (zCenter / scaleFactor + zStep - zSize / 2) * scaleFactor;
                    int[] biomeFrequencies = new int[256];
                    for (int xStep2 = 0; xStep2 < scaleFactor; ++xStep2) {
                        for (int zStep2 = 0; zStep2 < scaleFactor; ++zStep2) {
                            TFWorldChunkManager tfManager;
                            int biomeID;
                            int n = biomeID = par1World.func_72807_a((int)(xDraw2 + xStep2), (int)(zDraw2 + zStep2)).field_76756_M;
                            biomeFrequencies[n] = biomeFrequencies[n] + 1;
                            if (biomeID == BiomeGenBase.field_76781_i.field_76756_M || biomeID == TFBiomeBase.stream.field_76756_M) {
                                int n2 = biomeID;
                                biomeFrequencies[n2] = biomeFrequencies[n2] + 2;
                            }
                            if (!(par1World.func_72959_q() instanceof TFWorldChunkManager) || !(tfManager = (TFWorldChunkManager)par1World.func_72959_q()).isInFeatureChunk(xDraw2 + xStep2, zDraw2 + zStep2) || zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize) continue;
                            par3MapData.addFeatureToMap(TFFeature.getNearestFeature(xDraw2 + xStep2 >> 4, zDraw2 + zStep2 >> 4, par1World), xDraw2, zDraw2);
                        }
                    }
                    byte biomeIDToShow = 0;
                    int highestFrequency = 0;
                    for (int i = 0; i < 256; ++i) {
                        if (biomeFrequencies[i] <= highestFrequency) continue;
                        biomeIDToShow = (byte)i;
                        highestFrequency = biomeFrequencies[i];
                    }
                    biomeIDToShow = (byte)(biomeIDToShow + 1);
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = par3MapData.field_76198_e[xStep + zStep * xSize]) == biomeIDToShow) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    par3MapData.field_76198_e[xStep + zStep * xSize] = biomeIDToShow;
                }
                if (highNumber > lowNumber) continue;
                par3MapData.func_76194_a(xStep, highNumber, lowNumber);
            }
        }
    }

    public void updateMapDataOld(World par1World, Entity par2Entity, MapData par3MapData) {
        if (par1World.field_73011_w.field_76574_g == par3MapData.field_76200_c) {
            int xSize = 128;
            int zSize = 128;
            int scaleFactor = 1 << par3MapData.field_76197_d;
            int xCenter = par3MapData.field_76201_a;
            int zCenter = par3MapData.field_76199_b;
            int xDraw = MathHelper.func_76128_c((double)(par2Entity.field_70165_t - (double)xCenter)) / scaleFactor + xSize / 2;
            int zDraw = MathHelper.func_76128_c((double)(par2Entity.field_70161_v - (double)zCenter)) / scaleFactor + zSize / 2;
            int drawSize = 512 / scaleFactor;
            MapInfo mapInfo = par3MapData.func_82568_a((EntityPlayer)par2Entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                double lastElevation = 0.0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte tintedColor;
                    byte existingColor;
                    int belowValue;
                    int heightValue;
                    int zStep2;
                    int xStep2;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = (xCenter / scaleFactor + xStep - xSize / 2) * scaleFactor;
                    int zDraw2 = (zCenter / scaleFactor + zStep - zSize / 2) * scaleFactor;
                    int var23 = 0;
                    int var24 = 0;
                    int var25 = 0;
                    int[] intarray = new int[256];
                    Chunk chunk = par1World.func_72938_d(xDraw2, zDraw2);
                    int x15 = xDraw2 & 0xF;
                    int z15 = zDraw2 & 0xF;
                    int var30 = 0;
                    double currentElevation = 0.0;
                    for (xStep2 = 0; xStep2 < scaleFactor; ++xStep2) {
                        for (zStep2 = 0; zStep2 < scaleFactor; ++zStep2) {
                            heightValue = chunk.func_76611_b(xStep2 + x15, zStep2 + z15) + 1;
                            int blockID = 0;
                            if (heightValue > 1) {
                                boolean foundSolidBlock = false;
                                do {
                                    foundSolidBlock = true;
                                    blockID = chunk.func_76610_a(xStep2 + x15, heightValue - 1, zStep2 + z15);
                                    if (blockID == 0) {
                                        foundSolidBlock = false;
                                    } else if (heightValue > 0 && blockID > 0 && Block.field_71973_m[blockID].field_72018_cp.field_76234_F == MapColor.field_76279_b) {
                                        foundSolidBlock = false;
                                    }
                                    if (foundSolidBlock) continue;
                                    blockID = chunk.func_76610_a(xStep2 + x15, --heightValue - 1, zStep2 + z15);
                                } while (heightValue > 0 && !foundSolidBlock);
                                if (heightValue > 0 && blockID != 0 && Block.field_71973_m[blockID].field_72018_cp.func_76224_d()) {
                                    int belowBlockID;
                                    belowValue = heightValue - 1;
                                    boolean foundBottom = false;
                                    do {
                                        belowBlockID = chunk.func_76610_a(xStep2 + x15, belowValue--, zStep2 + z15);
                                        ++var30;
                                    } while (belowValue > 0 && belowBlockID != 0 && Block.field_71973_m[belowBlockID].field_72018_cp.func_76224_d());
                                }
                            }
                            currentElevation += (double)heightValue / (double)(scaleFactor * scaleFactor);
                            int n = blockID;
                            intarray[n] = intarray[n] + 1;
                        }
                    }
                    var30 /= scaleFactor * scaleFactor;
                    int var10000 = var23 / (scaleFactor * scaleFactor);
                    var10000 = var24 / (scaleFactor * scaleFactor);
                    var10000 = var25 / (scaleFactor * scaleFactor);
                    xStep2 = 0;
                    zStep2 = 0;
                    for (heightValue = 0; heightValue < 256; ++heightValue) {
                        if (intarray[heightValue] <= xStep2) continue;
                        zStep2 = heightValue;
                        xStep2 = intarray[heightValue];
                    }
                    double elevationChange = (currentElevation - lastElevation) * 4.0 / (double)(scaleFactor + 4) + ((double)(xStep + zStep & 1) - 0.5) * 0.4;
                    int tint = 1;
                    if (elevationChange > 0.6) {
                        tint = 2;
                    }
                    if (elevationChange < -0.6) {
                        tint = 0;
                    }
                    belowValue = 0;
                    if (zStep2 > 0) {
                        MapColor mapColor = Block.field_71973_m[zStep2].field_72018_cp.field_76234_F;
                        if (mapColor == MapColor.field_76282_n) {
                            elevationChange = (double)var30 * 0.1 + (double)(xStep + zStep & 1) * 0.2;
                            tint = 1;
                            if (elevationChange < 0.5) {
                                tint = 2;
                            }
                            if (elevationChange > 0.9) {
                                tint = 0;
                            }
                        }
                        belowValue = mapColor.field_76290_q;
                    }
                    lastElevation = currentElevation;
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = par3MapData.field_76198_e[xStep + zStep * xSize]) == (tintedColor = (byte)(belowValue * 4 + tint))) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    par3MapData.field_76198_e[xStep + zStep * xSize] = tintedColor;
                }
                if (highNumber > lowNumber) continue;
                par3MapData.func_76194_a(xStep, highNumber, lowNumber);
            }
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!par2World.field_72995_K) {
            TFMagicMapData mapData = this.getMapData(par1ItemStack, par2World);
            if (par3Entity instanceof EntityPlayer) {
                EntityPlayer var7 = (EntityPlayer)par3Entity;
                mapData.func_76191_a(var7, par1ItemStack);
            }
            if (par5) {
                this.updateMapData(par2World, par3Entity, mapData);
            }
        }
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public Packet func_77871_c(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        byte[] mapBytes = this.getMapData(par1ItemStack, par2World).func_76193_a(par1ItemStack, par2World, par3EntityPlayer);
        if (mapBytes == null) {
            return null;
        }
        if (mapBytes[0] == 1 && par2World.field_73012_v.nextInt(4) == 0) {
            this.getMapData(par1ItemStack, par2World).checkExistingFeatures(par2World);
            mapBytes = this.getMapData(par1ItemStack, par2World).makeFeatureStorageArray();
        }
        short mapItemID = (short)TFItems.magicMap.field_77779_bT;
        short uniqueID = (short)par1ItemStack.func_77960_j();
        return TFPacketHandler.makeMagicMapPacket("tfmagicmap", mapItemID, uniqueID, mapBytes);
    }

    public String func_77628_j(ItemStack par1ItemStack) {
        return ("" + StatCollector.func_74838_a((String)(this.func_77657_g(par1ItemStack) + ".name")) + " #" + par1ItemStack.func_77960_j()).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("TwilightForest:" + this.func_77658_a().substring(5));
    }
}

