/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public abstract class TFTreeGenerator
extends TFGenerator {
    protected int treeBlock;
    protected int treeMeta;
    protected int branchMeta;
    protected int leafBlock;
    protected int leafMeta;
    protected int rootBlock;
    protected int rootMeta;

    public TFTreeGenerator() {
        this(false);
    }

    public TFTreeGenerator(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log.field_71990_ca;
        this.treeMeta = 3;
        this.branchMeta = 15;
        this.leafBlock = TFBlocks.hedge.field_71990_ca;
        this.leafMeta = 1;
        this.rootBlock = TFBlocks.root.field_71990_ca;
        this.rootMeta = 0;
    }

    protected void buildRoot(World world, int x, int y, int z, double offset, int b) {
        ChunkCoordinates[] lineArray;
        ChunkCoordinates dest = TFTreeGenerator.translateCoords(x, y - b - 2, z, 5.0, 0.3 * (double)b + offset, 0.8);
        for (ChunkCoordinates coord : lineArray = TFTreeGenerator.getBresehnamArrayCoords(x, y - b - 2, z, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c)) {
            this.placeRootBlock(world, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, this.rootBlock, this.rootMeta);
        }
    }

    protected void placeRootBlock(World world, int x, int y, int z, int block, int meta) {
        if (TFTreeGenerator.canRootGrowIn(world, x, y, z)) {
            this.func_76485_a(world, x, y, z, block, meta);
        }
    }

    public static boolean canRootGrowIn(World world, int x, int y, int z) {
        int blockID = world.func_72798_a(x, y, z);
        if (blockID == 0) {
            return TFTreeGenerator.isNearSolid((IBlockAccess)world, x, y, z);
        }
        return blockID != Block.field_71986_z.field_71990_ca && blockID != Block.field_72089_ap.field_71990_ca && blockID != TFBlocks.shield.field_71990_ca;
    }
}

