/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.enchantview;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import thebombzen.mods.enchantview.CommandEnchantViewExists;
import thebombzen.mods.enchantview.CommonProxy;
import thebombzen.mods.enchantview.ConfigScreen;
import thebombzen.mods.enchantview.Configuration;
import thebombzen.mods.enchantview.EVGuiEnchantment;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfiguration;
import thebombzen.mods.thebombzenapi.client.ThebombzenAPIConfigScreen;

@Mod(modid="EnchantView", name="EnchantView", version="3.12.0", dependencies="required-after:ThebombzenAPI")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class EnchantView
extends ThebombzenAPIBaseMod
implements IPacketHandler {
    public static final int STAGE_REQUEST = 0;
    public static final int STAGE_SEND = 1;
    public static final int STAGE_ACCEPT = 2;
    public static final Random random = new Random();
    @Mod.Instance(value="EnchantView")
    public static EnchantView instance;
    @SidedProxy(clientSide="thebombzen.mods.enchantview.ClientProxy", serverSide="thebombzen.mods.enchantview.CommonProxy")
    public static CommonProxy proxy;
    private Configuration configuration;
    @SideOnly(value=Side.CLIENT)
    public ye[] newItemStacks;
    @SideOnly(value=Side.CLIENT)
    public volatile boolean enchantViewExists;
    @SideOnly(value=Side.CLIENT)
    public volatile boolean askingIfEnchantViewExists;
    @SideOnly(value=Side.CLIENT)
    public volatile boolean askingForEnchantments;
    @SideOnly(value=Side.CLIENT)
    public volatile int currentWorldHashCode;
    public Map<UUID, ye[]> newItemStacksMap = new HashMap<UUID, ye[]>();

    public boolean canPlayerUseCommand(jv player) {
        return proxy.canPlayerUseCommand(player);
    }

    public void enchantItem(vm container, jv player, int slot) {
        ye stack = this.newItemStacksMap.get(player.aw())[slot];
        player.a(-container.g[slot]);
        container.a.a(0, stack);
        container.a(container.a);
    }

    public ye generateEnchantedItemStack(vm container, jv player, int slot) {
        ye newItemStack = ye.b((ye)container.a.a(0));
        if (container.g[slot] > 0 && newItemStack != null && (player.bH >= container.g[slot] || player.bG.d)) {
            boolean isBook;
            List enchList = aaw.b((Random)random, (ye)newItemStack, (int)container.g[slot]);
            boolean bl = isBook = newItemStack.d == yc.aN.cv;
            if (enchList != null) {
                if (isBook) {
                    newItemStack.d = yc.bY.cv;
                }
                int enchToPick = random.nextInt(enchList.size());
                for (int i = 0; i < enchList.size(); ++i) {
                    abb enchData = (abb)enchList.get(i);
                    if (isBook && i != enchToPick) continue;
                    if (isBook) {
                        yc.bY.a(newItemStack, enchData);
                        continue;
                    }
                    newItemStack.a(enchData.b, enchData.c);
                }
            }
        }
        return newItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveEnchantmentListFromServer(ea payload) {
        this.askingForEnchantments = false;
        by compound = null;
        try {
            compound = ci.a((InputStream)new ByteArrayInputStream(payload.c, 0, payload.b));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error receiving enchanments list from server.");
        }
        if (compound.e("stage") != 1) {
            throw new RuntimeException("Error receiving enchanments list from server.");
        }
        for (int i = 0; i < 3; ++i) {
            by stackTag = compound.l("stack" + i);
            this.newItemStacks[i] = ye.a((by)stackTag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void requestEnchantmentListFromServer(int windowId) {
        this.askingForEnchantments = true;
        ea payload = new ea();
        payload.a = "EnchantView";
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        by compound = new by();
        compound.a("stage", 0);
        compound.a("windowId", windowId);
        try {
            ci.a((by)compound, (OutputStream)dataOut);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error receiving enchanments list from server.");
        }
        payload.c = dataOut.toByteArray();
        payload.b = payload.c.length;
        atv.w().q().c((ey)payload);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendAcceptEnchantment(int windowId, int slot) {
        ea payload = new ea();
        payload.a = "EnchantView";
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        by compound = new by();
        compound.a("stage", 2);
        compound.a("windowId", windowId);
        compound.a("slot", slot);
        try {
            ci.a((by)compound, (OutputStream)dataOut);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error receiving enchanments list from server.");
        }
        payload.c = dataOut.toByteArray();
        payload.b = payload.c.length;
        atv.w().q().c((ey)payload);
    }

    @SideOnly(value=Side.CLIENT)
    public ThebombzenAPIConfigScreen createConfigScreen(awe base) {
        return new ConfigScreen(this, base, this.configuration);
    }

    public ThebombzenAPIConfiguration<?> getConfiguration() {
        return this.configuration;
    }

    public String getLongName() {
        return "EnchantView";
    }

    @SideOnly(value=Side.CLIENT)
    public int getNumActiveKeys() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getNumToggleKeys() {
        return 0;
    }

    public String getShortName() {
        return "EV";
    }

    public String getLongVersionString() {
        return "EnchantView v3.12.0 for Minecraft 1.6.4";
    }

    public String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/EnchantView/EVVersion.txt";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasConfigScreen() {
        return true;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent fmlie) {
        NetworkRegistry.instance().registerChannel((IPacketHandler)this, "EnchantView");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (this.askingIfEnchantViewExists) {
            this.enchantViewExists = event.message.equals("{\"text\":\"Yes, EnchantView exists.\"}");
            this.askingIfEnchantViewExists = false;
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(ea payload) {
        this.receiveEnchantmentListFromServer(payload);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onOpenGui(GuiOpenEvent event) {
        if (event.gui instanceof axr && !(event.gui instanceof EVGuiEnchantment)) {
            event.gui = new EVGuiEnchantment((axr)event.gui);
        }
    }

    public void onPacketData(cm manager, ea payload, Player player) {
        if (player instanceof jv) {
            this.onServerPacket(manager, payload, (jv)player);
        } else {
            this.onClientPacket(payload);
        }
    }

    public void onServerPacket(cm manager, ea payload, jv player) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(payload.c, 0, payload.b);
            by compoundIn = ci.a((InputStream)byteIn);
            int stage = compoundIn.e("stage");
            int windowId = compoundIn.e("windowId");
            if (player.bp.d != windowId) {
                return;
            }
            if (!(player.bp instanceof vm)) {
                return;
            }
            vm container = (vm)player.bp;
            if (stage == 0) {
                ye[] newItemStacks = new ye[3];
                ye stack = (ye)container.a().get(0);
                for (int i = 0; i < 3; ++i) {
                    int level = container.g[i];
                    newItemStacks[i] = this.generateEnchantedItemStack(container, player, i);
                }
                this.newItemStacksMap.put(player.aw(), newItemStacks);
                ea payloadSend = new ea();
                payloadSend.a = "EnchantView";
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                by compoundOut = new by();
                compoundOut.a("stage", 1);
                for (int i = 0; i < 3; ++i) {
                    by stackTag = new by();
                    newItemStacks[i].b(stackTag);
                    compoundOut.a("stack" + i, stackTag);
                }
                ci.a((by)compoundOut, (OutputStream)byteOut);
                payloadSend.c = byteOut.toByteArray();
                payloadSend.b = payloadSend.c.length;
                manager.a((ey)payloadSend);
            } else if (stage == 2) {
                int slot = compoundIn.e("slot");
                this.enchantItem((vm)player.bp, player, slot);
                this.newItemStacksMap.put(player.aw(), new ye[3]);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configuration = new Configuration(this);
        if (event.getSide().equals((Object)Side.CLIENT)) {
            this.newItemStacks = new ye[3];
        }
        super.preInit(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ab)new CommandEnchantViewExists());
    }

    @SideOnly(value=Side.CLIENT)
    public void activeKeyPressed(int keyCode) {
    }

    @SideOnly(value=Side.CLIENT)
    protected String getToggleMessageString(int index, boolean enabled) {
        return "";
    }
}

