/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.crossbowmod;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.crossbowmod.CrossbowModCore;
import micdoodle8.mods.crossbowmod.NEICrossbowModConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CrossbowModRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation circuitFabricatorTexture = new ResourceLocation(CrossbowModCore.TEXTURE_DOMAIN, "textures/gui/crossbowTable.png");

    public String getRecipeId() {
        return "galacticraft.circuits";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEICrossbowModConfig.getCrossbowModRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)circuitFabricatorTexture);
        GuiDraw.drawTexturedModalRect((int)-2, (int)9, (int)3, (int)4, (int)168, (int)110);
    }

    public void onUpdate() {
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedCircuitRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result) || irecipe.getValue().item.func_77978_p() == null || result.func_77978_p() == null) continue;
            NBTTagCompound nbt1 = irecipe.getValue().item.func_77978_p();
            NBTTagCompound nbt2 = result.func_77978_p();
            if (nbt1.func_74762_e("attachment") != nbt2.func_74762_e("attachment") || nbt1.func_74762_e("material") != nbt2.func_74762_e("material") || nbt1.func_74762_e("firerate") != nbt2.func_74762_e("firerate")) continue;
            this.arecipes.add(new CachedCircuitRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)pstack.item) || irecipe.getValue().item.func_77978_p() == null || pstack.item.func_77978_p() == null) continue;
                NBTTagCompound nbt1 = irecipe.getValue().item.func_77978_p();
                NBTTagCompound nbt2 = pstack.item.func_77978_p();
                if (nbt1.func_74762_e("attachment") != nbt2.func_74762_e("attachment") || nbt1.func_74762_e("material") != nbt2.func_74762_e("material") || nbt1.func_74762_e("firerate") != nbt2.func_74762_e("firerate")) continue;
                this.arecipes.add(new CachedCircuitRecipe(irecipe));
                continue block0;
            }
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    public String getRecipeName() {
        return "Circuit Fabricator";
    }

    public String getGuiTexture() {
        return "/mods/galacticraftcore/textures/gui/circuitFabricator.png";
    }

    public class CachedCircuitRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedCircuitRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)CrossbowModRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CachedCircuitRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

