/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.crossbowmod.asm;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.crossbowmod.asm"})
public class CrossbowModPlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static String transformerDir = "micdoodle8.mods.crossbowmod.asm.";
    private static String transformerMain = transformerDir + "CrossbowModTransformer";
    public static boolean hasRegistered = false;
    public static final String mcVersion = "[1.6.4]";
    public static File mcDir;

    public String[] getLibraryRequestClass() {
        return null;
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your mods folder and check <a href=\"http://micdoodle8.com\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        CrossbowModPlugin.versionCheck(mcVersion, "Crossbow Mod 2");
        String[] asmStrings = new String[]{transformerMain};
        if (!hasRegistered) {
            List<String> asm = Arrays.asList(asmStrings);
            for (String s : asm) {
                try {
                    Class<?> c = Class.forName(s);
                    if (c == null) continue;
                    System.out.println("Successfully Registered Transformer");
                }
                catch (Exception ex) {
                    System.out.println("Error while running transformer " + s);
                    return null;
                }
            }
            hasRegistered = true;
        }
        return asmStrings;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return "micdoodle8.mods.crossbowmod.asm.CrossbowModPlugin";
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("mcLocation")) {
            mcDir = (File)data.get("mcLocation");
        }
        System.out.println("[CrossbowModPlugin]: Patching game...");
    }

    public Void call() throws Exception {
        return null;
    }
}

