/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.crossbowmod.util;

import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.crossbowmod.item.CrossbowInfo;
import micdoodle8.mods.crossbowmod.item.EnumAttachmentType;
import micdoodle8.mods.crossbowmod.item.EnumCrossbowFireRate;
import micdoodle8.mods.crossbowmod.item.EnumCrossbowMaterial;
import micdoodle8.mods.crossbowmod.item.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CrossbowRecipes {
    private static HashMap<CrossbowInfo, ItemStack> recipeMap = new HashMap();

    public static void addCrossbowRecipe(CrossbowInfo input, ItemStack result) {
        recipeMap.put(input, result);
    }

    public static ItemStack findMatchingRecipe(ItemStack[] sticks, ItemStack[] limbs, ItemStack mechanism, ItemStack attachment) {
        if (sticks.length != 3 || limbs.length != 5) {
            return null;
        }
        CrossbowInfo info = new CrossbowInfo(null, null, null);
        for (ItemStack stick : sticks) {
            if (stick != null && stick.func_77973_b().field_77779_bT == Item.field_77669_D.field_77779_bT) continue;
            return null;
        }
        int limbDamage = 0;
        for (ItemStack limb : limbs) {
            if (limb == null || limb.func_77973_b().field_77779_bT != Items.attachmentLimbBolt.field_77779_bT) {
                return null;
            }
            if (limbDamage != 0 && limb.func_77960_j() != limbDamage) {
                return null;
            }
            limbDamage = limb.func_77960_j();
        }
        switch (limbDamage) {
            case 5: {
                info.setMaterial(EnumCrossbowMaterial.wooden);
                break;
            }
            case 6: {
                info.setMaterial(EnumCrossbowMaterial.stone);
                break;
            }
            case 7: {
                info.setMaterial(EnumCrossbowMaterial.iron);
                break;
            }
            case 8: {
                info.setMaterial(EnumCrossbowMaterial.gold);
                break;
            }
            case 9: {
                info.setMaterial(EnumCrossbowMaterial.diamond);
                break;
            }
        }
        if (mechanism == null || mechanism.func_77973_b().field_77779_bT != Items.attachmentLimbBolt.field_77779_bT) {
            return null;
        }
        switch (mechanism.func_77960_j()) {
            case 10: {
                info.setFireRate(EnumCrossbowFireRate.none);
                break;
            }
            case 11: {
                info.setFireRate(EnumCrossbowFireRate.light);
                break;
            }
            case 12: {
                info.setFireRate(EnumCrossbowFireRate.medium);
                break;
            }
            case 13: {
                info.setFireRate(EnumCrossbowFireRate.heavy);
                break;
            }
            case 23: {
                info.setFireRate(EnumCrossbowFireRate.tri);
                break;
            }
            default: {
                info.setFireRate(EnumCrossbowFireRate.none);
            }
        }
        if (attachment == null || attachment.func_77973_b().field_77779_bT != Items.attachmentLimbBolt.field_77779_bT) {
            info.setAttachment(EnumAttachmentType.none);
        } else {
            switch (attachment.func_77960_j()) {
                case 14: {
                    info.setAttachment(EnumAttachmentType.shortscope);
                    break;
                }
                case 15: {
                    info.setAttachment(EnumAttachmentType.longscope);
                    break;
                }
                case 16: {
                    info.setAttachment(EnumAttachmentType.flame);
                    break;
                }
                case 17: {
                    info.setAttachment(EnumAttachmentType.explosive);
                    break;
                }
                case 18: {
                    info.setAttachment(EnumAttachmentType.lava);
                    break;
                }
                case 19: {
                    info.setAttachment(EnumAttachmentType.ice);
                    break;
                }
                case 20: {
                    info.setAttachment(EnumAttachmentType.lightning);
                    break;
                }
                case 21: {
                    info.setAttachment(EnumAttachmentType.torch);
                    break;
                }
                case 22: {
                    info.setAttachment(EnumAttachmentType.poison);
                    break;
                }
                default: {
                    info.setAttachment(EnumAttachmentType.none);
                }
            }
        }
        for (Map.Entry<CrossbowInfo, ItemStack> entry : recipeMap.entrySet()) {
            if (!info.getAttachment().equals((Object)entry.getKey().getAttachment()) || !info.getMaterial().equals((Object)entry.getKey().getMaterial()) || !info.getFireRate().equals((Object)entry.getKey().getFireRate())) continue;
            ItemStack crossbow = new ItemStack(entry.getValue().func_77973_b(), 1, entry.getValue().func_77960_j());
            if (crossbow.field_77990_d == null) {
                crossbow.func_77982_d(new NBTTagCompound());
            }
            if (info.getAttachment() != null && info.getMaterial() != null && info.getFireRate() != null) {
                crossbow.func_77978_p().func_74768_a("attachment", info.getAttachment().getIndex());
                crossbow.func_77978_p().func_74768_a("material", info.getMaterial().getIndex());
                crossbow.func_77978_p().func_74768_a("firerate", info.getFireRate().getIndex());
            }
            return crossbow;
        }
        return null;
    }

    public static HashMap<CrossbowInfo, ItemStack> getRecipeMap() {
        return recipeMap;
    }

    public static void setRecipeMap(HashMap<CrossbowInfo, ItemStack> recipeMap) {
        CrossbowRecipes.recipeMap = recipeMap;
    }
}

