/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.crossbowmod.util;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import micdoodle8.mods.crossbowmod.block.Blocks;
import micdoodle8.mods.crossbowmod.inventory.InventoryCrossbowBench;
import micdoodle8.mods.crossbowmod.item.CrossbowInfo;
import micdoodle8.mods.crossbowmod.item.EnumAttachmentType;
import micdoodle8.mods.crossbowmod.item.EnumCrossbowFireRate;
import micdoodle8.mods.crossbowmod.item.EnumCrossbowMaterial;
import micdoodle8.mods.crossbowmod.item.ItemCrossbow;
import micdoodle8.mods.crossbowmod.item.Items;
import micdoodle8.mods.crossbowmod.util.CrossbowRecipes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet250CustomPayload;

public class Util {
    public static Packet250CustomPayload createPacket(String channel, int packetID, Object[] input) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(packetID);
            if (input != null) {
                for (Object obj : input) {
                    Util.writeObjectToStream(obj, data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channel;
        packet.field_73629_c = bytes.toByteArray();
        packet.field_73628_b = packet.field_73629_c.length;
        return packet;
    }

    public static Object[] readPacketData(DataInputStream data, Class<?>[] packetDataTypes) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            for (Class<?> curClass : packetDataTypes) {
                result.add(Util.readObjectFromStream(data, curClass));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toArray();
    }

    private static void writeObjectToStream(Object obj, DataOutputStream data) throws IOException {
        Class<?> objClass = obj.getClass();
        if (objClass.equals(Boolean.class)) {
            data.writeBoolean((Boolean)obj);
        } else if (objClass.equals(Byte.class)) {
            data.writeByte(((Byte)obj).byteValue());
        } else if (objClass.equals(Integer.class)) {
            data.writeInt((Integer)obj);
        } else if (objClass.equals(String.class)) {
            data.writeUTF((String)obj);
        } else if (objClass.equals(Double.class)) {
            data.writeDouble((Double)obj);
        } else if (objClass.equals(Float.class)) {
            data.writeFloat(((Float)obj).floatValue());
        } else if (objClass.equals(Long.class)) {
            data.writeLong((Long)obj);
        } else if (objClass.equals(Short.class)) {
            data.writeShort(((Short)obj).shortValue());
        }
    }

    private static Object readObjectFromStream(DataInputStream data, Class<?> curClass) throws IOException {
        if (curClass.equals(Boolean.class)) {
            return data.readBoolean();
        }
        if (curClass.equals(Byte.class)) {
            return data.readByte();
        }
        if (curClass.equals(Integer.class)) {
            return data.readInt();
        }
        if (curClass.equals(String.class)) {
            return data.readUTF();
        }
        if (curClass.equals(Double.class)) {
            return data.readDouble();
        }
        if (curClass.equals(Float.class)) {
            return Float.valueOf(data.readFloat());
        }
        if (curClass.equals(Long.class)) {
            return data.readLong();
        }
        if (curClass.equals(Short.class)) {
            return data.readShort();
        }
        return null;
    }

    public static int readPacketID(DataInputStream data) {
        int result = -1;
        try {
            result = data.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void addRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 3, 5), (Object[])new Object[]{"XY", "XY", "XY", Character.valueOf('X'), Item.field_77669_D, Character.valueOf('Y'), Block.field_71988_x});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 3, 6), (Object[])new Object[]{"XY", "XY", "XY", Character.valueOf('X'), Item.field_77669_D, Character.valueOf('Y'), Block.field_71978_w});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 3, 6), (Object[])new Object[]{"XY", "XY", "XY", Character.valueOf('X'), Item.field_77669_D, Character.valueOf('Y'), Block.field_71981_t});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 3, 7), (Object[])new Object[]{"XY", "XY", "XY", Character.valueOf('X'), Item.field_77669_D, Character.valueOf('Y'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 3, 8), (Object[])new Object[]{"XY", "XY", "XY", Character.valueOf('X'), Item.field_77669_D, Character.valueOf('Y'), Item.field_77717_p});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 3, 9), (Object[])new Object[]{"XY", "XY", "XY", Character.valueOf('X'), Item.field_77669_D, Character.valueOf('Y'), Item.field_77702_n});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 10), (Object[])new Object[]{"XXX", "XYZ", "XZY", Character.valueOf('X'), Block.field_71978_w, Character.valueOf('Y'), Item.field_77669_D, Character.valueOf('Z'), Item.field_77683_K});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 11), (Object[])new Object[]{"AXX", "XBZ", "XZY", Character.valueOf('X'), Block.field_71978_w, Character.valueOf('Y'), Item.field_77669_D, Character.valueOf('Z'), Item.field_77683_K, Character.valueOf('A'), Item.field_77703_o, Character.valueOf('B'), new ItemStack(Items.attachmentLimbBolt, 1, 10)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 12), (Object[])new Object[]{"XXX", "XBZ", "XZY", Character.valueOf('X'), Item.field_77703_o, Character.valueOf('Y'), Item.field_77669_D, Character.valueOf('Z'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack(Items.attachmentLimbBolt, 1, 11)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 13), (Object[])new Object[]{"XAA", "ABZ", "AZY", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('A'), Item.field_77703_o, Character.valueOf('Y'), Item.field_77669_D, Character.valueOf('Z'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack(Items.attachmentLimbBolt, 1, 12)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 14), (Object[])new Object[]{"ZX ", "XAX", " XZ", Character.valueOf('X'), Item.field_77703_o, Character.valueOf('A'), Block.field_72035_aQ, Character.valueOf('Z'), Block.field_72003_bq});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 15), (Object[])new Object[]{"ZX ", "XAB", " XZ", Character.valueOf('X'), Item.field_77703_o, Character.valueOf('A'), new ItemStack(Items.attachmentLimbBolt, 1, 14), Character.valueOf('Z'), Block.field_72003_bq, Character.valueOf('B'), Block.field_72034_aR});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 8, 0), (Object[])new Object[]{"X", "#", Character.valueOf('X'), Block.field_71988_x, Character.valueOf('#'), Item.field_77669_D});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 8, 1), (Object[])new Object[]{"X", "#", Character.valueOf('X'), Block.field_71978_w, Character.valueOf('#'), Item.field_77669_D});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 8, 2), (Object[])new Object[]{"X", "#", Character.valueOf('X'), Item.field_77703_o, Character.valueOf('#'), Item.field_77669_D});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 8, 3), (Object[])new Object[]{"X", "#", Character.valueOf('X'), Item.field_77717_p, Character.valueOf('#'), Item.field_77669_D});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 8, 4), (Object[])new Object[]{"X", "#", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('#'), Item.field_77669_D});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.crossbowBench, 1), (Object[])new Object[]{"YYY", "ZXZ", "ZZZ", Character.valueOf('X'), Block.field_72060_ay, Character.valueOf('Y'), Item.field_77703_o, Character.valueOf('Z'), Block.field_71988_x});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 16), (Object[])new Object[]{"XZZ", "ZXZ", "ZZX", Character.valueOf('X'), Item.field_77709_i, Character.valueOf('Z'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 18), (Object[])new Object[]{"XZZ", "ZXZ", "ZZX", Character.valueOf('X'), Item.field_77775_ay, Character.valueOf('Z'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 17), (Object[])new Object[]{"XZZ", "ZXZ", "ZZX", Character.valueOf('X'), Block.field_72091_am, Character.valueOf('Z'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 19), (Object[])new Object[]{"XZZ", "ZXZ", "ZZX", Character.valueOf('X'), Block.field_72039_aU, Character.valueOf('Z'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 20), (Object[])new Object[]{"GZZ", "ZRZ", "ZZG", Character.valueOf('G'), Item.field_77751_aT, Character.valueOf('Z'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 21), (Object[])new Object[]{"SZZ", "ZCZ", "ZZF", Character.valueOf('S'), Item.field_77669_D, Character.valueOf('C'), Item.field_77705_m, Character.valueOf('F'), Item.field_77709_i, Character.valueOf('Z'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 22), (Object[])new Object[]{"NZZ", "ZSZ", "ZZN", Character.valueOf('N'), Item.field_77727_br, Character.valueOf('Z'), Item.field_77703_o, Character.valueOf('S'), Item.field_77728_bu});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.attachmentLimbBolt, 1, 23), (Object[])new Object[]{"XXZ", "XZX", "ZXC", Character.valueOf('C'), Item.field_77767_aC, Character.valueOf('Z'), new ItemStack(Items.attachmentLimbBolt, 1, 10), Character.valueOf('X'), Item.field_77703_o});
        for (EnumAttachmentType attachment : EnumAttachmentType.values()) {
            for (EnumCrossbowFireRate fireRate : EnumCrossbowFireRate.values()) {
                Util.addCrossbowBenchRecipe(new ItemStack((Item)Items.woodenCrossbowBase), attachment, EnumCrossbowMaterial.wooden, fireRate);
                Util.addCrossbowBenchRecipe(new ItemStack((Item)Items.stoneCrossbowBase), attachment, EnumCrossbowMaterial.stone, fireRate);
                Util.addCrossbowBenchRecipe(new ItemStack((Item)Items.ironCrossbowBase), attachment, EnumCrossbowMaterial.iron, fireRate);
                Util.addCrossbowBenchRecipe(new ItemStack((Item)Items.goldCrossbowBase), attachment, EnumCrossbowMaterial.gold, fireRate);
                Util.addCrossbowBenchRecipe(new ItemStack((Item)Items.diamondCrossbowBase), attachment, EnumCrossbowMaterial.diamond, fireRate);
            }
        }
        FMLLog.info((String)("[CROSSBOW MOD 2] Added " + CrossbowRecipes.getRecipeMap().size() + " recipes to the Crossbow Bench"), (Object[])new Object[0]);
    }

    public static void addCrossbowBenchRecipe(ItemStack baseCrossbow, EnumAttachmentType attachment, EnumCrossbowMaterial material, EnumCrossbowFireRate fireRate) {
        CrossbowRecipes.addCrossbowRecipe(new CrossbowInfo(attachment, material, fireRate), ItemCrossbow.setAttachmentAndMaterial(baseCrossbow, attachment, material, fireRate));
    }

    public static ItemStack findMatchingCrossbowRecipe(InventoryCrossbowBench inv) {
        ItemStack[] sticks = new ItemStack[]{inv.func_70301_a(3), inv.func_70301_a(4), inv.func_70301_a(5)};
        ItemStack[] limbs = new ItemStack[]{inv.func_70301_a(2), inv.func_70301_a(6), inv.func_70301_a(7), inv.func_70301_a(8), inv.func_70301_a(9)};
        ItemStack mechanism = inv.func_70301_a(1);
        ItemStack attachment = inv.func_70301_a(10);
        return CrossbowRecipes.findMatchingRecipe(sticks, limbs, mechanism, attachment);
    }

    public static boolean isWooden(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("material") == 0;
        }
        return false;
    }

    public static boolean isStone(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("material") == 1;
        }
        return false;
    }

    public static boolean isIron(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("material") == 2;
        }
        return false;
    }

    public static boolean isGold(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("material") == 3;
        }
        return false;
    }

    public static boolean isDiamond(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("material") == 4;
        }
        return false;
    }

    public static boolean hasBasicScope(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 2;
        }
        return false;
    }

    public static boolean hasLongRangeScope(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 1;
        }
        return false;
    }

    public static boolean hasLightMech(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("firerate") == 1;
        }
        return false;
    }

    public static boolean hasMediumMech(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("firerate") == 2;
        }
        return false;
    }

    public static boolean hasHeavyMech(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("firerate") == 3;
        }
        return false;
    }

    public static boolean hasTriShotMech(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("firerate") == 4;
        }
        return false;
    }

    public static boolean hasFlameAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 9;
        }
        return false;
    }

    public static boolean hasExplosiveAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 8;
        }
        return false;
    }

    public static boolean hasLavaAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 3;
        }
        return false;
    }

    public static boolean hasIceAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 4;
        }
        return false;
    }

    public static boolean hasLightningAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 7;
        }
        return false;
    }

    public static boolean hasTorchAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 6;
        }
        return false;
    }

    public static boolean hasPoisonAttachment(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            NBTTagCompound comp = stack.func_77978_p();
            return comp.func_74762_e("attachment") == 5;
        }
        return false;
    }
}

