/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.rendermodels;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import simcraft.core.rendermodels.Bone;
import simcraft.core.rendermodels.PosTransVertex;
import simcraft.core.rendermodels.TextureGrp;
import simcraft.core.rendermodels.TexturedPoly;
import simcraft.core.rendermodels.TransformGrpBone;

public abstract class ModelPoolEntry {
    public String name;
    public PosTransVertex[] vertices;
    public TexturedPoly[] faces;
    public Map groups;
    public Map textures;
    protected TransformGrpBone group;
    protected TextureGrp texture;
    protected String[] fileExtensions;

    public File checkValidPath(String path) {
        File file = null;
        for (int index = 0; !(index >= this.fileExtensions.length || file != null && file.exists()); ++index) {
            String absPath = path;
            if (!path.endsWith("." + this.fileExtensions[index])) {
                absPath = absPath + "." + this.fileExtensions[index];
            }
            file = new File(absPath);
        }
        if (file == null || !file.exists()) {
            return null;
        }
        return file;
    }

    public abstract void getModel(File var1);

    protected void setGroup(String groupName) {
        this.setGroup(groupName, new Bone(0.0f, 0.0f, 0.0f, 0.0f), 1.0);
    }

    protected void setGroup(String groupName, Bone bone, double weight) {
        if (this.groups.size() == 0 || !this.groups.containsKey(groupName)) {
            this.groups.put(groupName, new TransformGrpBone(bone, weight));
        }
        this.group = (TransformGrpBone)this.groups.get(groupName);
    }

    protected void setTextureGroup(String groupName) {
        if (this.textures.size() == 0 || !this.textures.containsKey(groupName)) {
            this.textures.put(groupName, new TextureGrp());
        }
        this.texture = (TextureGrp)this.textures.get(groupName);
    }

    protected void applyGroups(Map groupsMap, Map texturesMap) {
        String currentGroup;
        String groupKey;
        int nameIdx;
        Set groupsCol = this.groups.keySet();
        Set texturesCol = this.textures.keySet();
        Iterator groupsItr = groupsCol.iterator();
        Iterator texturesItr = texturesCol.iterator();
        while (groupsItr.hasNext()) {
            nameIdx = 0;
            groupKey = (String)groupsItr.next();
            currentGroup = this.name + "_" + nameIdx + ":" + groupKey;
            while (groupsMap.size() > 0 && groupsMap.containsKey(currentGroup)) {
                currentGroup = this.name + "_" + ++nameIdx + ":" + groupKey;
            }
            groupsMap.put(currentGroup, this.groups.get(groupKey));
        }
        while (texturesItr.hasNext()) {
            nameIdx = 0;
            groupKey = (String)texturesItr.next();
            currentGroup = this.name + "_" + nameIdx + ":" + groupKey;
            while (groupsMap.size() > 0 && texturesMap.containsKey(currentGroup)) {
                currentGroup = this.name + "_" + ++nameIdx + ":" + groupKey;
            }
            texturesMap.put(currentGroup, this.textures.get(groupKey));
        }
    }
}

