/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.rendermodels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import simcraft.core.rendermodels.Bone;
import simcraft.core.rendermodels.Coord2D;
import simcraft.core.rendermodels.ModelPool;
import simcraft.core.rendermodels.ModelPoolEntry;
import simcraft.core.rendermodels.PosTransVertex;
import simcraft.core.rendermodels.Shape2D;
import simcraft.core.rendermodels.Shape3D;
import simcraft.core.rendermodels.TextureGrp;
import simcraft.core.rendermodels.TexturedPoly;
import simcraft.core.rendermodels.TransformGrp;
import simcraft.core.rendermodels.TransformGrpBone;

public class ModelRenderCustom
extends bdi {
    private int boundTexture;
    private bct[] vertices = new bct[0];
    private TexturedPoly[] faces = new TexturedPoly[0];
    private int textureOffsetX;
    private int textureOffsetY;
    private boolean compiled = false;
    private int displayList = 0;
    private int[] displayListArray;
    private Map transformGroup = new HashMap();
    private Map textureGroup;
    private TransformGrp currentGroup;
    private TextureGrp currentTextureGroup;
    public boolean i = false;
    public boolean flip = false;
    public boolean j = true;
    public boolean field_1402_i = false;
    public boolean forcedRecompile = false;
    public boolean useLegacyCompiler;
    public List l;
    public List m;
    public final String boxName;
    private String defaultTexture;
    public static final int MR_FRONT = 0;
    public static final int MR_BACK = 1;
    public static final int MR_LEFT = 2;
    public static final int MR_RIGHT = 3;
    public static final int MR_TOP = 4;
    public static final int MR_BOTTOM = 5;
    private static final float pi = (float)Math.PI;

    public ModelRenderCustom(bcd modelbase, String s) {
        super(modelbase, s);
        this.transformGroup.put("0", new TransformGrpBone(new Bone(0.0f, 0.0f, 0.0f, 0.0f), 1.0));
        this.textureGroup = new HashMap();
        this.textureGroup.put("0", new TextureGrp());
        this.currentTextureGroup = (TextureGrp)this.textureGroup.get("0");
        this.boxName = s;
        this.defaultTexture = "";
        this.useLegacyCompiler = false;
    }

    public ModelRenderCustom(bcd modelbase) {
        this(modelbase, null);
    }

    public ModelRenderCustom(bcd modelbase, int textureX, int textureY) {
        this(modelbase, textureX, textureY, 64, 32);
    }

    public ModelRenderCustom(bcd modelbase, int textureX, int textureY, int textureU, int textureV) {
        this(modelbase);
        this.textureOffsetX = textureX;
        this.textureOffsetY = textureY;
        this.a = textureU;
        this.b = textureV;
    }

    public void addPolygon(bct[] verts) {
        this.copyTo(verts, new TexturedPoly[]{new TexturedPoly(verts)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(bct[] verts, int[][] uv) {
        try {
            for (int i = 0; i < verts.length; ++i) {
                verts[i] = verts[i].a((float)uv[i][0] / this.a, (float)uv[i][1] / this.b);
            }
        }
        finally {
            this.addPolygon(verts);
        }
    }

    public void addPolygon(bct[] verts, int u1, int v1, int u2, int v2) {
        this.copyTo(verts, new TexturedPoly[]{this.addPolygonReturn(verts, u1, v1, u2, v2)});
    }

    private TexturedPoly addPolygonReturn(bct[] verts, int u1, int v1, int u2, int v2) {
        if (verts.length < 3) {
            return null;
        }
        float uOffs = 1.0f / (this.a * 10.0f);
        float vOffs = 1.0f / (this.b * 10.0f);
        if (verts.length < 4) {
            float xMin = -1.0f;
            float yMin = -1.0f;
            float xMax = 0.0f;
            float yMax = 0.0f;
            for (int i = 0; i < verts.length; ++i) {
                float xPos = verts[i].b;
                float yPos = verts[i].c;
                xMax = Math.max(xMax, xPos);
                xMin = xMin < -1.0f ? xPos : Math.min(xMin, xPos);
                yMax = Math.max(yMax, yPos);
                yMin = yMin < -1.0f ? yPos : Math.min(yMin, yPos);
            }
            float uMin = (float)u1 / this.a + uOffs;
            float vMin = (float)v1 / this.b + vOffs;
            float uSize = (float)(u2 - u1) / this.a - uOffs * 2.0f;
            float vSize = (float)(v2 - v1) / this.b - vOffs * 2.0f;
            float xSize = xMax - xMin;
            float ySize = yMax - yMin;
            for (int i = 0; i < verts.length; ++i) {
                float xPos = verts[i].b;
                float yPos = verts[i].c;
                xPos = (xPos - xMin) / xSize;
                yPos = (yPos - yMin) / ySize;
                verts[i] = verts[i].a(uMin + xPos * uSize, vMin + yPos * vSize);
            }
        } else {
            verts[0] = verts[0].a((float)u2 / this.a - uOffs, (float)v1 / this.b + vOffs);
            verts[1] = verts[1].a((float)u1 / this.a + uOffs, (float)v1 / this.b + vOffs);
            verts[2] = verts[2].a((float)u1 / this.a + uOffs, (float)v2 / this.b - vOffs);
            verts[3] = verts[3].a((float)u2 / this.a - uOffs, (float)v2 / this.b - vOffs);
        }
        return new TexturedPoly(verts);
    }

    public void addRectShape(float[] v, float[] v1, float[] v2, float[] v3, float[] v4, float[] v5, float[] v6, float[] v7, int w, int h, int d) {
        bct[] verts = new bct[8];
        TexturedPoly[] poly = new TexturedPoly[6];
        bct positionTexturevertex = new bct(v[0], v[1], v[2], 0.0f, 0.0f);
        bct positionTexturevertex1 = new bct(v1[0], v1[1], v1[2], 0.0f, 8.0f);
        bct positionTexturevertex2 = new bct(v2[0], v2[1], v2[2], 8.0f, 8.0f);
        bct positionTexturevertex3 = new bct(v3[0], v3[1], v3[2], 8.0f, 0.0f);
        bct positionTexturevertex4 = new bct(v4[0], v4[1], v4[2], 0.0f, 0.0f);
        bct positionTexturevertex5 = new bct(v5[0], v5[1], v5[2], 0.0f, 8.0f);
        bct positionTexturevertex6 = new bct(v6[0], v6[1], v6[2], 8.0f, 8.0f);
        bct positionTexturevertex7 = new bct(v7[0], v7[1], v7[2], 8.0f, 0.0f);
        verts[0] = positionTexturevertex;
        verts[1] = positionTexturevertex1;
        verts[2] = positionTexturevertex2;
        verts[3] = positionTexturevertex3;
        verts[4] = positionTexturevertex4;
        verts[5] = positionTexturevertex5;
        verts[6] = positionTexturevertex6;
        verts[7] = positionTexturevertex7;
        poly[0] = this.addPolygonReturn(new bct[]{positionTexturevertex5, positionTexturevertex1, positionTexturevertex2, positionTexturevertex6}, this.textureOffsetX + d + w, this.textureOffsetY + d, this.textureOffsetX + d + w + d, this.textureOffsetY + d + h);
        poly[1] = this.addPolygonReturn(new bct[]{positionTexturevertex, positionTexturevertex4, positionTexturevertex7, positionTexturevertex3}, this.textureOffsetX + 0, this.textureOffsetY + d, this.textureOffsetX + d, this.textureOffsetY + d + h);
        poly[2] = this.addPolygonReturn(new bct[]{positionTexturevertex5, positionTexturevertex4, positionTexturevertex, positionTexturevertex1}, this.textureOffsetX + d, this.textureOffsetY + 0, this.textureOffsetX + d + w, this.textureOffsetY + d);
        poly[3] = this.addPolygonReturn(new bct[]{positionTexturevertex2, positionTexturevertex3, positionTexturevertex7, positionTexturevertex6}, this.textureOffsetX + d + w, this.textureOffsetY + 0, this.textureOffsetX + d + w + w, this.textureOffsetY + d);
        poly[4] = this.addPolygonReturn(new bct[]{positionTexturevertex1, positionTexturevertex, positionTexturevertex3, positionTexturevertex2}, this.textureOffsetX + d, this.textureOffsetY + d, this.textureOffsetX + d + w, this.textureOffsetY + d + h);
        poly[5] = this.addPolygonReturn(new bct[]{positionTexturevertex4, positionTexturevertex5, positionTexturevertex6, positionTexturevertex7}, this.textureOffsetX + d + w + d, this.textureOffsetY + d, this.textureOffsetX + d + w + d + w, this.textureOffsetY + d + h);
        if (this.i ^ this.flip) {
            for (int l = 0; l < poly.length; ++l) {
                poly[l].a();
            }
        }
        this.copyTo(verts, poly);
    }

    public ModelRenderCustom addBox(float x, float y, float z, int w, int h, int d) {
        this.a(x, y, z, w, h, d, 0.0f);
        return this;
    }

    public void a(float x, float y, float z, int w, int h, int d, float expansion) {
        this.addBox(x, y, z, w, h, d, expansion, 1.0f);
    }

    public void addBox(float x, float y, float z, int w, int h, int d, float expansion, float scale) {
        float scaleX = (float)w * scale;
        float scaleY = (float)h * scale;
        float scaleZ = (float)d * scale;
        float x1 = x + scaleX;
        float y1 = y + scaleY;
        float z1 = z + scaleZ;
        float expX = expansion + scaleX - (float)w;
        float expY = expansion + scaleY - (float)h;
        float expZ = expansion + scaleZ - (float)d;
        x -= expX;
        y -= expY;
        z -= expZ;
        x1 += expansion;
        y1 += expansion;
        z1 += expansion;
        if (this.i) {
            float xTemp = x1;
            x1 = x;
            x = xTemp;
        }
        float[] v = new float[]{x, y, z};
        float[] v1 = new float[]{x1, y, z};
        float[] v2 = new float[]{x1, y1, z};
        float[] v3 = new float[]{x, y1, z};
        float[] v4 = new float[]{x, y, z1};
        float[] v5 = new float[]{x1, y, z1};
        float[] v6 = new float[]{x1, y1, z1};
        float[] v7 = new float[]{x, y1, z1};
        this.addRectShape(v, v1, v2, v3, v4, v5, v6, v7, w, h, d);
    }

    public void addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        int m;
        float f4 = x + (float)w;
        float f5 = y + (float)h;
        float f6 = z + (float)d;
        x -= scale;
        y -= scale;
        z -= scale;
        f4 += scale;
        f5 += scale;
        f6 += scale;
        int n = m = this.i ? -1 : 1;
        if (this.i) {
            float f7 = f4;
            f4 = x;
            x = f7;
        }
        float[] v = new float[]{x, y, z};
        float[] v1 = new float[]{f4, y, z};
        float[] v2 = new float[]{f4, f5, z};
        float[] v3 = new float[]{x, f5, z};
        float[] v4 = new float[]{x, y, f6};
        float[] v5 = new float[]{f4, y, f6};
        float[] v6 = new float[]{f4, f5, f6};
        float[] v7 = new float[]{x, f5, f6};
        switch (dir) {
            case 3: {
                v[1] = v[1] - bottomScale;
                v[2] = v[2] - bottomScale;
                v3[1] = v3[1] + bottomScale;
                v3[2] = v3[2] - bottomScale;
                v4[1] = v4[1] - bottomScale;
                v4[2] = v4[2] + bottomScale;
                v7[1] = v7[1] + bottomScale;
                v7[2] = v7[2] + bottomScale;
                break;
            }
            case 2: {
                v1[1] = v1[1] - bottomScale;
                v1[2] = v1[2] - bottomScale;
                v2[1] = v2[1] + bottomScale;
                v2[2] = v2[2] - bottomScale;
                v5[1] = v5[1] - bottomScale;
                v5[2] = v5[2] + bottomScale;
                v6[1] = v6[1] + bottomScale;
                v6[2] = v6[2] + bottomScale;
                break;
            }
            case 0: {
                v[0] = v[0] - (float)m * bottomScale;
                v[1] = v[1] - bottomScale;
                v1[0] = v1[0] + (float)m * bottomScale;
                v1[1] = v1[1] - bottomScale;
                v2[0] = v2[0] + (float)m * bottomScale;
                v2[1] = v2[1] + bottomScale;
                v3[0] = v3[0] - (float)m * bottomScale;
                v3[1] = v3[1] + bottomScale;
                break;
            }
            case 1: {
                v4[0] = v4[0] - (float)m * bottomScale;
                v4[1] = v4[1] - bottomScale;
                v5[0] = v5[0] + (float)m * bottomScale;
                v5[1] = v5[1] - bottomScale;
                v6[0] = v6[0] + (float)m * bottomScale;
                v6[1] = v6[1] + bottomScale;
                v7[0] = v7[0] - (float)m * bottomScale;
                v7[1] = v7[1] + bottomScale;
                break;
            }
            case 4: {
                v[0] = v[0] - (float)m * bottomScale;
                v[2] = v[2] - bottomScale;
                v1[0] = v1[0] + (float)m * bottomScale;
                v1[2] = v1[2] - bottomScale;
                v4[0] = v4[0] - (float)m * bottomScale;
                v4[2] = v4[2] + bottomScale;
                v5[0] = v5[0] + (float)m * bottomScale;
                v5[2] = v5[2] + bottomScale;
                break;
            }
            case 5: {
                v2[0] = v2[0] + (float)m * bottomScale;
                v2[2] = v2[2] - bottomScale;
                v3[0] = v3[0] - (float)m * bottomScale;
                v3[2] = v3[2] - bottomScale;
                v6[0] = v6[0] + (float)m * bottomScale;
                v6[2] = v6[2] + bottomScale;
                v7[0] = v7[0] - (float)m * bottomScale;
                v7[2] = v7[2] + bottomScale;
            }
        }
        this.addRectShape(v, v1, v2, v3, v4, v5, v6, v7, w, h, d);
    }

    public void addShape3D(float x, float y, float z, Coord2D[] coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        this.addShape3D(x, y, z, coordinates, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public void addShape3D(float x, float y, float z, Coord2D[] coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        this.addShape3D(x, y, z, new Shape2D(coordinates), depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, faceLengths);
    }

    public void addShape3D(float x, float y, float z, ArrayList coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        this.addShape3D(x, y, z, coordinates, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public void addShape3D(float x, float y, float z, ArrayList coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        this.addShape3D(x, y, z, new Shape2D(coordinates), depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, faceLengths);
    }

    public void addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public void addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        switch (direction) {
            case 2: {
                rotY = 1.5707964f;
                break;
            }
            case 3: {
                rotY = -1.5707964f;
                break;
            }
            case 4: {
                rotX = 1.5707964f;
                break;
            }
            case 5: {
                rotX = -1.5707964f;
                break;
            }
            case 0: {
                rotY = (float)Math.PI;
                break;
            }
        }
        this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, rotX, rotY, rotZ, faceLengths);
    }

    public void addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float rotX, float rotY, float rotZ) {
        this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, rotX, rotY, rotZ, null);
    }

    public void addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float rotX, float rotY, float rotZ, float[] faceLengths) {
        Shape3D shape3D = shape.extrude(x, y, z, rotX, rotY, rotZ, depth, this.textureOffsetX, this.textureOffsetY, this.a, this.b, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, faceLengths);
        if (this.flip) {
            for (int idx = 0; idx < shape3D.faces.length; ++idx) {
                shape3D.faces[idx].a();
            }
        }
        this.copyTo((bct[])shape3D.vertices, shape3D.faces);
    }

    public void addPixel(float x, float y, float z, float width, float height, float length) {
        this.addPixel(x, y, z, new float[]{width, height, length}, this.textureOffsetX, this.textureOffsetY);
    }

    public void addPixel(float x, float y, float z, float[] scale, int w, int h) {
        bct[] verts = new bct[8];
        TexturedPoly[] poly = new TexturedPoly[6];
        float x1 = x + scale[0];
        float y1 = y + scale[1];
        float z1 = z + scale[2];
        float[] f = new float[]{x, y, z};
        float[] f1 = new float[]{x1, y, z};
        float[] f2 = new float[]{x1, y1, z};
        float[] f3 = new float[]{x, y1, z};
        float[] f4 = new float[]{x, y, z1};
        float[] f5 = new float[]{x1, y, z1};
        float[] f6 = new float[]{x1, y1, z1};
        float[] f7 = new float[]{x, y1, z1};
        bct positionTexturevertex = new bct(f[0], f[1], f[2], 0.0f, 0.0f);
        bct positionTexturevertex1 = new bct(f1[0], f1[1], f1[2], 0.0f, 8.0f);
        bct positionTexturevertex2 = new bct(f2[0], f2[1], f2[2], 8.0f, 8.0f);
        bct positionTexturevertex3 = new bct(f3[0], f3[1], f3[2], 8.0f, 0.0f);
        bct positionTexturevertex4 = new bct(f4[0], f4[1], f4[2], 0.0f, 0.0f);
        bct positionTexturevertex5 = new bct(f5[0], f5[1], f5[2], 0.0f, 8.0f);
        bct positionTexturevertex6 = new bct(f6[0], f6[1], f6[2], 8.0f, 8.0f);
        bct positionTexturevertex7 = new bct(f7[0], f7[1], f7[2], 8.0f, 0.0f);
        verts[0] = positionTexturevertex;
        verts[1] = positionTexturevertex1;
        verts[2] = positionTexturevertex2;
        verts[3] = positionTexturevertex3;
        verts[4] = positionTexturevertex4;
        verts[5] = positionTexturevertex5;
        verts[6] = positionTexturevertex6;
        verts[7] = positionTexturevertex7;
        poly[0] = this.addPolygonReturn(new bct[]{positionTexturevertex5, positionTexturevertex1, positionTexturevertex2, positionTexturevertex6}, w, h, w + 1, h + 1);
        poly[1] = this.addPolygonReturn(new bct[]{positionTexturevertex, positionTexturevertex4, positionTexturevertex7, positionTexturevertex3}, w, h, w + 1, h + 1);
        poly[2] = this.addPolygonReturn(new bct[]{positionTexturevertex5, positionTexturevertex4, positionTexturevertex, positionTexturevertex1}, w, h, w + 1, h + 1);
        poly[3] = this.addPolygonReturn(new bct[]{positionTexturevertex2, positionTexturevertex3, positionTexturevertex7, positionTexturevertex6}, w, h, w + 1, h + 1);
        poly[4] = this.addPolygonReturn(new bct[]{positionTexturevertex1, positionTexturevertex, positionTexturevertex3, positionTexturevertex2}, w, h, w + 1, h + 1);
        poly[5] = this.addPolygonReturn(new bct[]{positionTexturevertex4, positionTexturevertex5, positionTexturevertex6, positionTexturevertex7}, w, h, w + 1, h + 1);
        this.copyTo(verts, poly);
    }

    public void addSprite(float x, float y, float z, int w, int h, float expansion) {
        this.addSprite(x, y, z, w, h, 1, false, false, false, false, false, expansion);
    }

    public void addSprite(float x, float y, float z, int w, int h, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        this.addSprite(x, y, z, w, h, 1, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public void addSprite(float x, float y, float z, int w, int h, int d, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        this.addSprite(x, y, z, w, h, d, 1.0f, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public void addSprite(float x, float y, float z, int w, int h, int d, float pixelScale, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        Object[] mask = new String[h];
        char[] str = new char[w];
        Arrays.fill(str, '1');
        Arrays.fill(mask, new String(str));
        this.addSprite(x, y, z, (String[])mask, d, pixelScale, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public void addSprite(float x, float y, float z, String[] mask, int d, float pixelScale, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        int w = mask[0].length();
        int h = mask.length;
        float x1 = x - expansion;
        float y1 = y - expansion;
        float z1 = z - expansion;
        int wDir = 0;
        int hDir = 0;
        int dDir = 0;
        float wScale = 1.0f + expansion / ((float)w * pixelScale);
        float hScale = 1.0f + expansion / ((float)h * pixelScale);
        if (!rotX) {
            if (!rotY) {
                if (!rotZ) {
                    wDir = 0;
                    hDir = 1;
                    dDir = 2;
                } else {
                    wDir = 1;
                    hDir = 0;
                    dDir = 2;
                }
            } else if (!rotZ) {
                wDir = 2;
                hDir = 1;
                dDir = 0;
            } else {
                wDir = 2;
                hDir = 0;
                dDir = 1;
            }
        } else if (!rotY) {
            if (!rotZ) {
                wDir = 0;
                hDir = 2;
                dDir = 1;
            } else {
                wDir = 1;
                hDir = 2;
                dDir = 0;
            }
        } else if (!rotZ) {
            wDir = 2;
            hDir = 0;
            dDir = 1;
        } else {
            wDir = 2;
            hDir = 1;
            dDir = 0;
        }
        int texStartX = this.textureOffsetX + (mirrorX ? w * 1 - 1 : 0);
        int texStartY = this.textureOffsetY + (mirrorY ? h * 1 - 1 : 0);
        int texDirX = mirrorX ? -1 : 1;
        int texDirY = mirrorY ? -1 : 1;
        float wVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, wDir, 1, 1);
        float hVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, hDir, 1, 1);
        float dVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, dDir, 1, 1);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                if (mask[j].charAt(i) != '1') continue;
                this.addPixel(x1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 0, i, j), y1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 1, i, j), z1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 2, i, j), new float[]{wVoxSize, hVoxSize, dVoxSize}, texStartX + texDirX * i, texStartY + texDirY * j);
            }
        }
    }

    private float getPixelSize(float wScale, float hScale, float dScale, int wDir, int hDir, int checkDir, int texPosX, int texPosY) {
        return wDir == checkDir ? wScale * (float)texPosX : (hDir == checkDir ? hScale * (float)texPosY : dScale);
    }

    public void addSphere(float x, float y, float z, float r2, int segs, int rings, int textureW, int textureH) {
        bct[] verts;
        if (segs < 3) {
            segs = 3;
        }
        bct[] tempVerts = new bct[segs * (++rings - 1) + 2];
        TexturedPoly[] poly = new TexturedPoly[segs * rings];
        tempVerts[0] = new bct(x, y - r2, z, 0.0f, 0.0f);
        tempVerts[tempVerts.length - 1] = new bct(x, y + r2, z, 0.0f, 0.0f);
        float uOffs = 1.0f / (this.a * 10.0f);
        float vOffs = 1.0f / (this.b * 10.0f);
        float texW = (float)textureW / this.a - 2.0f * uOffs;
        float texH = (float)textureH / this.b - 2.0f * vOffs;
        float segW = texW / (float)segs;
        float segH = texH / (float)rings;
        float startU = (float)this.textureOffsetX / this.a;
        float startV = (float)this.textureOffsetY / this.b;
        int currentFace = 0;
        for (int j = 1; j < rings; ++j) {
            for (int i = 0; i < segs; ++i) {
                float yWidth = kx.b((float)(-1.5707964f + (float)Math.PI / (float)rings * (float)j));
                float yHeight = kx.a((float)(-1.5707964f + (float)Math.PI / (float)rings * (float)j));
                float xSize = kx.a((float)((float)Math.PI / (float)segs * (float)i * 2.0f + (float)Math.PI)) * yWidth;
                float zSize = -kx.b((float)((float)Math.PI / (float)segs * (float)i * 2.0f + (float)Math.PI)) * yWidth;
                int curVert = 1 + i + segs * (j - 1);
                tempVerts[curVert] = new bct(x + xSize * r2, y + yHeight * r2, z + zSize * r2, 0.0f, 0.0f);
                if (i <= 0) continue;
                bct[] verts2 = j == 1 ? new bct[]{tempVerts[curVert].a(startU + segW * (float)i, startV + segH * (float)j), tempVerts[curVert - 1].a(startU + segW * (float)(i - 1), startV + segH * (float)j), tempVerts[0].a(startU + segW * (float)(i - 1), startV), tempVerts[0].a(startU + segW + segW * (float)i, startV)} : new bct[]{tempVerts[curVert].a(startU + segW * (float)i, startV + segH * (float)j), tempVerts[curVert - 1].a(startU + segW * (float)(i - 1), startV + segH * (float)j), tempVerts[curVert - 1 - segs].a(startU + segW * (float)(i - 1), startV + segH * (float)(j - 1)), tempVerts[curVert - segs].a(startU + segW * (float)i, startV + segH * (float)(j - 1))};
                poly[currentFace] = new TexturedPoly(verts2);
                ++currentFace;
            }
            verts = j == 1 ? new bct[]{tempVerts[1].a(startU + segW * (float)segs, startV + segH * (float)j), tempVerts[segs].a(startU + segW * (float)(segs - 1), startV + segH * (float)j), tempVerts[0].a(startU + segW * (float)(segs - 1), startV), tempVerts[0].a(startU + segW * (float)segs, startV)} : new bct[]{tempVerts[1 + segs * (j - 1)].a(startU + texW, startV + segH * (float)j), tempVerts[segs * (j - 1) + segs].a(startU + texW - segW, startV + segH * (float)j), tempVerts[segs * (j - 1)].a(startU + texW - segW, startV + segH * (float)(j - 1)), tempVerts[1 + segs * (j - 1) - segs].a(startU + texW, startV + segH * (float)(j - 1))};
            poly[currentFace] = new TexturedPoly(verts);
            ++currentFace;
        }
        for (int i = 0; i < segs; ++i) {
            verts = new bct[3];
            int curVert = tempVerts.length - (segs + 1);
            verts[0] = tempVerts[tempVerts.length - 1].a(startU + segW * ((float)i + 0.5f), startV + texH);
            verts[1] = tempVerts[curVert + i].a(startU + segW * (float)i, startV + texH - segH);
            verts[2] = tempVerts[curVert + (i + 1) % segs].a(startU + segW * (float)(i + 1), startV + texH - segH);
            poly[currentFace] = new TexturedPoly(verts);
            ++currentFace;
        }
        this.copyTo(tempVerts, poly);
    }

    public void addCone(float x, float y, float z, float radius, float length, int segments) {
        this.addCone(x, y, z, radius, length, segments, 1.0f);
    }

    public void addCone(float x, float y, float z, float radius, float length, int segments, float baseScale) {
        this.addCone(x, y, z, radius, length, segments, baseScale, 4);
    }

    public void addCone(float x, float y, float z, float radius, float length, int segments, float baseScale, int baseDirection) {
        this.addCone(x, y, z, radius, length, segments, baseScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f));
    }

    public void addCone(float x, float y, float z, float radius, float length, int segments, float baseScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH) {
        this.addCylinder(x, y, z, radius, length, segments, baseScale, 0.0f, baseDirection, textureCircleDiameterW, textureCircleDiameterH, 1);
    }

    public void addCylinder(float x, float y, float z, float radius, float length, int segments) {
        this.addCylinder(x, y, z, radius, length, segments, 1.0f, 1.0f);
    }

    public void addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale) {
        this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, 4);
    }

    public void addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection) {
        this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length));
    }

    public void addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH, int textureH) {
        boolean coneTop;
        boolean dirTop = baseDirection == 4 || baseDirection == 5;
        boolean dirSide = baseDirection == 3 || baseDirection == 2;
        boolean dirFront = baseDirection == 0 || baseDirection == 1;
        boolean dirMirror = baseDirection == 2 || baseDirection == 5 || baseDirection == 1;
        boolean coneBase = baseScale == 0.0f;
        boolean bl = coneTop = topScale == 0.0f;
        if (coneBase && coneTop) {
            baseScale = 1.0f;
            coneBase = false;
        }
        bct[] tempVerts = new bct[segments * (coneBase || coneTop ? 1 : 2) + 2];
        TexturedPoly[] poly = new TexturedPoly[segments * (coneBase || coneTop ? 2 : 3)];
        float xLength = dirSide ? length : 0.0f;
        float yLength = dirTop ? length : 0.0f;
        float zLength = dirFront ? length : 0.0f;
        float xStart = dirMirror ? x + xLength : x;
        float yStart = dirMirror ? y + yLength : y;
        float zStart = dirMirror ? z + zLength : z;
        float xEnd = !dirMirror ? x + xLength : x;
        float yEnd = !dirMirror ? y + yLength : y;
        float zEnd = !dirMirror ? z + zLength : z;
        tempVerts[0] = new bct(xStart, yStart, zStart, 0.0f, 0.0f);
        tempVerts[tempVerts.length - 1] = new bct(xEnd, yEnd, zEnd, 0.0f, 0.0f);
        float xCur = xStart;
        float yCur = yStart;
        float zCur = zStart;
        float sCur = coneBase ? topScale : baseScale;
        for (int repeat = 0; repeat < (coneBase || coneTop ? 1 : 2); ++repeat) {
            for (int index = 0; index < segments; ++index) {
                float xSize = (float)(this.i ^ dirMirror ? -1 : 1) * kx.a((float)((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI)) * radius * sCur;
                float zSize = -kx.b((float)((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI)) * radius * sCur;
                float xPlace = xCur + (!dirSide ? xSize : 0.0f);
                float yPlace = yCur + (!dirTop ? zSize : 0.0f);
                float zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                tempVerts[1 + index + repeat * segments] = new bct(xPlace, yPlace, zPlace, 0.0f, 0.0f);
            }
            xCur = xEnd;
            yCur = yEnd;
            zCur = zEnd;
            sCur = topScale;
        }
        float uScale = 1.0f / this.a;
        float vScale = 1.0f / this.b;
        float uOffset = uScale / 20.0f;
        float vOffset = vScale / 20.0f;
        float uCircle = (float)textureCircleDiameterW * uScale;
        float vCircle = (float)textureCircleDiameterH * vScale;
        float uWidth = (uCircle * 2.0f - uOffset * 2.0f) / (float)segments;
        float vHeight = (float)textureH * vScale - uOffset * 2.0f;
        float uStart = (float)this.textureOffsetX * uScale;
        float vStart = (float)this.textureOffsetY * vScale;
        for (int index = 0; index < segments; ++index) {
            int index2 = (index + 1) % segments;
            float uSize = kx.a((float)((float)Math.PI / (float)segments * (float)index * 2.0f + (!dirTop ? 0.0f : (float)Math.PI))) * (0.5f * uCircle - 2.0f * uOffset);
            float vSize = kx.b((float)((float)Math.PI / (float)segments * (float)index * 2.0f + (!dirTop ? 0.0f : (float)Math.PI))) * (0.5f * vCircle - 2.0f * vOffset);
            float uSize1 = kx.a((float)((float)Math.PI / (float)segments * (float)index2 * 2.0f + (!dirTop ? 0.0f : (float)Math.PI))) * (0.5f * uCircle - 2.0f * uOffset);
            float vSize1 = kx.b((float)((float)Math.PI / (float)segments * (float)index2 * 2.0f + (!dirTop ? 0.0f : (float)Math.PI))) * (0.5f * vCircle - 2.0f * vOffset);
            bct[] vert = new bct[]{tempVerts[0].a(uStart + 0.5f * uCircle, vStart + 0.5f * vCircle), tempVerts[1 + index2].a(uStart + 0.5f * uCircle + uSize1, vStart + 0.5f * vCircle + vSize1), tempVerts[1 + index].a(uStart + 0.5f * uCircle + uSize, vStart + 0.5f * vCircle + vSize)};
            poly[index] = new TexturedPoly(vert);
            if (this.i ^ this.flip) {
                poly[index].a();
            }
            if (!coneBase && !coneTop) {
                vert = new bct[]{tempVerts[1 + index].a(uStart + uOffset + uWidth * (float)index, vStart + vOffset + vCircle), tempVerts[1 + index2].a(uStart + uOffset + uWidth * (float)(index + 1), vStart + vOffset + vCircle), tempVerts[1 + segments + index2].a(uStart + uOffset + uWidth * (float)(index + 1), vStart + vOffset + vCircle + vHeight), tempVerts[1 + segments + index].a(uStart + uOffset + uWidth * (float)index, vStart + vOffset + vCircle + vHeight)};
                poly[index + segments] = new TexturedPoly(vert);
                if (this.i ^ this.flip) {
                    poly[index + segments].a();
                }
            }
            vert = new bct[]{tempVerts[tempVerts.length - 1].a(uStart + 1.5f * uCircle, vStart + 0.5f * vCircle), tempVerts[tempVerts.length - 2 - index].a(uStart + 1.5f * uCircle + uSize1, vStart + 0.5f * vCircle + vSize1), tempVerts[tempVerts.length - (1 + segments) + (segments - index) % segments].a(uStart + 1.5f * uCircle + uSize, vStart + 0.5f * vCircle + vSize)};
            poly[poly.length - segments + index] = new TexturedPoly(vert);
            if (!(this.i ^ this.flip)) continue;
            poly[poly.length - segments + index].a();
        }
        this.copyTo(tempVerts, poly);
    }

    public void addObj(String file) {
        this.addModel(file, ModelPool.OBJ);
    }

    public void addModel(String file, Class modelFormat) {
        ModelPoolEntry entry = ModelPool.addFile(file, modelFormat, this.transformGroup, this.textureGroup);
        if (entry == null) {
            return;
        }
        bct[] verts = Arrays.copyOf(entry.vertices, entry.vertices.length);
        TexturedPoly[] poly = Arrays.copyOf(entry.faces, entry.faces.length);
        if (this.flip) {
            for (int l = 0; l < this.faces.length; ++l) {
                this.faces[l].a();
            }
        }
        this.copyTo(verts, poly, false);
    }

    public ModelRenderCustom setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public void setPosition(float x, float y, float z) {
        this.c = x;
        this.d = y;
        this.e = z;
    }

    public void doMirror(boolean x, boolean y, boolean z) {
        for (int i = 0; i < this.faces.length; ++i) {
            bct[] verts = this.faces[i].a;
            for (int j = 0; j < verts.length; ++j) {
                verts[j].a.c = verts[j].a.c * (double)(x ? -1 : 1);
                verts[j].a.d = verts[j].a.d * (double)(y ? -1 : 1);
                verts[j].a.e = verts[j].a.e * (double)(z ? -1 : 1);
            }
            if (!(x ^ y ^ z)) continue;
            this.faces[i].a();
        }
    }

    public void setMirrored(boolean isMirrored) {
        this.i = isMirrored;
    }

    public void setFlipped(boolean isFlipped) {
        this.flip = isFlipped;
    }

    public void clear() {
        this.vertices = new bct[0];
        this.faces = new TexturedPoly[0];
        this.transformGroup.clear();
        this.transformGroup.put("0", new TransformGrpBone(new Bone(0.0f, 0.0f, 0.0f, 0.0f), 1.0));
        this.currentGroup = (TransformGrp)this.transformGroup.get("0");
    }

    public void copyTo(bct[] verts, TexturedPoly[] poly) {
        this.copyTo(verts, poly, true);
    }

    public void copyTo(bct[] verts, TexturedPoly[] poly, boolean copyGroup) {
        int idx;
        this.vertices = Arrays.copyOf(this.vertices, this.vertices.length + verts.length);
        this.faces = Arrays.copyOf(this.faces, this.faces.length + poly.length);
        for (idx = 0; idx < verts.length; ++idx) {
            this.vertices[this.vertices.length - verts.length + idx] = verts[idx];
            if (!copyGroup || !(verts[idx] instanceof PosTransVertex)) continue;
            ((PosTransVertex)verts[idx]).addGroup(this.currentGroup);
        }
        for (idx = 0; idx < poly.length; ++idx) {
            this.faces[this.faces.length - poly.length + idx] = poly[idx];
            if (!copyGroup) continue;
            this.currentTextureGroup.addPoly(poly[idx]);
        }
    }

    public void copyTo(bct[] verts, bcg[] quad) {
        TexturedPoly[] poly = new TexturedPoly[quad.length];
        for (int idx = 0; idx < quad.length; ++idx) {
            poly[idx] = new TexturedPoly(quad[idx].a);
        }
        this.copyTo(verts, poly);
    }

    public void setGroup(String groupName) {
        this.setGroup(groupName, new Bone(0.0f, 0.0f, 0.0f, 0.0f), 1.0);
    }

    public void setGroup(String groupName, Bone bone, double weight) {
        if (!this.transformGroup.containsKey(groupName)) {
            this.transformGroup.put(groupName, new TransformGrpBone(bone, weight));
        }
        this.currentGroup = (TransformGrp)this.transformGroup.get(groupName);
    }

    public TransformGrp getGroup() {
        return this.currentGroup;
    }

    public TransformGrp getGroup(String groupName) {
        if (!this.transformGroup.containsKey(groupName)) {
            return null;
        }
        return (TransformGrp)this.transformGroup.get(groupName);
    }

    public void setTextureGroup(String groupName) {
        if (!this.textureGroup.containsKey(groupName)) {
            this.textureGroup.put(groupName, new TextureGrp());
        }
        this.currentTextureGroup = (TextureGrp)this.textureGroup.get(groupName);
    }

    public TextureGrp getTextureGroup() {
        return this.currentTextureGroup;
    }

    public TextureGrp getTextureGroup(String groupName) {
        if (!this.textureGroup.containsKey(groupName)) {
            return null;
        }
        return (TextureGrp)this.textureGroup.get(groupName);
    }

    public void setGroupTexture(String s) {
        this.currentTextureGroup.texture = s;
    }

    public void setDefaultTexture(String s) {
        this.defaultTexture = s;
    }

    public void a(float worldScale) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.j) {
            return;
        }
        if (!this.compiled || this.forcedRecompile) {
            this.compileDisplayList(worldScale);
        }
        if (this.f != 0.0f || this.g != 0.0f || this.h != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.c * worldScale), (float)(this.d * worldScale), (float)(this.e * worldScale));
            if (this.h != 0.0f) {
                GL11.glRotatef((float)(this.h * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.g != 0.0f) {
                GL11.glRotatef((float)(this.g * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.f != 0.0f) {
                GL11.glRotatef((float)(this.f * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            this.callDisplayList();
            if (this.m != null) {
                for (int i = 0; i < this.m.size(); ++i) {
                    ((bdi)this.m.get(i)).a(worldScale);
                }
            }
            GL11.glPopMatrix();
        } else if (this.c != 0.0f || this.d != 0.0f || this.e != 0.0f) {
            GL11.glTranslatef((float)(this.c * worldScale), (float)(this.d * worldScale), (float)(this.e * worldScale));
            this.callDisplayList();
            if (this.m != null) {
                for (int i = 0; i < this.m.size(); ++i) {
                    ((bdi)this.m.get(i)).a(worldScale);
                }
            }
            GL11.glTranslatef((float)(-this.c * worldScale), (float)(-this.d * worldScale), (float)(-this.e * worldScale));
        } else {
            this.callDisplayList();
            if (this.m != null) {
                for (int i = 0; i < this.m.size(); ++i) {
                    ((bdi)this.m.get(i)).a(worldScale);
                }
            }
        }
    }

    public void b(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.j) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.c * f), (float)(this.d * f), (float)(this.e * f));
        if (this.g != 0.0f) {
            GL11.glRotatef((float)(this.g * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.f != 0.0f) {
            GL11.glRotatef((float)(this.f * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.h != 0.0f) {
            GL11.glRotatef((float)(this.h * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.callDisplayList();
        GL11.glPopMatrix();
    }

    public void c(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.j) {
            return;
        }
        if (!this.compiled || this.forcedRecompile) {
            this.compileDisplayList(f);
        }
        if (this.f != 0.0f || this.g != 0.0f || this.h != 0.0f) {
            GL11.glTranslatef((float)(this.c * f), (float)(this.d * f), (float)(this.e * f));
            if (this.h != 0.0f) {
                GL11.glRotatef((float)(this.h * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.g != 0.0f) {
                GL11.glRotatef((float)(this.g * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.f != 0.0f) {
                GL11.glRotatef((float)(this.f * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.c != 0.0f || this.d != 0.0f || this.e != 0.0f) {
            GL11.glTranslatef((float)(this.c * f), (float)(this.d * f), (float)(this.e * f));
        }
    }

    private void callDisplayList() {
        if (this.useLegacyCompiler) {
            GL11.glCallList((int)this.displayList);
        } else {
            bge renderEngine = bgy.a.e;
            Collection textures = this.textureGroup.values();
            Iterator itr = textures.iterator();
            int i = 0;
            while (itr.hasNext()) {
                TextureGrp curTexGroup = (TextureGrp)itr.next();
                curTexGroup.loadTexture();
                GL11.glCallList((int)this.displayListArray[i]);
                if (!this.defaultTexture.equals("")) {
                    renderEngine.b(this.defaultTexture);
                }
                ++i;
            }
        }
    }

    private void bindTexture(int par1) {
        if (par1 != this.boundTexture) {
            GL11.glBindTexture((int)3553, (int)par1);
            this.boundTexture = par1;
        }
    }

    private void compileDisplayList(float worldScale) {
        if (this.useLegacyCompiler) {
            this.compileLegacyDisplayList(worldScale);
        } else {
            Collection textures = this.textureGroup.values();
            Iterator itr = textures.iterator();
            this.displayListArray = new int[this.textureGroup.size()];
            int i = 0;
            while (itr.hasNext()) {
                this.displayListArray[i] = avc.a((int)1);
                GL11.glNewList((int)this.displayListArray[i], (int)4864);
                bgd tessellator = bgd.a;
                TextureGrp usedGroup = (TextureGrp)itr.next();
                for (int j = 0; j < usedGroup.poly.size(); ++j) {
                    ((bcg)usedGroup.poly.get(j)).a(tessellator, worldScale);
                }
                GL11.glEndList();
                ++i;
            }
        }
        this.compiled = true;
    }

    private void compileLegacyDisplayList(float worldScale) {
        this.displayList = avc.a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        bgd tessellator = bgd.a;
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i].a(tessellator, worldScale);
        }
        GL11.glEndList();
    }
}

