/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import simcraft.core.GlobalConfig;
import simcraft.core.Property;
import simcraft.core.SimCraft;
import simcraft.core.sound.SndPositionPlayer;
import simcraft.core.sound.SoundPositionAudio;
import simcraft.core.sound.SoundSource;
import simcraft.core.sound.SoundSourceClient;
import simcraft.core.sound.SoundsManager;

@SideOnly(value=Side.CLIENT)
public final class SoundsManagerClient
extends SoundsManager {
    public float defaultVolume = 1.5f;
    public float fadingDistance = 16.0f;
    private boolean enabled = true;
    private int maxSourceCount = 32;
    private int streamingSourceCount = 4;
    private boolean lateInitDone = false;
    private SoundSystem soundSystem = null;
    private float masterVolume = 0.5f;
    private int ticker = 0;
    private int nextId = 0;
    private Map objectToSoundSourceMap = new HashMap();
    public GlobalConfig config;

    @Override
    public void initialize(GlobalConfig config2) {
        try {
            config2 = new GlobalConfig(new File(SimCraft.globalFunctions.getMinecraftDir(), "config/SimCraft/SimCraft.cfg"));
            config2.load();
        }
        catch (Exception exception) {
            System.out.println("[SimCraft Sound Manager] Error while trying to access configuration!");
            config2 = null;
        }
        if (config2 != null) {
            Property var1 = config2.getOrCreateBooleanProperty("soundsEnabled", 0, this.enabled);
            var1.comment = "Enable sounds";
            this.enabled = Boolean.parseBoolean(var1.value);
            var1 = config2.getOrCreateIntProperty("soundSourceLimit", 0, this.maxSourceCount);
            var1.comment = "Maximum number of audio sources, do not change";
            this.maxSourceCount = Integer.parseInt(var1.value);
            config2.save();
            this.enabled = this.maxSourceCount > 6;
        }
        if (this.maxSourceCount <= 6) {
            SimCraft.log.info("Audio source limit too low to enable SimCraft sounds.");
            this.enabled = false;
        }
        if (!this.enabled) {
            SimCraft.log.info("Sounds disabled.");
        } else if (this.maxSourceCount < 6) {
            this.enabled = false;
        } else {
            SoundSystemConfig.setNumberStreamingChannels((int)this.streamingSourceCount);
            SoundSystemConfig.setNumberNormalChannels((int)(this.maxSourceCount - this.streamingSourceCount));
        }
    }

    @Override
    public void onTick() {
        if (this.enabled && this.soundSystem != null) {
            float var0;
            SimCraft.globalFunctions.profilerStartSection("UpdateVolume");
            if (this.ticker++ % 8 == 0 && this.soundSystem != null && (var0 = ModLoader.getMinecraftInstance().z.b) != this.masterVolume) {
                float var1 = var0 / this.masterVolume;
                this.masterVolume = var0;
                for (List var3 : this.objectToSoundSourceMap.values()) {
                    for (SoundSourceClient var5 : var3) {
                        var5.setVolume(var5.getVolume() * var1);
                    }
                }
            }
            SimCraft.globalFunctions.profilerEndSection();
        }
    }

    @Override
    public SoundSource createSource(Object var0, String var1) {
        return this.createSource(var0, SndPositionPlayer.Center, var1, false, false, this.defaultVolume);
    }

    public SoundSource createSource(Object var0, SndPositionPlayer var1, String var2, boolean var3, boolean var4, float var5) {
        if (!this.enabled) {
            return null;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return null;
        }
        String var6 = this.getSourceName(this.nextId);
        ++this.nextId;
        SoundSourceClient var7 = new SoundSourceClient(this.soundSystem, var6, var0, var1, var2, var3, var4, var5);
        if (!this.objectToSoundSourceMap.containsKey(var0)) {
            this.objectToSoundSourceMap.put(var0, new LinkedList());
        }
        ((List)this.objectToSoundSourceMap.get(var0)).add(var7);
        return var7;
    }

    @Override
    public void removeSources(Object var0) {
        if (this.soundSystem != null && this.objectToSoundSourceMap.containsKey(var0)) {
            for (SoundSourceClient var2 : (List)this.objectToSoundSourceMap.get(var0)) {
                var2.remove();
            }
            this.objectToSoundSourceMap.remove(var0);
        }
    }

    @Override
    public void playOnce(Object var0, String var1) {
        this.playOnce(var0, SndPositionPlayer.Center, var1, false, this.defaultVolume);
    }

    public void playOnce(Object var0, SndPositionPlayer var1, String var2, boolean var3, float var4) {
        if (this.enabled) {
            if (this.soundSystem == null) {
                this.getSoundSystem();
            }
            if (this.soundSystem != null) {
                SoundPositionAudio var5 = SoundPositionAudio.getFrom(var0, var1);
                URL var6 = SoundSourceClient.class.getClassLoader().getResource("simcraft/sounds/" + var2);
                if (var6 == null) {
                    System.out.println("[SimCraft]  Invalid sound file: " + var2);
                } else {
                    String var7 = this.soundSystem.quickPlay(var3, var6, var2, false, var5.x, var5.y, var5.z, 2, this.fadingDistance * Math.max(var4, 1.0f));
                    this.soundSystem.setVolume(var7, this.masterVolume * Math.min(var4, 1.0f));
                }
            }
        }
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    private boolean testSourceCount(int var0) {
        IntBuffer var1 = BufferUtils.createIntBuffer((int)var0);
        try {
            AL10.alGenSources((IntBuffer)var1);
            if (AL10.alGetError() == 0) {
                AL10.alDeleteSources((IntBuffer)var1);
                return true;
            }
        }
        catch (Exception var3) {
            AL10.alGetError();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return false;
    }

    private void getSoundSystem() {
        for (Field var3 : bkc.class.getDeclaredFields()) {
            if (var3.getType() != SoundSystem.class) continue;
            var3.setAccessible(true);
            try {
                Object var4 = var3.get(null);
                if (!(var4 instanceof SoundSystem)) break;
                this.soundSystem = (SoundSystem)var4;
            }
            catch (Exception var5) {
                var5.printStackTrace();
                this.soundSystem = null;
            }
            break;
        }
    }

    private String getSourceName(int var0) {
        return "asm_snd" + var0;
    }
}

