/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector2MinecraftProxy;
import elliandetector.EllianDetectorConfiguration;
import elliandetector.EllianDetectorRenderer;
import elliandetector.EnumOption;
import elliandetector.EnumOptionValue;
import elliandetector.KeyInput;
import elliandetector.Material;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;

public class EllianDetector {
    private int scanSize = 8;
    private boolean detecting = true;
    public static Minecraft game = null;
    public static TreeMap<String, Integer> blockColors = new TreeMap();
    private static HashMap<String, Integer> $SWITCH_TABLE$EnumOption = null;
    private float direction = 0.0f;
    private boolean directionChanged = false;
    private boolean hidden = false;
    private boolean isFiltered = true;
    private boolean isVertical = false;
    private int lastX = 0;
    private int lastY = 0;
    private int lastZ = 0;
    private BufferedImage[] map = new BufferedImage[4];
    private String material = String.valueOf(EllianDetectorConfiguration.MAT_IRON);
    private HashMap<String, Material> materials = new HashMap();
    private float oldDir = 0.0f;
    private int zoom = 1;
    public static KeyInput KEY_MENU = new KeyInput("Menu Key", 47, 47);
    public static KeyInput KEY_ZOOM = new KeyInput("Zoom Key", 48, 48);
    public static KeyInput KEY_DIRECTION = new KeyInput("Direction Key", 35, 35);
    public static KeyInput KEY_MATERIAL = new KeyInput("Material Key", 49, 49);
    public static final KeyInput[] KEYS = new KeyInput[]{KEY_MENU, KEY_ZOOM, KEY_DIRECTION, KEY_MATERIAL};

    private static HashMap<String, Integer> $SWITCH_TABLE$EnumOption() {
        if ($SWITCH_TABLE$EnumOption == null) {
            $SWITCH_TABLE$EnumOption = new HashMap();
            $SWITCH_TABLE$EnumOption.put(EnumOption.BIGGER.getText(), 1);
            $SWITCH_TABLE$EnumOption.put(EnumOption.SCAN.getText(), 2);
            $SWITCH_TABLE$EnumOption.put(EnumOption.FILTERED.getText(), 3);
            $SWITCH_TABLE$EnumOption.put(EnumOption.HIDDEN.getText(), 4);
            $SWITCH_TABLE$EnumOption.put(EnumOption.POSITION.getText(), 5);
            $SWITCH_TABLE$EnumOption.put(EnumOption.VIEW.getText(), 6);
            $SWITCH_TABLE$EnumOption.put(EnumOption.DETECTING.getText(), 7);
        }
        return $SWITCH_TABLE$EnumOption;
    }

    public static int getBlockColor(int mat, int subType) {
        return EllianDetector.getBlockColor(String.valueOf(mat) + ":" + subType);
    }

    public static int getBlockColor(String blockID) {
        if (blockColors.containsKey(blockID)) {
            return blockColors.get(blockID);
        }
        if (blockID.indexOf(":") > 0) {
            blockID = blockID.substring(0, blockID.indexOf(":"));
        }
        if (blockColors.containsKey(blockID)) {
            return blockColors.get(blockID);
        }
        return EllianDetectorConfiguration.COLOR_TRANSPARENT;
    }

    public EllianDetector() {
        try {
            if (System.getenv().containsKey("ELLIAN_CONFIG")) {
                EllianDetectorConfiguration.CONFIG_FOLDER = System.getenv("ELLIAN_CONFIG");
            }
            this.buildMapImages(this.scanSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildMapImages(int size) {
        this.map[0] = new BufferedImage(size, size, 2);
        this.map[1] = new BufferedImage(size * 2, size * 2, 2);
        this.map[2] = new BufferedImage(size * 4, size * 4, 2);
        this.map[3] = new BufferedImage(size * 8, size * 8, 2);
    }

    public void changeMaterial() {
        Set<String> sets = this.materials.keySet();
        Iterator<String> iter = sets.iterator();
        block0: while (iter.hasNext()) {
            Material mat;
            String key;
            String curMatKey = iter.next();
            if (!curMatKey.equals(this.getCurrentMaterialId())) continue;
            boolean hasEnableNotFound = true;
            while (iter.hasNext()) {
                key = iter.next();
                mat = this.materials.get(key);
                if (!mat.isEnable()) continue;
                hasEnableNotFound = false;
                this.setMaterial(key);
                break;
            }
            if (!hasEnableNotFound) continue;
            iter = sets.iterator();
            while (iter.hasNext()) {
                key = iter.next();
                mat = this.materials.get(key);
                if (!mat.isEnable()) continue;
                this.setMaterial(key);
                continue block0;
            }
        }
    }

    public String getCurrentMaterialId() {
        return this.material;
    }

    public String getCurrentMaterialName() {
        Material material;
        if (this.materials == null) {
            this.materials = new HashMap();
            material = new Material("Diamond", true, EllianDetectorConfiguration.MAT_DIAMOND, 0);
            this.materials.put(String.valueOf(EllianDetectorConfiguration.MAT_DIAMOND), material);
            material = new Material("Iron", true, EllianDetectorConfiguration.MAT_IRON, 0);
            this.materials.put(String.valueOf(EllianDetectorConfiguration.MAT_IRON), material);
        }
        if (this.materials.containsKey(this.getCurrentMaterialId())) {
            if (this.materials.get(this.getCurrentMaterialId()) == null) {
                this.materials.remove(this.getCurrentMaterialId());
                this.setMaterial((String)this.materials.keySet().toArray()[0]);
            }
            return this.materials.get(this.getCurrentMaterialId()).getName();
        }
        if (this.materials.keySet().size() == 0) {
            material = new Material("Diamond", true, EllianDetectorConfiguration.MAT_DIAMOND, 0);
            this.materials.put(String.valueOf(EllianDetectorConfiguration.MAT_DIAMOND), material);
            material = new Material("Iron", true, EllianDetectorConfiguration.MAT_IRON, 0);
            this.materials.put(String.valueOf(EllianDetectorConfiguration.MAT_IRON), material);
        }
        this.material = this.materials.keySet().iterator().next();
        return this.materials.get(this.getCurrentMaterialId()).getName();
    }

    public float getDirection() {
        return this.direction;
    }

    public int getLastX() {
        return this.lastX;
    }

    public int getLastY() {
        return this.lastY;
    }

    public int getLastZ() {
        return this.lastZ;
    }

    public BufferedImage getMapImage(int zoom) {
        return this.map[zoom];
    }

    public ArrayList<Material> getMaterials() {
        return new ArrayList<Material>(this.materials.values());
    }

    public EnumOptionValue getOption(EnumOption enumoption) {
        switch (EllianDetector.$SWITCH_TABLE$EnumOption().get(enumoption.getText())) {
            case 1: {
                return EnumOptionValue.Bigger2Enum();
            }
            case 2: {
                return EnumOptionValue.ScanSize2Enum(this);
            }
            case 3: {
                return EnumOptionValue.bool(this.isFiltered);
            }
            case 4: {
                return EnumOptionValue.bool(this.isHidden());
            }
            case 5: {
                return EnumOptionValue.valueOf(EllianDetectorRenderer.getInstance().getPosition());
            }
            case 6: {
                if (this.isVertical) {
                    return EnumOptionValue.VERTICAL;
                }
                return EnumOptionValue.HORIZONTAL;
            }
            case 7: {
                return EnumOptionValue.bool(this.detecting);
            }
        }
        return null;
    }

    public int getScanSize() {
        return this.scanSize;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean hasPlayerMoved() {
        boolean hasMoved = false;
        if (this.lastX != EllianDetector2MinecraftProxy.xCoord() || this.lastY != EllianDetector2MinecraftProxy.yCoord() || this.lastZ != EllianDetector2MinecraftProxy.zCoord()) {
            this.lastX = EllianDetector2MinecraftProxy.xCoord();
            this.lastY = EllianDetector2MinecraftProxy.yCoord();
            this.lastZ = EllianDetector2MinecraftProxy.zCoord();
            hasMoved = true;
        }
        return hasMoved;
    }

    public boolean isDetecting() {
        return this.detecting;
    }

    public boolean isDirectionChanged() {
        return this.directionChanged;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isInMaterials(String id) {
        return this.materials.containsKey(id);
    }

    public boolean isSameHasCurrentMaterial(int blockId, int subBlockId) {
        boolean isSame = false;
        if (this.getCurrentMaterialId().indexOf(":") > 0) {
            if (this.getCurrentMaterialId().equals(String.valueOf(blockId) + ":" + subBlockId)) {
                isSame = true;
            }
        } else if (this.getCurrentMaterialId().equals("" + blockId)) {
            isSame = true;
        }
        return isSame;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void refreshDirection() {
        if (this.oldDir != EllianDetector2MinecraftProxy.radius()) {
            this.direction += this.oldDir - EllianDetector2MinecraftProxy.radius();
            this.oldDir = EllianDetector2MinecraftProxy.radius();
            if (this.direction >= 360.0f) {
                while (this.direction >= 360.0f) {
                    this.direction -= 360.0f;
                }
            }
            if (this.direction < 0.0f) {
                while (this.direction < 0.0f) {
                    this.direction += 360.0f;
                }
            }
            EllianDetectorRenderer.getInstance().setDirection(this.direction);
            this.directionChanged = true;
        }
    }

    public void saveKeys() {
        EllianDetectorConfiguration.writeCurrentConf(this);
    }

    public void saveMaterials(List<Material> mats) {
        this.materials.clear();
        boolean hasColorChanged = false;
        for (Material mat : mats) {
            this.materials.put(mat.getId(), mat);
            EllianDetectorConfiguration.writeMaterials(this);
            if (mat.getColor() == EllianDetector.getBlockColor(mat.getId())) continue;
            if (mat.getSubType() == 0) {
                blockColors.put(mat.getId(), new Integer(mat.getColor()));
            } else {
                blockColors.put(mat.getId(), new Integer(mat.getColor()));
            }
            hasColorChanged = true;
        }
        if (hasColorChanged) {
            EllianDetectorConfiguration.writeCurrentColors(this);
        }
    }

    public void saveOptions() {
        EllianDetectorConfiguration.writeCurrentConf(this);
    }

    public void setDetecting(boolean detecting) {
        this.detecting = detecting;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public void setFiltered(boolean isFiltered) {
        this.isFiltered = isFiltered;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public void setMaterials(HashMap<String, Material> materials) {
        this.materials = materials;
    }

    public void setOption(EnumOption option, EnumOptionValue value) {
        switch (EllianDetector.$SWITCH_TABLE$EnumOption().get(option.getText())) {
            case 1: {
                EllianDetectorRenderer.getInstance().setBigger(EnumOptionValue.Enum2Bigger(value));
                break;
            }
            case 2: {
                this.setScanSize(EnumOptionValue.Enum2ScanSize(value));
                break;
            }
            case 3: {
                this.setFiltered(EnumOptionValue.bool(value));
                break;
            }
            case 4: {
                this.setHidden(EnumOptionValue.bool(value));
                break;
            }
            case 5: {
                EllianDetectorRenderer.getInstance().updatePosition(value.text());
                break;
            }
            case 6: {
                if (value.equals(EnumOptionValue.VERTICAL)) {
                    this.isVertical = true;
                    break;
                }
                this.isVertical = false;
                break;
            }
            case 7: {
                this.setDetecting(EnumOptionValue.bool(value));
            }
        }
    }

    public void setScanSize(int size) {
        if (this.scanSize != size) {
            this.buildMapImages(size);
        }
        this.scanSize = size;
    }

    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public void setZoom(int zoom) {
        EllianDetectorRenderer.getInstance().setZoom(zoom);
        this.zoom = zoom;
    }
}

