/*
 * Decompiled with CFR 0.152.
 */
package mods.doca.core.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import mods.doca.core.DocaKeys;
import mods.doca.core.DocaTools;
import mods.doca.entity.DocaEntityBase;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;

public class DocaPacketControl {
    public static void setDocaToSendQueue(DocaEntityBase theBase, String type) {
        Side side;
        Packet packet = null;
        if (type.equalsIgnoreCase("doca_type_update")) {
            packet = DocaPacketControl.createKeyTypeDataPacket(theBase);
        } else if (type.equalsIgnoreCase("doca_item_update")) {
            packet = DocaPacketControl.createCurrentItemPacket(theBase);
        }
        if (packet != null && (side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71439_g.field_71174_a.func_147297_a(packet);
        }
    }

    public static void setKeyToSendQueue(DocaKeys key, String type) {
        Side side;
        Packet packet = null;
        if (type.equalsIgnoreCase("doca_keys_update")) {
            packet = DocaPacketControl.createKeyStatusPacket(key);
        }
        if (packet != null && (side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71439_g.field_71174_a.func_147297_a(packet);
        }
    }

    public static Packet createKeyTypeDataPacket(DocaEntityBase theBase) {
        ByteArrayOutputStream var1 = new ByteArrayOutputStream();
        DataOutputStream var2 = new DataOutputStream(var1);
        try {
            var2.writeInt(theBase.func_145782_y());
            var2.writeInt(theBase.getIndexTexture());
            var2.writeInt(theBase.getCollarColor());
            var2.writeInt(theBase.getMode());
            var2.writeInt(theBase.getModelSize());
            var2.writeUTF(theBase.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new C17PacketCustomPayload("doca_type_update", var1.toByteArray());
    }

    public static Packet createCurrentItemPacket(DocaEntityBase theBase) {
        ByteArrayOutputStream var1 = new ByteArrayOutputStream();
        DataOutputStream var2 = new DataOutputStream(var1);
        try {
            var2.writeInt(theBase.func_145782_y());
            var2.writeInt(DocaTools.newItemID(theBase.getCurrentItemData().func_77973_b()));
            var2.writeInt(theBase.getCurrentItemData().field_77994_a);
            var2.writeInt(theBase.getCurrentItemData().func_77960_j());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new C17PacketCustomPayload("doca_item_update", var1.toByteArray());
    }

    public static Packet createKeyStatusPacket(DocaKeys key) {
        ByteArrayOutputStream var1 = new ByteArrayOutputStream();
        DataOutputStream var2 = new DataOutputStream(var1);
        try {
            var2.writeUTF(key.getUserName());
            for (int i = 0; i < 9; ++i) {
                var2.writeBoolean(key.getKeys(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new C17PacketCustomPayload("doca_keys_update", var1.toByteArray());
    }
}

