/*
 * Decompiled with CFR 0.152.
 */
package mods.doca.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.doca.core.DocaReg;
import mods.doca.core.DocaSet;
import mods.doca.core.DocaTools;
import mods.doca.entity.DocaEntityCore;
import mods.doca.entity.ai.DocaEntityAIControlledByPlayer;
import mods.doca.entity.func.DocaFuncChsetSearch;
import mods.doca.entity.func.DocaFuncEmotion;
import mods.doca.entity.func.DocaFuncFoodsEeat;
import mods.doca.entity.func.DocaFuncParticle;
import mods.doca.entity.func.DocaFuncPickUp;
import mods.doca.entity.func.DocaFuncPopup;
import mods.doca.entity.func.DocaFuncRiddenByEntity;
import mods.doca.entity.func.DocaFuncShaking;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class DocaEntityBase
extends DocaEntityCore {
    private int baseHelthTimer;
    private int baseUpToFire = 0;
    public int sizeMaxTexture = DocaSet.texture_SizeMaxDefault;
    public String entityDocaString = "";
    public double moveSpeed;
    public String attackerMode = "";
    private int currentItemDataID = -1;
    public DocaFuncPopup funcPopup;
    public DocaFuncParticle funcParticle;
    public DocaFuncPickUp funcPickup;
    public DocaFuncEmotion funcEmotion;
    public DocaFuncShaking funcShaking;
    public DocaFuncChsetSearch funcChsetSearch;
    public DocaFuncFoodsEeat funcFoodsEeat;
    public DocaFuncRiddenByEntity funcRiddenByEntity;
    public final DocaEntityAIControlledByPlayer aiControlledByPlayer;

    public DocaEntityBase(World par1World) {
        super(par1World);
        this.baseHelthTimer = DocaSet.maxHelthTimer;
        this.funcPopup = new DocaFuncPopup();
        this.funcParticle = new DocaFuncParticle();
        this.funcPickup = new DocaFuncPickUp();
        this.funcEmotion = new DocaFuncEmotion();
        this.funcShaking = new DocaFuncShaking();
        this.funcChsetSearch = new DocaFuncChsetSearch();
        this.funcFoodsEeat = new DocaFuncFoodsEeat();
        this.funcRiddenByEntity = new DocaFuncRiddenByEntity();
        this.aiControlledByPlayer = new DocaEntityAIControlledByPlayer(this, 0.6f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.entityDocaString = "";
        this.sizeMaxTexture = DocaSet.texture_SizeMaxDefault;
        this.attackerMode = "";
        this.baseHelthTimer = DocaSet.maxHelthTimer;
        this.baseUpToFire = 0;
        this.currentItemDataID = -1;
        this.theInventoryFull = false;
        this.funcPopup = new DocaFuncPopup();
        this.funcParticle = new DocaFuncParticle();
        this.funcPickup = new DocaFuncPickUp();
        this.funcEmotion = new DocaFuncEmotion();
        this.funcShaking = new DocaFuncShaking();
        this.funcChsetSearch = new DocaFuncChsetSearch();
        this.funcFoodsEeat = new DocaFuncFoodsEeat();
        this.funcRiddenByEntity = new DocaFuncRiddenByEntity();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.setMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getDocaMobMaxHealth());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getShaking() {
        return this.funcShaking.getShaking();
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileShaking(float par1) {
        return this.funcShaking.getShadingWhileShaking(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float par1, float par2) {
        return this.funcShaking.getShakeAngle(par1, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float par1) {
        return this.funcShaking.getInterestedAngle(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLifeColor() {
        float tmplife;
        double mid;
        double low = (double)this.func_110138_aP() / 4.0;
        double high = low + (mid = (double)this.func_110138_aP() / 2.0);
        if (high <= (double)(tmplife = this.getLife())) {
            return 65280;
        }
        if (mid <= (double)tmplife) {
            return 0xFF9900;
        }
        if (low <= (double)tmplife) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    @SideOnly(value=Side.CLIENT)
    public int isEmotion() {
        return this.funcEmotion.isEmotionLiving();
    }

    @SideOnly(value=Side.CLIENT)
    public double getLabelHeight() {
        return 0.0 - (double)(this.getHeightType() * 10);
    }

    @SideOnly(value=Side.CLIENT)
    public String getRenderStatusText() {
        if (this.isSleeping()) {
            return "(Sl)";
        }
        if (this.isWaiting()) {
            return "(Wt)";
        }
        if (this.isDowning()) {
            return "<Dw>";
        }
        if (this.func_70906_o()) {
            return "(St)";
        }
        if (this.isDistance()) {
            return "<Ds>";
        }
        if (this.isComeing()) {
            return "<Cm>";
        }
        switch (this.getMode()) {
            case 1: {
                return "[Fr]";
            }
            case 2: {
                return "[Wa]";
            }
            case 3: {
                return "[Wd]";
            }
        }
        return "[Nm]";
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderStatus() {
        if (this.isSleeping()) {
            return 4;
        }
        if (this.isWaiting()) {
            return 5;
        }
        if (this.isDowning()) {
            return 2;
        }
        if (this.func_70906_o()) {
            return 3;
        }
        if (this.isDistance()) {
            return 1;
        }
        if (this.isComeing()) {
            return 0;
        }
        switch (this.getMode()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 8;
            }
        }
        return 9;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public double getDocaMobMaxHealth() {
        return this.func_70909_n() ? 20.0 : 8.0;
    }

    public String getEntityDocaString() {
        return this.entityDocaString;
    }

    public int getHeightType() {
        if (this.func_70631_g_()) {
            return DocaReg.getDocaLabelSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Small"));
        }
        if (this.getModelSize() == DocaReg.getSizeNameToNo("Small")) {
            return DocaReg.getDocaLabelSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Small"));
        }
        if (this.getModelSize() == DocaReg.getSizeNameToNo("Big")) {
            return DocaReg.getDocaLabelSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Big"));
        }
        return DocaReg.getDocaLabelSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Normal"));
    }

    public float getHeightModelSizeDefault() {
        return DocaReg.getDocaHeightSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Normal"));
    }

    public float getHeightModelSize() {
        float tmpFloat = this.getHeightModelSizeDefault();
        if (this.func_70631_g_() || this.getModelSize() == DocaReg.getSizeNameToNo("Small")) {
            tmpFloat = DocaReg.getDocaHeightSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Small"));
        } else if (this.getModelSize() == DocaReg.getSizeNameToNo("Big")) {
            tmpFloat = DocaReg.getDocaHeightSize(DocaReg.getNameToType(this.entityDocaString), DocaReg.getSizeNameToNo("Big"));
        }
        return tmpFloat;
    }

    public float getWidthModelSize() {
        return DocaReg.getDocaWidth(DocaReg.getNameToType(this.entityDocaString));
    }

    public float func_70603_bj() {
        float tmpSize = 1.0f;
        if (this.getModelSize() == DocaReg.getSizeNameToNo("Small")) {
            tmpSize = 0.5f;
        } else if (this.getModelSize() == DocaReg.getSizeNameToNo("Big")) {
            tmpSize = 1.4f;
        }
        if (this.func_70631_g_()) {
            tmpSize = 1.0f;
        }
        return tmpSize;
    }

    public double setMoveSpeed() {
        return DocaReg.getDocaSpeed(DocaReg.getNameToType(this.entityDocaString));
    }

    public void func_70903_f(boolean par1) {
        super.func_70903_f(par1);
        if (par1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getDocaMobMaxHealth());
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public void setUpToFire(int par1) {
        this.baseUpToFire = par1;
    }

    public boolean getUpToFire() {
        return this.baseUpToFire == 1;
    }

    public void countUpToFire() {
        if (1 < this.baseUpToFire) {
            --this.baseUpToFire;
        }
    }

    public int getMinMoveSize() {
        if (10 < DocaSet.func_MoveSquareToHomePoint) {
            return 6;
        }
        if (5 < DocaSet.func_MoveSquareToHomePoint) {
            return 4;
        }
        return 2;
    }

    public double getMoveSpeed() {
        return DocaSet.func_Speed ? 1.2 : 1.0;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)-1);
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isFeedItem(ItemStack par1ItemStack) {
        boolean tmpRetrun = false;
        if (par1ItemStack != null && (DocaTools.ofItem(par1ItemStack, (Object)DocaReg.getFeedItem(DocaReg.getNameToType(this.entityDocaString), 0)) || DocaTools.ofItem(par1ItemStack, (Object)DocaReg.getFeedItem(DocaReg.getNameToType(this.entityDocaString), 1)) || DocaTools.ofItem(par1ItemStack, (Object)DocaReg.getFeedItem(DocaReg.getNameToType(this.entityDocaString), 2)) || DocaTools.ofItem(par1ItemStack, (Object)DocaReg.getFeedItem(DocaReg.getNameToType(this.entityDocaString), 3)))) {
            tmpRetrun = true;
        }
        return tmpRetrun;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        DocaSet.copyToInventoryCheck = true;
        DocaSet.copyToInventoryCount = 50;
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K) {
            this.inventory.dropAllItems();
        }
    }

    public void func_70629_bd() {
        this.updateHelth();
        if (this.func_70605_aq().func_75640_a()) {
            double var1 = this.func_70605_aq().func_75638_b();
            if (var1 < this.getMoveSpeed() * 1.0) {
                this.func_70095_a(false);
                this.func_70031_b(true);
            } else {
                this.func_70095_a(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_70095_a(false);
            this.func_70031_b(false);
        }
        super.func_70629_bd();
    }

    public void func_70636_d() {
        this.funcShaking.onLivingUpdate(this);
        if (this.field_70153_n != null && (this.getLife() <= 1.0f || DocaTools.geKeyPlessUpdateDoca(this, 5))) {
            this.field_70153_n.func_70078_a((Entity)null);
        }
        super.func_70636_d();
        this.statusUpdate();
        if (this.field_70703_bu) {
            if (this.func_70090_H()) {
                this.field_70181_x += 0.06;
            }
            if (this.func_70058_J()) {
                this.field_70181_x += 0.1;
            }
        }
        this.updateHealth();
        this.funcFoodsEeat.onLivingUpdate(this);
        this.funcChsetSearch.onLivingUpdate(this);
        if (this.funcPopup.onLivingUpdate(this)) {
            this.funcEmotion.setEmotionLiving(this, 3);
        }
        this.funcParticle.onLivingUpdate(this);
        this.funcPickup.onLivingUpdate(this);
        this.funcEmotion.onLivingUpdate(this);
        this.funcRiddenByEntity.onLivingUpdate(this);
        this.updateGrowAge();
        this.setSizeDoca(this.getWidthModelSize(), this.getHeightModelSize());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.countUpToFire();
        this.funcShaking.onUpdate(this);
    }

    public void func_70624_b(EntityLivingBase par1EntityLivingBase) {
        if (!this.isAttackTargetCheck(par1EntityLivingBase)) {
            par1EntityLivingBase = null;
        }
        super.func_70624_b(par1EntityLivingBase);
    }

    public boolean isAttackTargetCheck(EntityLivingBase par1EntityLivingBase) {
        if (DocaSet.attack_PeacefulON) {
            return false;
        }
        if (par1EntityLivingBase instanceof EntityPlayer) {
            return false;
        }
        if (this.isDowning() || this.isComeing() || this.isDistance() || this.isSleeping() || this.isWaiting()) {
            return false;
        }
        if (par1EntityLivingBase instanceof EntityTameable) {
            if (DocaSet.attack_TameableON) {
                return false;
            }
            if (((EntityTameable)par1EntityLivingBase).func_70909_n()) {
                return false;
            }
        }
        if (this.getLife() <= 1.0f) {
            return false;
        }
        if (DocaSet.attack_FriendlyEntityDoca.length != 0 && par1EntityLivingBase instanceof EntityLivingBase) {
            String tmpAttacker = EntityList.func_75621_b((Entity)par1EntityLivingBase);
            for (int i = 0; i < DocaSet.attack_FriendlyEntityDoca.length; ++i) {
                if (!tmpAttacker.equalsIgnoreCase(DocaSet.attack_FriendlyEntityDoca[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity var3 = par1DamageSource.func_76346_g();
        this.field_70911_d.func_75270_a(false);
        this.setDowning(false);
        if (var3 != null && !(var3 instanceof EntityPlayer) && !(var3 instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        if (this.getMode() != 0 && this.getLife() <= par2) {
            float tmpDamage = this.getLife() - 1.0f;
            if (1.0f <= tmpDamage) {
                par2 = tmpDamage;
            } else {
                par2 = 0.0f;
                return false;
            }
        }
        if (DocaSet.attack_PetInvincibleOFF) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        if (this.getMode() != 0) {
            if (par1DamageSource.field_76373_n.equals("inFire") || par1DamageSource.field_76373_n.equals("onFire")) {
                this.setUpToFire(20);
            }
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public boolean func_70652_k(Entity par1Entity) {
        int var2 = DocaSet.attack_PetInvincibleOFF ? 2 : 4;
        int var3 = 0;
        if (DocaSet.attack_AdditionalEffectON) {
            if (par1Entity instanceof EntityLiving) {
                var3 = this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL ? 7 : (this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 15 : 5);
            }
            switch (this.getMode()) {
                case 1: {
                    ((EntityLivingBase)par1Entity).func_70015_d(var3);
                    break;
                }
                case 2: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, var3 * 20, 0));
                    break;
                }
                case 3: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, var3 * 20, 0));
                    break;
                }
            }
        }
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)var2);
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack itemStack = par1EntityPlayer.field_71071_by.func_70448_g();
        if (this.func_70909_n()) {
            if (itemStack != null) {
                if (DocaTools.newItem(itemStack) instanceof ItemFood) {
                    ItemFood var3 = (ItemFood)DocaTools.newItem(itemStack);
                    if (this.isFeedItem(itemStack) && this.getLife() < 20.0f) {
                        if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                            --itemStack.field_77994_a;
                        }
                        this.func_70691_i(var3.func_150905_g(itemStack));
                        this.baseHelthTimer = DocaSet.maxHelthTimer;
                        if (itemStack.field_77994_a <= 0) {
                            par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                        }
                        this.setParticle("heart");
                        this.funcEmotion.setEmotionLiving(this, 4);
                    } else {
                        this.setParticle("smoke");
                    }
                    return true;
                }
                if (DocaTools.ofItem(itemStack, (Object)Items.field_151111_aL)) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70784_b(null);
                    this.func_70624_b(null);
                    this.func_70910_a(par1EntityPlayer.func_70005_c_());
                    this.field_70911_d.func_75270_a(false);
                    this.setParticle("heart");
                    return true;
                }
                if (par1EntityPlayer.func_70005_c_().equalsIgnoreCase(this.func_70905_p()) || DocaSet.Debug) {
                    if (DocaTools.ofItem(itemStack, (Object)Items.field_151097_aZ)) {
                        this.setName("");
                        this.setMode(0);
                        this.setWaiting(false);
                        this.setHomePos(0, 0);
                        this.setHomePos(1, 0);
                        this.setHomePos(2, 0);
                        this.setHealing(false);
                        this.setDowning(false);
                        this.setSleeping(false);
                        this.setComeing(false);
                        this.setDistance(false);
                        this.field_70911_d.func_75270_a(false);
                        this.func_70904_g(false);
                        DocaSet.copyToInventoryCheck = true;
                        DocaSet.copyToInventoryCount = 50;
                        if (!this.field_70170_p.field_72995_K) {
                            this.inventory.dropAllItems();
                        }
                        this.func_70910_a("");
                        this.func_70903_f(false);
                        return true;
                    }
                    if (DocaTools.ofItem(itemStack, (Object)Items.field_151146_bM)) {
                        this.funcRiddenByEntity.interact(par1EntityPlayer, this, Items.field_151146_bM);
                    } else {
                        if (DocaTools.ofItem(itemStack, (Object)Items.field_151055_y)) {
                            if (this.getMode() != 0) {
                                DocaTools.openEntityGuiDoca(DocaSet.containerContainerID, this.field_70170_p, this.func_145782_y(), par1EntityPlayer);
                            }
                            return true;
                        }
                        if (DocaTools.ofItem(itemStack, (Object)Items.field_151008_G)) {
                            DocaTools.openEntityGuiDoca(DocaSet.containerSettingID, this.field_70170_p, this.func_145782_y(), par1EntityPlayer);
                            return true;
                        }
                        if (DocaTools.ofItem(itemStack, (Object)Items.field_151155_ap)) {
                            if (!this.isWaiting()) {
                                this.setWaiting(true);
                                this.setHomePos(0, (int)this.field_70165_t);
                                this.setHomePos(1, (int)this.field_70163_u);
                                this.setHomePos(2, (int)this.field_70161_v);
                                this.setDowning(false);
                                this.setComeing(false);
                                this.setDistance(false);
                                if (!this.field_70170_p.field_72995_K) {
                                    DocaTools.setChatMassageDoca(StatCollector.func_74838_a((String)"doca.chat.message.WaitModeON"));
                                }
                            } else {
                                this.setWaiting(false);
                                this.setHomePos(0, (int)this.field_70165_t);
                                this.setHomePos(1, (int)this.field_70163_u);
                                this.setHomePos(2, (int)this.field_70161_v);
                                if (!this.field_70170_p.field_72995_K) {
                                    DocaTools.setChatMassageDoca(StatCollector.func_74838_a((String)"doca.chat.message.WaitModeOFF"));
                                }
                            }
                            return true;
                        }
                        if (DocaTools.ofItem(itemStack, (Object)Items.field_151103_aS)) {
                            if (this.func_70906_o()) {
                                this.field_70911_d.func_75270_a(false);
                                this.func_70904_g(false);
                                this.setDowning(false);
                                this.setComeing(false);
                                this.setDistance(false);
                            } else {
                                this.field_70911_d.func_75270_a(true);
                                this.func_70904_g(true);
                            }
                            return true;
                        }
                    }
                }
            } else if (par1EntityPlayer.func_70005_c_().equalsIgnoreCase(this.func_70905_p())) {
                if (DocaTools.geKeyPlessUpdateDoca(this, 6)) {
                    if (this.getMode() != 0) {
                        DocaTools.openEntityGuiDoca(DocaSet.containerContainerID, this.field_70170_p, this.func_145782_y(), par1EntityPlayer);
                    }
                    return true;
                }
                if (DocaTools.geKeyPlessUpdateDoca(this, 7)) {
                    DocaTools.openEntityGuiDoca(DocaSet.containerSettingID, this.field_70170_p, this.func_145782_y(), par1EntityPlayer);
                    return true;
                }
                if (DocaTools.geKeyPlessUpdateDoca(this, 8)) {
                    if (!this.isWaiting()) {
                        this.setWaiting(true);
                        this.setHomePos(0, (int)this.field_70165_t);
                        this.setHomePos(1, (int)this.field_70163_u);
                        this.setHomePos(2, (int)this.field_70161_v);
                        this.setDowning(false);
                        this.setComeing(false);
                        this.setDistance(false);
                        if (!this.field_70170_p.field_72995_K) {
                            DocaTools.setChatMassageDoca(StatCollector.func_74838_a((String)"doca.chat.message.WaitModeON"));
                        }
                    } else {
                        this.setWaiting(false);
                        this.setHomePos(0, (int)this.field_70165_t);
                        this.setHomePos(1, (int)this.field_70163_u);
                        this.setHomePos(2, (int)this.field_70161_v);
                        if (!this.field_70170_p.field_72995_K) {
                            DocaTools.setChatMassageDoca(StatCollector.func_74838_a((String)"doca.chat.message.WaitModeOFF"));
                        }
                    }
                    return true;
                }
                if (DocaTools.geKeyPlessUpdateDoca(this, 5)) {
                    if (this.func_70906_o()) {
                        this.field_70911_d.func_75270_a(false);
                        this.func_70904_g(false);
                        this.setDowning(false);
                        this.setComeing(false);
                        this.setDistance(false);
                    } else {
                        this.field_70911_d.func_75270_a(true);
                        this.func_70904_g(true);
                    }
                    return true;
                }
            }
        } else if (DocaTools.ofItem(itemStack, (Object)Items.field_151111_aL)) {
            this.func_70903_f(true);
            this.func_70778_a(null);
            this.func_70784_b(null);
            this.func_70624_b(null);
            this.func_70910_a(par1EntityPlayer.func_70005_c_());
            this.field_70911_d.func_75270_a(false);
            this.setParticle("heart");
            return true;
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    public EntityAgeable spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        DocaEntityBase var2 = new DocaEntityBase(this.field_70170_p);
        if (this.func_70909_n()) {
            var2.func_70910_a(this.func_70905_p());
            var2.func_70903_f(true);
        }
        return var2;
    }

    public void func_70103_a(byte par1) {
        if (par1 == 8) {
            this.funcShaking.handleHealthUpdate(this);
        } else {
            super.func_70103_a(par1);
        }
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof DocaEntityBase)) {
            return false;
        }
        DocaEntityBase var2 = (DocaEntityBase)par1EntityAnimal;
        return !var2.func_70909_n() ? false : (var2.func_70906_o() ? false : this.func_70880_s() && var2.func_70880_s());
    }

    public void setParticle(String par1) {
        if (par1 == "heart" || par1 == "smoke" || par1 == "splash" || par1 == "cloud" || par1 == "flame" || par1 == "portal" || par1 == "snowshovel" || par1 == "slime" || par1 == "enchantmenttable") {
            for (int var2 = 0; var2 < 7; ++var2) {
                double var3 = this.field_70146_Z.nextGaussian() * 0.02;
                double var5 = this.field_70146_Z.nextGaussian() * 0.02;
                double var7 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a(par1, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, var3, var5, var7);
            }
        }
    }

    public void statusUpdate() {
        if (this.func_70909_n()) {
            if (this.isHealing() || this.isSleeping() || this.isWaiting() || this.isRiden()) {
                this.setComeing(false);
                this.setDowning(false);
                this.setDistance(false);
            } else {
                if (DocaTools.geKeyPlessUpdateDoca(this, 1)) {
                    this.setComeing(true);
                    this.setDowning(false);
                    this.setDistance(false);
                    this.field_70911_d.func_75270_a(false);
                    this.func_70904_g(false);
                }
                if (DocaTools.geKeyPlessUpdateDoca(this, 2)) {
                    this.setComeing(false);
                    this.setDowning(true);
                    this.setDistance(false);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70904_g(true);
                }
                if (DocaTools.geKeyPlessUpdateDoca(this, 3)) {
                    this.setComeing(false);
                    this.setDowning(false);
                    this.setDistance(true);
                    this.field_70911_d.func_75270_a(false);
                    this.func_70904_g(false);
                }
                if (DocaTools.geKeyPlessUpdateDoca(this, 0)) {
                    this.setComeing(false);
                    this.setDowning(false);
                    this.setDistance(false);
                    if (!(this.isHealing() || this.isSleeping() || this.isWaiting())) {
                        this.field_70911_d.func_75270_a(false);
                        this.func_70904_g(false);
                    }
                }
            }
        }
    }

    public void updateHealth() {
        if (this.isWaiting() && DocaSet.func_HealingBed) {
            if (this.getLife() < this.func_110138_aP() / 2.0f) {
                this.setHealing(true);
            }
            if (this.getLife() == this.func_110138_aP()) {
                this.setHealing(false);
            }
        } else {
            this.setHealing(false);
        }
        if (this.getMode() != DocaReg.getModeNameToNo("Normal")) {
            if (this.baseHelthTimer <= 0) {
                this.baseHelthTimer = DocaSet.maxHelthTimer;
                if (1.0f < this.getLife()) {
                    this.func_70606_j(this.getLife() - 1.0f);
                }
            } else if (!(this.func_70906_o() || this.isHealing() || this.isWaiting())) {
                --this.baseHelthTimer;
            }
        }
        if (this.getLife() < this.func_110138_aP() / 2.0f && this.field_70146_Z.nextInt(1000) == 0) {
            this.funcEmotion.setEmotionLiving(this, 2);
        }
    }

    public void updateGrowAge() {
        if (DocaReg.getGrowAge(DocaReg.getNameToType(this.entityDocaString)) && this.func_70909_n()) {
            this.func_70873_a(-24000);
        }
        if (DocaSet.Debug) {
            this.func_70873_a(1);
        }
    }

    public void func_98054_a(boolean par1) {
        super.func_98054_a(false);
    }

    public void setSizeDoca(float par1, float par2) {
        if (par1 != this.field_70130_N || par2 != this.field_70131_O) {
            this.field_70130_N = par1;
            this.field_70131_O = par2;
            this.field_70121_D.field_72336_d = this.field_70121_D.field_72340_a + (double)this.field_70130_N;
            this.field_70121_D.field_72334_f = this.field_70121_D.field_72339_c + (double)this.field_70130_N;
            this.field_70121_D.field_72337_e = this.field_70121_D.field_72338_b + (double)this.field_70131_O;
        }
    }

    public boolean func_70686_a(Class par1Class) {
        return EntityBat.class != par1Class && EntityGhast.class != par1Class && EntityBlaze.class != par1Class && EntityDragon.class != par1Class && EntityWither.class != par1Class;
    }

    public DocaEntityAIControlledByPlayer getAIControlledByPlayer() {
        return this.aiControlledByPlayer;
    }

    public boolean func_82171_bF() {
        return this.funcRiddenByEntity.canBeSteered(((EntityPlayer)this.field_70153_n).func_70694_bm(), Items.field_151146_bM);
    }
}

