/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api;

import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.common.configuration.BOPConfigurationBiomeWeights;
import biomesoplenty.common.configuration.BOPConfigurationIDs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;

public class BOPBiomeManager {
    private static int nextBiomeId = 40;
    public static List<BiomeEntry>[] overworldBiomes = new ArrayList[4];
    public static List<BiomeEntry>[] overworldSubBiomes = new ArrayList[BiomeGenBase.func_150565_n().length];
    public static List<Integer> overworldOceanBiomes = new ArrayList<Integer>();
    public static BiomeGenBase[] overworldRiverBiomes = new BiomeGenBase[BiomeGenBase.func_150565_n().length];
    public static List<BiomeEntry> netherBiomes = new ArrayList<BiomeEntry>();

    public static BiomeGenBase createAndRegisterBiome(Class<? extends BiomeGenBase> biomeClass, String biomeType, String biomeName, List<BiomeEntry> biomeList, int weight) {
        BiomeGenBase biome = BOPBiomeManager.createBiome(biomeClass, biomeName);
        if (biome != null) {
            BiomeEntry entry = new BiomeEntry(biome, BOPBiomeManager.getConfiguredWeight(biome, biomeType, weight));
            if (BOPConfigurationBiomeGen.config.get(biomeType + " Biomes To Generate", biome.field_76791_y, true).getBoolean(false) && biomeList != null) {
                biomeList.add(entry);
            }
            return biome;
        }
        return null;
    }

    public static BiomeGenBase createBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName) {
        int biomeId = BOPConfigurationIDs.config.get("Biome IDs", biomeName + " ID", BOPBiomeManager.getNextFreeBiomeId()).getInt();
        if (biomeId != -1) {
            try {
                BiomeGenBase biome = biomeClass.getConstructor(Integer.TYPE).newInstance(biomeId).func_76735_a(biomeName);
                return biome;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getNextFreeBiomeId() {
        for (int i = nextBiomeId; i < 256; ++i) {
            if (BiomeGenBase.func_150565_n()[i] != null) {
                if (i != 255) continue;
                throw new IllegalArgumentException("There are no more biome ids avaliable!");
            }
            nextBiomeId = i + 1;
            return i;
        }
        return -1;
    }

    public static boolean isBiomeOceanic(int biomeId) {
        return overworldOceanBiomes.contains(biomeId);
    }

    private static int getConfiguredWeight(BiomeGenBase biome, String biomeType, int weight) {
        return BOPConfigurationBiomeWeights.config.get(biomeType + " Biome Weights", biome.field_76791_y, weight).getInt(weight);
    }

    public static class BiomeEntry
    extends WeightedRandom.Item {
        public BiomeGenBase biome;

        public BiomeEntry(BiomeGenBase biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public class TemperatureType {
        public static final int HOT = 0;
        public static final int WARM = 1;
        public static final int COOL = 2;
        public static final int ICY = 3;
    }
}

