/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biomes.overworld;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.biomes.BOPBiome;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPTallGrass;
import biomesoplenty.common.world.features.WorldGenMoss;
import biomesoplenty.common.world.features.trees.WorldGenBOPTaiga3;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;

public class BiomeGenFungiForest
extends BOPBiome {
    private static final BiomeGenBase.Height biomeHeight = new BiomeGenBase.Height(0.2f, 0.5f);

    public BiomeGenFungiForest(int biomeID) {
        super(biomeID);
        this.func_150570_a(biomeHeight);
        this.func_76739_b(15792496);
        this.func_76732_a(0.9f, 1.0f);
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityMooshroom.class, 3, 4, 8));
        this.field_76759_H = 65326;
        this.field_76760_I.field_76832_z = 8;
        this.field_76760_I.field_76798_D = 8;
        this.field_76760_I.field_76807_J = 8;
        this.bopWorldFeatures.setFeature("sproutsPerChunk", 2);
        this.bopWorldFeatures.setFeature("bushesPerChunk", 1);
        this.bopWorldFeatures.setFeature("toadstoolsPerChunk", 5);
        this.bopWorldFeatures.setFeature("portobellosPerChunk", 7);
        this.bopWorldFeatures.setFeature("blueMilksPerChunk", 2);
        this.bopWorldFeatures.setFeature("glowshroomsPerChunk", 1);
        this.bopWorldFeatures.setFeature("riverCanePerChunk", 1);
        this.bopWorldFeatures.setFeature("shrubsPerChunk", 1);
        this.bopWorldFeatures.setFeature("cloverPatchesPerChunk", 20);
        this.bopWorldFeatures.setFeature("generateMycelium", true);
        this.bopWorldFeatures.setFeature("bopGrassPerChunk", 12);
        this.bopWorldFeatures.setFeature("bopFlowersPerChunk", 3);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 4), 8);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass((Block)Blocks.field_150329_H, 1), 1.0);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass((Block)Blocks.field_150329_H, 2), 2.0);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 1), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 2), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 10), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPDoubleFlora(2), 0.25);
    }

    @Override
    public void func_76728_a(World world, Random random, int chunkX, int chunkZ) {
        int z;
        int y;
        int x;
        int i;
        super.func_76728_a(world, random, chunkX, chunkZ);
        int var5 = 12 + random.nextInt(6);
        for (i = 0; i < var5; ++i) {
            x = chunkX + random.nextInt(16);
            Block block = world.func_147439_a(x, y = random.nextInt(28) + 4, z = chunkZ + random.nextInt(16));
            if (block == null || !block.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) continue;
            world.func_147465_d(x, y, z, BOPBlockHelper.get("gemOre"), 14, 2);
        }
        for (i = 0; i < 20; ++i) {
            x = chunkX + random.nextInt(16) + 8;
            y = 58;
            z = chunkZ + random.nextInt(16) + 8;
            new WorldGenMoss().func_76484_a(world, random, x, y, z);
        }
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        return random.nextInt(3) == 0 ? new WorldGenBOPTaiga3(Blocks.field_150364_r, BOPBlockHelper.get("leaves2"), 0, 3, false, 25, 10, 1) : (random.nextInt(5) == 0 ? new WorldGenBOPTaiga3(Blocks.field_150364_r, BOPBlockHelper.get("leaves1"), 0, 0, false, 15, 15, 2) : (random.nextInt(2) == 0 ? new WorldGenShrub(0, 0) : new WorldGenBOPTaiga3(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, false, 35, 10, 0)));
    }

    public int func_150558_b(int x, int y, int z) {
        return 15792496;
    }

    public int func_150571_c(int x, int y, int z) {
        return 11139946;
    }

    public int func_76731_a(float par1) {
        if (BOPConfigurationMisc.skyColors) {
            return 11513806;
        }
        return super.func_76731_a(par1);
    }
}

