/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.api.BOPItemHelper;
import biomesoplenty.client.render.RenderUtils;
import biomesoplenty.common.blocks.templates.BOPBlockWorldDecor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockBOPPlant
extends BOPBlockWorldDecor
implements IShearable {
    private static final String[] plants = new String[]{"deadgrass", "desertgrass", "desertsprouts", "dunegrass", "spectralfern", "thorn", "barley", "cattail", "rivercane", "cattailtop", "cattailbottom", "wildcarrot", "cactus", "witherwart", "reed", "root"};
    private IIcon[] textures;
    public IIcon reedbottom;
    private static final int CATTAILTOP = 9;
    private static final int CATTAILBOTTOM = 10;

    public BlockBOPPlant() {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        float var3 = 0.4f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.8f, 0.5f + var3);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[plants.length];
        for (int i = 0; i < plants.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + plants[i]);
        }
        this.reedbottom = iconRegister.func_94245_a("biomesoplenty:reedbottom");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= this.textures.length) {
            meta = 0;
        }
        return this.textures[meta];
    }

    public int func_149645_b() {
        return RenderUtils.plantsModel;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        long i1 = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        i1 = i1 * i1 * 42317861L + i1 * 11L;
        float d0 = (float)(((double)((float)(i1 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5);
        float d2 = (float)(((double)((float)(i1 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5);
        switch (meta) {
            case 7: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
                break;
            }
            case 12: {
                this.func_149676_a(0.3f + d0, 0.0f, 0.3f + d2, 0.7f + d0, 0.4f, 0.7f + d2);
                break;
            }
            default: {
                this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
            }
        }
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < plants.length; ++i) {
            if (i == 9 || i == 10 || i == 11) continue;
            list.add(new ItemStack(block, 1, i));
        }
    }

    @Override
    public boolean isValidPosition(World world, int x, int y, int z, int metadata) {
        Block block = world.func_147439_a(x, y - 1, z);
        Block root = world.func_147439_a(x, y + 1, z);
        Block reedwater = world.func_147439_a(x, y - 2, z);
        switch (metadata) {
            case 0: {
                return block == BOPBlockHelper.get("driedDirt") || block == Blocks.field_150354_m;
            }
            case 1: {
                return block == Blocks.field_150405_ch;
            }
            case 2: 
            case 3: {
                return block == Blocks.field_150354_m;
            }
            case 4: {
                return block == BOPBlockHelper.get("bopGrass");
            }
            case 5: {
                return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150425_aM;
            }
            case 6: {
                return block == Blocks.field_150349_c || block == Blocks.field_150346_d;
            }
            case 7: {
                return block != Blocks.field_150349_c ? false : (world.func_147439_a(x - 1, y - 1, z).func_149688_o() == Material.field_151586_h ? true : (world.func_147439_a(x + 1, y - 1, z).func_149688_o() == Material.field_151586_h ? true : (world.func_147439_a(x, y - 1, z - 1).func_149688_o() == Material.field_151586_h ? true : world.func_147439_a(x, y - 1, z + 1).func_149688_o() == Material.field_151586_h)));
            }
            case 8: {
                return block == this || block == Blocks.field_150349_c;
            }
            case 9: {
                return block == this;
            }
            case 10: {
                return block != Blocks.field_150349_c ? false : (world.func_147439_a(x - 1, y - 1, z).func_149688_o() == Material.field_151586_h ? true : (world.func_147439_a(x + 1, y - 1, z).func_149688_o() == Material.field_151586_h ? true : (world.func_147439_a(x, y - 1, z - 1).func_149688_o() == Material.field_151586_h ? true : world.func_147439_a(x, y - 1, z + 1).func_149688_o() == Material.field_151586_h)));
            }
            case 12: {
                return block == Blocks.field_150354_m || block == Blocks.field_150405_ch || block == Blocks.field_150425_aM;
            }
            case 13: {
                return block == Blocks.field_150425_aM;
            }
            case 14: {
                return block == Blocks.field_150355_j && reedwater != Blocks.field_150355_j;
            }
            case 15: {
                return root != Blocks.field_150350_a && (root == Blocks.field_150349_c || root == Blocks.field_150346_d || root == Blocks.field_150458_ak || root == BOPBlockHelper.get("longGrass"));
            }
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == BOPBlockHelper.get("overgrownNetherrack");
    }

    @Override
    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack itemStack) {
        int metadata = itemStack.func_77960_j();
        if (metadata == 5 || metadata == 13 || metadata == 15) {
            return this.isValidPosition(world, x, y, z, metadata);
        }
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && this.isValidPosition(world, x, y, z, metadata);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        if (world.func_72805_g(x, y, z) == 9 && world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) != 10) {
            world.func_147468_f(x, y, z);
        } else if (world.func_72805_g(x, y, z) == 10 && world.func_147439_a(x, y + 1, z) != this) {
            world.func_147468_f(x, y, z);
        } else if (world.func_72805_g(x, y, z) == 8 && !this.func_149705_a(world, x, y, z, 0, new ItemStack(BOPBlockHelper.get("plants"), 1, 8))) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        InventoryPlayer inventory;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 5) {
            if (entity instanceof EntityPlayer) {
                inventory = ((EntityPlayer)entity).field_71071_by;
                if (inventory.field_70460_b[0] == null || inventory.field_70460_b[0].func_77973_b() != Items.field_151021_T || inventory.field_70460_b[1] == null || inventory.field_70460_b[1].func_77973_b() != Items.field_151026_S) {
                    entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                }
            } else {
                entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
        }
        if (meta == 12) {
            if (entity instanceof EntityPlayer) {
                inventory = ((EntityPlayer)entity).field_71071_by;
                if (inventory.field_70460_b[0] == null || inventory.field_70460_b[0].func_77973_b() != Items.field_151021_T || inventory.field_70460_b[1] == null || inventory.field_70460_b[1].func_77973_b() != Items.field_151026_S) {
                    entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                }
            } else {
                entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 9: {
                return new ItemStack((Block)this, 1, 7);
            }
            case 10: {
                return new ItemStack((Block)this, 1, 7);
            }
            case 11: {
                return new ItemStack(BOPItemHelper.get("food"), 1, 2);
            }
        }
        return new ItemStack((Block)this, 1, meta);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 9 || meta == 10) {
            meta = 7;
        } else if (meta == 11) {
            meta = 2;
        }
        return meta;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (metadata > 5 && metadata != 11) {
            return Item.func_150898_a((Block)this);
        }
        if (metadata == 11) {
            return BOPItemHelper.get("food");
        }
        return null;
    }

    public int func_149692_a(int meta) {
        if (meta == 9) {
            return 7;
        }
        if (meta == 11) {
            return 2;
        }
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 6) {
            return random.nextInt(5) == 0 ? 1 : 0;
        }
        if (meta == 7 || meta == 8 || meta == 9) {
            return 1;
        }
        if (meta == 11) {
            return random.nextInt(7) == 0 ? 2 : 1;
        }
        if (meta == 13) {
            return 1;
        }
        return 0;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        ItemStack equippedItem;
        super.func_149636_a(world, player, x, y, z, meta);
        if (meta == 13) {
            player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 250, 1));
        }
        if ((equippedItem = player.func_71045_bC()) != null) {
            if (equippedItem.func_77973_b() != Items.field_151097_aZ && meta == 5) {
                player.func_70097_a(DamageSource.field_76367_g, 2.0f);
            }
        } else if (meta == 5) {
            player.func_70097_a(DamageSource.field_76367_g, 2.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        if (meta == 13) {
            int b0 = 3;
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < b0; ++k1) {
                    for (int l1 = 0; l1 < b0; ++l1) {
                        double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                        double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                        double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                        world.func_72869_a("smoke", d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5);
                    }
                }
            }
        }
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta != 5 && meta != 8;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata != 7 && metadata != 8 && metadata != 9 && metadata != 11;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        return ret;
    }
}

