/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.api.BOPBiomeManager;
import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.common.biomes.nether.BiomeGenBoneyard;
import biomesoplenty.common.biomes.nether.BiomeGenCorruptedSands;
import biomesoplenty.common.biomes.nether.BiomeGenPhantasmagoricInferno;
import biomesoplenty.common.biomes.nether.BiomeGenUndergarden;
import biomesoplenty.common.biomes.nether.BiomeGenVisceralHeap;
import biomesoplenty.common.biomes.overworld.BiomeGenAlps;
import biomesoplenty.common.biomes.overworld.BiomeGenArctic;
import biomesoplenty.common.biomes.overworld.BiomeGenBambooForest;
import biomesoplenty.common.biomes.overworld.BiomeGenBayou;
import biomesoplenty.common.biomes.overworld.BiomeGenBog;
import biomesoplenty.common.biomes.overworld.BiomeGenBorealForest;
import biomesoplenty.common.biomes.overworld.BiomeGenBrushland;
import biomesoplenty.common.biomes.overworld.BiomeGenCanyon;
import biomesoplenty.common.biomes.overworld.BiomeGenChaparral;
import biomesoplenty.common.biomes.overworld.BiomeGenCherryBlossomGrove;
import biomesoplenty.common.biomes.overworld.BiomeGenConiferousForest;
import biomesoplenty.common.biomes.overworld.BiomeGenConiferousForestSnow;
import biomesoplenty.common.biomes.overworld.BiomeGenCrag;
import biomesoplenty.common.biomes.overworld.BiomeGenDeadForest;
import biomesoplenty.common.biomes.overworld.BiomeGenDeadSwamp;
import biomesoplenty.common.biomes.overworld.BiomeGenDeciduousForest;
import biomesoplenty.common.biomes.overworld.BiomeGenFen;
import biomesoplenty.common.biomes.overworld.BiomeGenFlowerField;
import biomesoplenty.common.biomes.overworld.BiomeGenFrostForest;
import biomesoplenty.common.biomes.overworld.BiomeGenFungiForest;
import biomesoplenty.common.biomes.overworld.BiomeGenGarden;
import biomesoplenty.common.biomes.overworld.BiomeGenGrassland;
import biomesoplenty.common.biomes.overworld.BiomeGenGrove;
import biomesoplenty.common.biomes.overworld.BiomeGenHeathland;
import biomesoplenty.common.biomes.overworld.BiomeGenHighland;
import biomesoplenty.common.biomes.overworld.BiomeGenJadeCliffs;
import biomesoplenty.common.biomes.overworld.BiomeGenLavenderFields;
import biomesoplenty.common.biomes.overworld.BiomeGenLushDesert;
import biomesoplenty.common.biomes.overworld.BiomeGenLushSwamp;
import biomesoplenty.common.biomes.overworld.BiomeGenMapleWoods;
import biomesoplenty.common.biomes.overworld.BiomeGenMarsh;
import biomesoplenty.common.biomes.overworld.BiomeGenMeadow;
import biomesoplenty.common.biomes.overworld.BiomeGenMoor;
import biomesoplenty.common.biomes.overworld.BiomeGenMountain;
import biomesoplenty.common.biomes.overworld.BiomeGenMysticGrove;
import biomesoplenty.common.biomes.overworld.BiomeGenOminousWoods;
import biomesoplenty.common.biomes.overworld.BiomeGenOriginValley;
import biomesoplenty.common.biomes.overworld.BiomeGenOutback;
import biomesoplenty.common.biomes.overworld.BiomeGenPrairie;
import biomesoplenty.common.biomes.overworld.BiomeGenRainforest;
import biomesoplenty.common.biomes.overworld.BiomeGenRedwoodForest;
import biomesoplenty.common.biomes.overworld.BiomeGenSacredSprings;
import biomesoplenty.common.biomes.overworld.BiomeGenSeasonalForest;
import biomesoplenty.common.biomes.overworld.BiomeGenShield;
import biomesoplenty.common.biomes.overworld.BiomeGenShrubland;
import biomesoplenty.common.biomes.overworld.BiomeGenSludgepit;
import biomesoplenty.common.biomes.overworld.BiomeGenSteppe;
import biomesoplenty.common.biomes.overworld.BiomeGenTemperateRainforest;
import biomesoplenty.common.biomes.overworld.BiomeGenThicket;
import biomesoplenty.common.biomes.overworld.BiomeGenTropicalRainforest;
import biomesoplenty.common.biomes.overworld.BiomeGenTundra;
import biomesoplenty.common.biomes.overworld.BiomeGenWasteland;
import biomesoplenty.common.biomes.overworld.BiomeGenWetland;
import biomesoplenty.common.biomes.overworld.BiomeGenWoodland;
import biomesoplenty.common.biomes.overworld.ocean.BiomeGenCoralReef;
import biomesoplenty.common.biomes.overworld.ocean.BiomeGenKelpForest;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenAlpsForest;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenCanyonRavine;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenGlacier;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenMangrove;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenMeadowForest;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenOasis;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenQuagmire;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenScrubland;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenSilkglades;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenSpruceWoods;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenTropics;
import biomesoplenty.common.biomes.overworld.sub.BiomeGenVolcano;
import biomesoplenty.common.biomes.overworld.tech.BiomeGenDryRiver;
import biomesoplenty.common.biomes.overworld.tech.BiomeGenLushRiver;
import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.common.configuration.BOPConfigurationBiomeWeights;
import biomesoplenty.common.configuration.BOPConfigurationIDs;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import biomesoplenty.common.utils.BOPLogger;
import biomesoplenty.common.world.WorldTypeBOP;
import biomesoplenty.common.world.decoration.BOPDecorationManager;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import org.apache.logging.log4j.Level;

public class BOPBiomes {
    public static WorldTypeBOP worldTypeBOP;
    public static BiomeGenBase onlyBiome;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BOPDecorationManager(), (int)0);
        try {
            BOPConfigurationIDs.config.load();
            BOPConfigurationBiomeGen.config.load();
            BOPConfigurationBiomeWeights.config.load();
            BOPBiomes.registerBiomes();
        }
        catch (Exception e) {
            BOPLogger.log(Level.ERROR, "Biomes O Plenty has had a problem loading its configuration", e);
        }
        finally {
            if (BOPConfigurationIDs.config.hasChanged()) {
                BOPConfigurationIDs.config.save();
            }
            if (BOPConfigurationBiomeGen.config.hasChanged()) {
                BOPConfigurationBiomeGen.config.save();
            }
            if (BOPConfigurationBiomeWeights.config.hasChanged()) {
                BOPConfigurationBiomeWeights.config.save();
            }
        }
        BOPBiomes.addBiomesToDictionary();
        BOPBiomes.disableRivers();
        BOPBiomes.addSpawnBiomes();
    }

    private static void registerBiomes() {
        BOPCBiomes.alps = BOPBiomes.registerOverworldBiome(BiomeGenAlps.class, "Alps", 3, 5);
        BOPCBiomes.arctic = BOPBiomes.registerOverworldBiome(BiomeGenArctic.class, "Arctic", 3, 10);
        BOPCBiomes.bambooForest = BOPBiomes.registerOverworldBiome(BiomeGenBambooForest.class, "Bamboo Forest", 0, 5);
        BOPCBiomes.bayou = BOPBiomes.registerOverworldBiome(BiomeGenBayou.class, "Bayou", 1, 10);
        BOPCBiomes.bog = BOPBiomes.registerOverworldBiome(BiomeGenBog.class, "Bog", 1, 7);
        BOPCBiomes.borealForest = BOPBiomes.registerOverworldBiome(BiomeGenBorealForest.class, "Boreal Forest", 1, 10);
        BOPCBiomes.brushland = BOPBiomes.registerOverworldBiome(BiomeGenBrushland.class, "Brushland", 0, 10);
        BOPCBiomes.canyon = BOPBiomes.registerOverworldBiome(BiomeGenCanyon.class, "Canyon", 0, 7);
        BOPCBiomes.chaparral = BOPBiomes.registerOverworldBiome(BiomeGenChaparral.class, "Chaparral", 1, 10);
        BOPCBiomes.cherryBlossomGrove = BOPBiomes.registerOverworldBiome(BiomeGenCherryBlossomGrove.class, "Cherry Blossom Grove", 2, 3);
        BOPCBiomes.coniferousForest = BOPBiomes.registerOverworldBiome(BiomeGenConiferousForest.class, "Coniferous Forest", 1, 10);
        BOPCBiomes.snowyConiferousForest = BOPBiomes.registerOverworldBiome(BiomeGenConiferousForestSnow.class, "Snowy Coniferous Forest", 3, 10);
        BOPCBiomes.crag = BOPBiomes.registerOverworldBiome(BiomeGenCrag.class, "Crag", 2, 3);
        BOPCBiomes.deadForest = BOPBiomes.registerOverworldBiome(BiomeGenDeadForest.class, "Dead Forest", 2, 7);
        BOPCBiomes.deadSwamp = BOPBiomes.registerOverworldBiome(BiomeGenDeadSwamp.class, "Dead Swamp", 1, 7);
        BOPCBiomes.deciduousForest = BOPBiomes.registerOverworldBiome(BiomeGenDeciduousForest.class, "Deciduous Forest", 1, 10);
        BOPCBiomes.fen = BOPBiomes.registerOverworldBiome(BiomeGenFen.class, "Fen", 1, 10);
        BOPCBiomes.flowerField = BOPBiomes.registerOverworldBiome(BiomeGenFlowerField.class, "Flower Field", 1, 3);
        BOPCBiomes.frostForest = BOPBiomes.registerOverworldBiome(BiomeGenFrostForest.class, "Frost Forest", 3, 7);
        BOPCBiomes.fungiForest = BOPBiomes.registerOverworldBiome(BiomeGenFungiForest.class, "Fungi Forest", 2, 3);
        BOPCBiomes.garden = BOPBiomes.registerOverworldBiome(BiomeGenGarden.class, "Garden", 2, 3);
        BOPCBiomes.grassland = BOPBiomes.registerOverworldBiome(BiomeGenGrassland.class, "Grassland", 2, 10);
        BOPCBiomes.grove = BOPBiomes.registerOverworldBiome(BiomeGenGrove.class, "Grove", 2, 5);
        BOPCBiomes.heathland = BOPBiomes.registerOverworldBiome(BiomeGenHeathland.class, "Heathland", 1, 10);
        BOPCBiomes.highland = BOPBiomes.registerOverworldBiome(BiomeGenHighland.class, "Highland", 1, 10);
        BOPCBiomes.jadeCliffs = BOPBiomes.registerOverworldBiome(BiomeGenJadeCliffs.class, "Jade Cliffs", 1, 5);
        BOPCBiomes.lavenderFields = BOPBiomes.registerOverworldBiome(BiomeGenLavenderFields.class, "Lavender Fields", 1, 3);
        BOPCBiomes.lushDesert = BOPBiomes.registerOverworldBiome(BiomeGenLushDesert.class, "Lush Desert", 0, 5);
        BOPCBiomes.lushSwamp = BOPBiomes.registerOverworldBiome(BiomeGenLushSwamp.class, "Lush Swamp", 1, 10);
        BOPCBiomes.mapleWoods = BOPBiomes.registerOverworldBiome(BiomeGenMapleWoods.class, "Maple Woods", 2, 10);
        BOPCBiomes.marsh = BOPBiomes.registerOverworldBiome(BiomeGenMarsh.class, "Marsh", 1, 7);
        BOPCBiomes.meadow = BOPBiomes.registerOverworldBiome(BiomeGenMeadow.class, "Meadow", 2, 10);
        BOPCBiomes.moor = BOPBiomes.registerOverworldBiome(BiomeGenMoor.class, "Moor", 2, 10);
        BOPCBiomes.mountain = BOPBiomes.registerOverworldBiome(BiomeGenMountain.class, "Mountain", 1, 10);
        BOPCBiomes.mysticGrove = BOPBiomes.registerOverworldBiome(BiomeGenMysticGrove.class, "Mystic Grove", 1, 3);
        BOPCBiomes.ominousWoods = BOPBiomes.registerOverworldBiome(BiomeGenOminousWoods.class, "Ominous Woods", 2, 3);
        BOPCBiomes.originValley = BOPBiomes.registerOverworldBiome(BiomeGenOriginValley.class, "Origin Valley", 1, 1);
        BOPCBiomes.outback = BOPBiomes.registerOverworldBiome(BiomeGenOutback.class, "Outback", 0, 7);
        BOPCBiomes.prairie = BOPBiomes.registerOverworldBiome(BiomeGenPrairie.class, "Prairie", 1, 10);
        BOPCBiomes.rainforest = BOPBiomes.registerOverworldBiome(BiomeGenRainforest.class, "Rainforest", 1, 5);
        BOPCBiomes.redwoodForest = BOPBiomes.registerOverworldBiome(BiomeGenRedwoodForest.class, "Redwood Forest", 1, 7);
        BOPCBiomes.sacredSprings = BOPBiomes.registerOverworldBiome(BiomeGenSacredSprings.class, "Sacred Springs", 1, 3);
        BOPCBiomes.seasonalForest = BOPBiomes.registerOverworldBiome(BiomeGenSeasonalForest.class, "Seasonal Forest", 2, 10);
        BOPCBiomes.shield = BOPBiomes.registerOverworldBiome(BiomeGenShield.class, "Shield", 2, 7);
        BOPCBiomes.shrubland = BOPBiomes.registerOverworldBiome(BiomeGenShrubland.class, "Shrubland", 2, 10);
        BOPCBiomes.sludgepit = BOPBiomes.registerOverworldBiome(BiomeGenSludgepit.class, "Sludgepit", 1, 5);
        BOPCBiomes.steppe = BOPBiomes.registerOverworldBiome(BiomeGenSteppe.class, "Steppe", 0, 7);
        BOPCBiomes.temperateRainforest = BOPBiomes.registerOverworldBiome(BiomeGenTemperateRainforest.class, "Temperate Rainforest", 1, 10);
        BOPCBiomes.thicket = BOPBiomes.registerOverworldBiome(BiomeGenThicket.class, "Thicket", 2, 5);
        BOPCBiomes.tropicalRainforest = BOPBiomes.registerOverworldBiome(BiomeGenTropicalRainforest.class, "Tropical Rainforest", 0, 5);
        BOPCBiomes.tundra = BOPBiomes.registerOverworldBiome(BiomeGenTundra.class, "Tundra", 3, 7);
        BOPCBiomes.wasteland = BOPBiomes.registerOverworldBiome(BiomeGenWasteland.class, "Wasteland", 0, 3);
        BOPCBiomes.wetland = BOPBiomes.registerOverworldBiome(BiomeGenWetland.class, "Wetland", 1, 7);
        BOPCBiomes.woodland = BOPBiomes.registerOverworldBiome(BiomeGenWoodland.class, "Woodland", 1, 10);
        BOPCBiomes.coralReef = BOPBiomes.registerOverworldSubBiome(BiomeGenCoralReef.class, "Coral Reef", 10, BiomeGenBase.field_76771_b);
        BOPCBiomes.kelpForest = BOPBiomes.registerOverworldSubBiome(BiomeGenKelpForest.class, "Kelp Forest", 10, BiomeGenBase.field_76771_b);
        BOPCBiomes.tropics = BOPBiomes.registerOverworldSubBiome(BiomeGenTropics.class, "Tropics", 10, BiomeGenBase.field_150575_M);
        BOPCBiomes.volcano = BOPBiomes.registerOverworldSubBiome(BiomeGenVolcano.class, "Volcano", 10, BiomeGenBase.field_150575_M);
        BOPCBiomes.alpsForest = BOPBiomes.registerOverworldSubBiome(BiomeGenAlpsForest.class, "Alps Forest", 10, BOPCBiomes.alps);
        BOPCBiomes.canyonRavine = BOPBiomes.registerOverworldSubBiome(BiomeGenCanyonRavine.class, "Canyon Ravine", 10, BOPCBiomes.canyon);
        BOPCBiomes.glacier = BOPBiomes.registerOverworldSubBiome(BiomeGenGlacier.class, "Glacier", 10, BOPCBiomes.arctic);
        BOPCBiomes.mangrove = BOPBiomes.registerOverworldSubBiome(BiomeGenMangrove.class, "Mangrove", 10, BOPCBiomes.tropics);
        BOPCBiomes.meadowForest = BOPBiomes.registerOverworldSubBiome(BiomeGenMeadowForest.class, "Meadow Forest", 10, BOPCBiomes.meadow);
        BOPCBiomes.oasis = BOPBiomes.registerOverworldSubBiome(BiomeGenOasis.class, "Oasis", 10, BiomeGenBase.field_76769_d);
        BOPCBiomes.quagmire = BOPBiomes.registerOverworldSubBiome(BiomeGenQuagmire.class, "Quagmire", 10, BOPCBiomes.sludgepit);
        BOPCBiomes.scrubland = BOPBiomes.registerOverworldSubBiome(BiomeGenScrubland.class, "Scrubland", 10, BiomeGenBase.field_150588_X);
        BOPCBiomes.silkglades = BOPBiomes.registerOverworldSubBiome(BiomeGenSilkglades.class, "Silkglades", 10, BOPCBiomes.sludgepit);
        BOPCBiomes.spruceWoods = BOPBiomes.registerOverworldSubBiome(BiomeGenSpruceWoods.class, "Spruce Woods", 10, BiomeGenBase.field_76767_f);
        BOPCBiomes.corruptedSands = BOPBiomes.registerNetherBiome(BiomeGenCorruptedSands.class, "Corrupted Sands", 10);
        BOPCBiomes.phantasmagoricInferno = BOPBiomes.registerNetherBiome(BiomeGenPhantasmagoricInferno.class, "Phantasmagoric Inferno", 10);
        BOPCBiomes.boneyard = BOPBiomes.registerNetherBiome(BiomeGenBoneyard.class, "Boneyard", 10);
        BOPCBiomes.visceralHeap = BOPBiomes.registerNetherBiome(BiomeGenVisceralHeap.class, "Visceral Heap", 10);
        BOPCBiomes.undergarden = BOPBiomes.registerNetherBiome(BiomeGenUndergarden.class, "Undergarden", 10);
        BOPCBiomes.lushRiver = BOPBiomes.registerOverworldRiverBiome(BiomeGenLushRiver.class, "Lush River", BOPCBiomes.lushSwamp, BOPCBiomes.lavenderFields, BOPCBiomes.flowerField, BOPCBiomes.bambooForest, BOPCBiomes.cherryBlossomGrove, BOPCBiomes.lushDesert, BOPCBiomes.meadow, BOPCBiomes.spruceWoods, BOPCBiomes.rainforest, BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t, BiomeGenBase.field_76782_w, BiomeGenBase.field_150574_L, BiomeGenBase.field_76792_x);
        BOPCBiomes.dryRiver = BOPBiomes.registerOverworldRiverBiome(BiomeGenDryRiver.class, "Dry River", BOPCBiomes.outback, BOPCBiomes.steppe, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s);
    }

    private static void addBiomesToDictionary() {
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.alps, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.alpsForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.arctic, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.bambooForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.bayou, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.bog, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.boneyard, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.borealForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.brushland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.canyon, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.canyonRavine, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.chaparral, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.cherryBlossomGrove, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.coniferousForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.snowyConiferousForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.corruptedSands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.DESERT});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.crag, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.deadForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.deadSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.deciduousForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.fen, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.flowerField, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.frostForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.fungiForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.garden, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.glacier, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.grassland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.grove, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.heathland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.highland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.jadeCliffs, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.lavenderFields, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.lushDesert, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.lushSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.mangrove, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.mapleWoods, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.marsh, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.meadow, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.meadowForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.moor, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.mountain, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.mysticGrove, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.oasis, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.JUNGLE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.coralReef, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.kelpForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.ominousWoods, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.outback, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.phantasmagoricInferno, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.prairie, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.quagmire, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.rainforest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.redwoodForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.sacredSprings, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.scrubland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DESERT, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.seasonalForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.shield, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.shrubland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.silkglades, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.sludgepit, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.spruceWoods, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.steppe, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DESERT});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.temperateRainforest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.thicket, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.tropicalRainforest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.tropics, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.tundra, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.undergarden, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.JUNGLE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.visceralHeap, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.volcano, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.wasteland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.wetland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)BOPCBiomes.woodland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
    }

    private static void disableRivers() {
        BOPBiomes.disableRiver(BOPCBiomes.quagmire);
        BOPBiomes.disableRiver(BOPCBiomes.sludgepit);
        BOPBiomes.disableRiver(BOPCBiomes.silkglades);
        BOPBiomes.disableRiver(BOPCBiomes.wetland);
        BOPBiomes.disableRiver(BOPCBiomes.wasteland);
        BOPBiomes.disableRiver(BOPCBiomes.tropicalRainforest);
        BOPBiomes.disableRiver(BOPCBiomes.originValley);
        BOPBiomes.disableRiver(BOPCBiomes.ominousWoods);
        BOPBiomes.disableRiver(BOPCBiomes.mysticGrove);
        BOPBiomes.disableRiver(BOPCBiomes.deadSwamp);
        BOPBiomes.disableRiver(BOPCBiomes.crag);
        BOPBiomes.disableRiver(BOPCBiomes.bayou);
    }

    private static void addSpawnBiomes() {
        if (BOPConfigurationMisc.onlySpawnOnBeaches) {
            BOPBiomes.clearAllSpawnBiomes();
            BOPBiomes.addSpawnBiome(BiomeGenBase.field_76787_r);
            BOPBiomes.addSpawnBiome(BiomeGenBase.field_150576_N);
            BOPBiomes.addSpawnBiome(BiomeGenBase.field_150577_O);
        } else {
            for (List<BOPBiomeManager.BiomeEntry> biomeList : BOPBiomeManager.overworldBiomes) {
                for (BOPBiomeManager.BiomeEntry entry : biomeList) {
                    BOPBiomes.addSpawnBiome(entry.biome);
                }
            }
        }
    }

    private static BiomeGenBase registerOverworldBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int temperatureType, int weight) {
        if (BOPBiomeManager.overworldBiomes[temperatureType] == null) {
            BOPBiomeManager.overworldBiomes[temperatureType] = new ArrayList<BOPBiomeManager.BiomeEntry>();
        }
        return BOPBiomeManager.createAndRegisterBiome(biomeClass, "Overworld", biomeName, BOPBiomeManager.overworldBiomes[temperatureType], weight);
    }

    private static BiomeGenBase registerOverworldSubBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int weight, BiomeGenBase ... parents) {
        BiomeGenBase biome = BOPBiomeManager.createBiome(biomeClass, biomeName);
        if (biome != null) {
            BOPBiomeManager.BiomeEntry entry = new BOPBiomeManager.BiomeEntry(biome, weight);
            if (BOPConfigurationBiomeGen.config.get("Overworld (Sub) Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) {
                for (BiomeGenBase parent : parents) {
                    if (parent == null) continue;
                    if (BOPBiomeManager.overworldSubBiomes[parent.field_76756_M] == null) {
                        BOPBiomeManager.overworldSubBiomes[parent.field_76756_M] = new ArrayList<BOPBiomeManager.BiomeEntry>();
                    }
                    BOPBiomeManager.overworldSubBiomes[parent.field_76756_M].add(entry);
                }
            }
            return biome;
        }
        return null;
    }

    private static BiomeGenBase registerOverworldRiverBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, BiomeGenBase ... parents) {
        BiomeGenBase biome = BOPBiomeManager.createBiome(biomeClass, biomeName);
        if (biome != null && BOPConfigurationBiomeGen.config.get("Overworld (River) Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) {
            for (BiomeGenBase parent : parents) {
                if (parent == null) continue;
                BOPBiomeManager.overworldRiverBiomes[parent.field_76756_M] = biome;
            }
        }
        return null;
    }

    private static void disableRiver(BiomeGenBase biome) {
        BOPBiomeManager.overworldRiverBiomes[biome.field_76756_M] = biome;
    }

    private static BiomeGenBase registerNetherBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int weight) {
        return BOPBiomeManager.createAndRegisterBiome(biomeClass, "Nether", biomeName, BOPBiomeManager.netherBiomes, weight);
    }

    public static void addSpawnBiome(BiomeGenBase biome) {
        BiomeManager.addSpawnBiome((BiomeGenBase)biome);
    }

    public static void clearAllSpawnBiomes() {
        WorldChunkManager.allowedBiomes.clear();
    }

    static {
        onlyBiome = null;
    }
}

