/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.core.BOPBlocks;
import biomesoplenty.common.core.BOPItems;
import biomesoplenty.common.fluids.HoneyFluid;
import biomesoplenty.common.fluids.PoisonFluid;
import biomesoplenty.common.fluids.SpringWaterFluid;
import biomesoplenty.common.fluids.blocks.BlockHoneyFluid;
import biomesoplenty.common.fluids.blocks.BlockPoisonFluid;
import biomesoplenty.common.fluids.blocks.BlockSpringWaterFluid;
import biomesoplenty.common.items.ItemBOPBucket;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BOPFluids {
    public static Fluid poison;
    public static Fluid spring_water;
    public static Fluid honey;

    public static void init() {
        BOPFluids.registerFluids();
        BOPFluids.registerFluidBlocks();
        BOPFluids.registerFluidItems();
    }

    private static void registerFluids() {
        poison = new PoisonFluid("poison");
        BOPFluids.registerFluid(poison);
        spring_water = new SpringWaterFluid("spring_water");
        BOPFluids.registerFluid(spring_water);
        honey = new HoneyFluid("honey");
        BOPFluids.registerFluid(honey);
    }

    private static void registerFluidBlocks() {
        BOPBlocks.registerBlock(new BlockPoisonFluid().func_149663_c("poison"));
        BOPBlocks.registerBlock(new BlockSpringWaterFluid().func_149663_c("springWater"));
        BOPBlocks.registerBlock(new BlockHoneyFluid().func_149663_c("honey"));
        poison.setBlock(BOPBlockHelper.get("poison"));
        spring_water.setBlock(BOPBlockHelper.get("springWater"));
        honey.setBlock(BOPBlockHelper.get("honey"));
    }

    private static void registerFluidItems() {
        BOPItems.registerItem(new ItemBOPBucket().func_77655_b("bopBucket"));
    }

    public static void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
    }
}

