/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.eventhandler.world;

import biomesoplenty.api.BOPBiomeManager;
import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.common.configuration.BOPConfigurationMain;
import biomesoplenty.common.core.BOPBiomes;
import biomesoplenty.common.utils.BOPLogger;
import biomesoplenty.common.world.layer.GenLayerBiomeBOP;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import org.apache.logging.log4j.Level;

public class DefaultWorldEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInitBiomeGens(WorldTypeEvent.InitBiomeGens event) {
        if (event.worldType == BOPBiomes.worldTypeBOP) {
            GenLayer[] originalBiomeGens = event.originalBiomeGens;
            GenLayer parent = originalBiomeGens[0];
            GenLayerBiomeBOP genLayerBiome = null;
            if (parent instanceof GenLayerRiverMix) {
                GenLayerRiverMix genLayerRiverMix = (GenLayerRiverMix)parent;
                GenLayer biomePatternGeneratorChain = (GenLayer)ObfuscationReflectionHelper.getPrivateValue(GenLayerRiverMix.class, (Object)genLayerRiverMix, (String[])new String[]{"biomePatternGeneratorChain", "field_75910_b"});
                if (biomePatternGeneratorChain != null) {
                    parent = biomePatternGeneratorChain;
                }
            }
            while (genLayerBiome == null) {
                GenLayer newParent;
                if (parent instanceof GenLayerBiomeBOP) {
                    genLayerBiome = (GenLayerBiomeBOP)parent;
                }
                if ((newParent = (GenLayer)ObfuscationReflectionHelper.getPrivateValue(GenLayer.class, (Object)parent, (String[])new String[]{"parent", "field_75909_a"})) == null) {
                    throw new RuntimeException("Failed to find GenLayerBiome in chain");
                }
                parent = newParent;
            }
            if (genLayerBiome != null) {
                try {
                    BOPBiomeManager.BiomeEntry entry;
                    BOPConfigurationBiomeGen.config.load();
                    BiomeGenBase[] vanillaDesertBiomes = (BiomeGenBase[])ObfuscationReflectionHelper.getPrivateValue(GenLayerBiome.class, (Object)((Object)genLayerBiome), (String[])new String[]{"field_151623_c"});
                    BiomeGenBase[] vanillaWarmBiomes = (BiomeGenBase[])ObfuscationReflectionHelper.getPrivateValue(GenLayerBiome.class, (Object)((Object)genLayerBiome), (String[])new String[]{"field_151621_d"});
                    BiomeGenBase[] vanillaCoolBiomes = (BiomeGenBase[])ObfuscationReflectionHelper.getPrivateValue(GenLayerBiome.class, (Object)((Object)genLayerBiome), (String[])new String[]{"field_151622_e"});
                    BiomeGenBase[] vanillaIcyBiomes = (BiomeGenBase[])ObfuscationReflectionHelper.getPrivateValue(GenLayerBiome.class, (Object)((Object)genLayerBiome), (String[])new String[]{"field_151620_f"});
                    for (BiomeGenBase biome : vanillaDesertBiomes) {
                        if (biome == null) continue;
                        if (BOPConfigurationMain.debugMode) {
                            BOPLogger.info("Adding biome " + biome.field_76791_y + " from the default world.", new Object[0]);
                        }
                        entry = new BOPBiomeManager.BiomeEntry(biome, 10);
                        if (!BOPConfigurationBiomeGen.config.get("Default World Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) continue;
                        genLayerBiome.biomeLists[0].add(entry);
                    }
                    for (BiomeGenBase biome : vanillaWarmBiomes) {
                        if (biome == null) continue;
                        if (BOPConfigurationMain.debugMode) {
                            BOPLogger.info("Adding biome " + biome.field_76791_y + " from the default world.", new Object[0]);
                        }
                        entry = new BOPBiomeManager.BiomeEntry(biome, 10);
                        if (!BOPConfigurationBiomeGen.config.get("Default World Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) continue;
                        genLayerBiome.biomeLists[1].add(entry);
                    }
                    for (BiomeGenBase biome : vanillaCoolBiomes) {
                        if (biome == null) continue;
                        if (BOPConfigurationMain.debugMode) {
                            BOPLogger.info("Adding biome " + biome.field_76791_y + " from the default world.", new Object[0]);
                        }
                        entry = new BOPBiomeManager.BiomeEntry(biome, 10);
                        if (!BOPConfigurationBiomeGen.config.get("Default World Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) continue;
                        genLayerBiome.biomeLists[2].add(entry);
                    }
                    for (BiomeGenBase biome : vanillaIcyBiomes) {
                        if (biome == null) continue;
                        if (BOPConfigurationMain.debugMode) {
                            BOPLogger.info("Adding biome " + biome.field_76791_y + " from the default world.", new Object[0]);
                        }
                        entry = new BOPBiomeManager.BiomeEntry(biome, 10);
                        if (!BOPConfigurationBiomeGen.config.get("Default World Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) continue;
                        genLayerBiome.biomeLists[3].add(entry);
                    }
                }
                catch (Exception e) {
                    BOPLogger.log(Level.ERROR, "Biomes O Plenty has had a problem loading its configuration", e);
                }
                finally {
                    if (BOPConfigurationBiomeGen.config.hasChanged()) {
                        BOPConfigurationBiomeGen.config.save();
                    }
                }
            }
        }
    }
}

