/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.decoration;

import biomesoplenty.common.utils.BOPLogger;
import biomesoplenty.common.world.decoration.BOPWorldFeatures;
import biomesoplenty.common.world.generation.IBOPWorldGenerator;
import biomesoplenty.common.world.generation.WorldGenFieldAssociation;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BOPDecorationManager
implements IWorldGenerator {
    private static BOPWorldFeatures[] biomeFeaturesMap = new BOPWorldFeatures[BiomeGenBase.func_150565_n().length];

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76577_b.func_77127_a().equals("BIOMESOP")) {
            BiomeGenBase biome = world.func_72807_a((chunkX <<= 4) + 16, (chunkZ <<= 4) + 16);
            BOPWorldFeatures biomeFeatures = BOPDecorationManager.getBiomeFeatures(biome.field_76756_M);
            if (biomeFeatures != null) {
                for (String featureName : biomeFeatures.getFeatureNames()) {
                    try {
                        IBOPWorldGenerator worldGenerator;
                        if (!featureName.equals("bopFlowersPerChunk") ? featureName.equals("bopGrassPerChunk") && !TerrainGen.decorate((World)world, (Random)random, (int)chunkX, (int)chunkZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS) : !TerrainGen.decorate((World)world, (Random)random, (int)chunkX, (int)chunkZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) continue;
                        WorldGenFieldAssociation.WorldFeature worldFeature = WorldGenFieldAssociation.getAssociatedFeature(featureName);
                        if (worldFeature == null || (worldGenerator = worldFeature.getBOPWorldGenerator()) == null) continue;
                        worldGenerator.setupGeneration(world, random, biome, featureName, chunkX, chunkZ);
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        if (e.getMessage() != null && e.getMessage().equals("Already decorating!!") || cause != null && cause.getMessage() != null && cause.getMessage().equals("Already decorating!!")) continue;
                        BOPLogger.severe("Exception on generating " + featureName, e);
                    }
                }
            }
        }
    }

    public static <T extends WorldGenerator> T getRandomWeightedWorldGenerator(HashMap<T, ? extends Number> worldGeneratorMap) {
        double completeWeight = 0.0;
        for (Number number : worldGeneratorMap.values()) {
            completeWeight += Double.parseDouble(number.toString());
        }
        double random = Math.random() * completeWeight;
        double countWeight = 0.0;
        for (Map.Entry<T, Number> entry : worldGeneratorMap.entrySet()) {
            if (!((countWeight += Double.parseDouble(entry.getValue().toString())) >= random)) continue;
            return (T)((WorldGenerator)entry.getKey());
        }
        return null;
    }

    public static BOPWorldFeatures getOrCreateBiomeFeatures(int biomeID) {
        if (biomeFeaturesMap[biomeID] == null) {
            BOPDecorationManager.biomeFeaturesMap[biomeID] = new BOPWorldFeatures();
            return BOPDecorationManager.biomeFeaturesMap[biomeID];
        }
        return biomeFeaturesMap[biomeID];
    }

    public static BOPWorldFeatures getBiomeFeatures(int biomeID) {
        return biomeFeaturesMap[biomeID];
    }
}

