/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.decoration;

import biomesoplenty.common.world.decoration.BOPDecorationManager;
import biomesoplenty.common.world.decoration.BOPWorldFeatures;
import biomesoplenty.common.world.decoration.ForcedDecorator;
import biomesoplenty.common.world.decoration.IBOPBiome;
import biomesoplenty.common.world.forceddecorators.nether.ForcedDecoratorHell;
import biomesoplenty.common.world.forceddecorators.overworld.BirchForestForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.DesertForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.ExtremeHillsForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.ForestForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.IcePlainsForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.JungleForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.MesaForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.MushroomIslandForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.OceanForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.PlainsForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.RiverForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.RoofedForestForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.SavannaForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.SwampForcedDecorator;
import biomesoplenty.common.world.forceddecorators.overworld.TaigaForcedDecorator;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeTweaker {
    public static HashMap<Integer, ForcedDecorator> forcedDecoratorMap = new HashMap();

    public static void init() {
        BiomeTweaker.addForcedDecorators();
        BiomeTweaker.tweakDecorationProperties();
    }

    private static void addForcedDecorators() {
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150583_P.field_76756_M, BirchForestForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150582_Q.field_76756_M, BirchForestForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76769_d.field_76756_M, DesertForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76786_s.field_76756_M, DesertForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76770_e.field_76756_M, ExtremeHillsForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76783_v.field_76756_M, ExtremeHillsForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76767_f.field_76756_M, ForestForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76785_t.field_76756_M, ForestForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76774_n.field_76756_M, IcePlainsForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76782_w.field_76756_M, JungleForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150574_L.field_76756_M, JungleForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76792_x.field_76756_M, JungleForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150589_Z.field_76756_M, MesaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150608_ab.field_76756_M, MesaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150607_aa.field_76756_M, MesaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76789_p.field_76756_M, MushroomIslandForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76788_q.field_76756_M, MushroomIslandForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76771_b.field_76756_M, OceanForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76772_c.field_76756_M, PlainsForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76781_i.field_76756_M, RiverForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150585_R.field_76756_M, RoofedForestForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150588_X.field_76756_M, SavannaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150587_Y.field_76756_M, SavannaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76780_h.field_76756_M, SwampForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76768_g.field_76756_M, TaigaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76784_u.field_76756_M, TaigaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150584_S.field_76756_M, TaigaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_150579_T.field_76756_M, TaigaForcedDecorator.class);
        BiomeTweaker.addForcedDecorator(BiomeGenBase.field_76778_j.field_76756_M, ForcedDecoratorHell.class);
    }

    private static void tweakDecorationProperties() {
        BiomeGenBase.field_76778_j.field_76752_A = Blocks.field_150424_aL;
        BiomeGenBase.field_76778_j.field_76753_B = Blocks.field_150424_aL;
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            BOPWorldFeatures biomeFeatures;
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)i);
            if (biome == null || (biomeFeatures = BOPDecorationManager.getBiomeFeatures(i)) == null) continue;
            List flowers = (List)ReflectionHelper.getPrivateValue(BiomeGenBase.class, (Object)biome, (String[])new String[]{"flowers"});
            flowers.clear();
            biome.addDefaultFlowers();
            biome.field_76760_I.field_76802_A = 0;
            biome.field_76760_I.field_76803_B = 0;
        }
    }

    public static void addForcedDecorator(int biomeID, Class<? extends ForcedDecorator> decoratorClass) {
        try {
            ForcedDecorator decorator = decoratorClass.getConstructor(Integer.TYPE).newInstance(biomeID);
            forcedDecoratorMap.put(biomeID, decorator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IBOPBiome getForcedDecorator(int biomeID) {
        return forcedDecoratorMap.get(biomeID);
    }

    public static boolean biomeHasForcedDecorator(int biomeID) {
        return forcedDecoratorMap.containsKey(biomeID);
    }
}

