/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.BOPBiomeManager;
import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.common.core.BOPBiomes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiomeBOP
extends GenLayerBiome {
    public List<BOPBiomeManager.BiomeEntry>[] biomeLists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};

    public GenLayerBiomeBOP(long seed, GenLayer parentLayer, WorldType worldType) {
        super(seed, parentLayer, worldType);
        this.biomeLists[0].addAll(BOPBiomeManager.overworldBiomes[0]);
        this.biomeLists[1].addAll(BOPBiomeManager.overworldBiomes[1]);
        this.biomeLists[2].addAll(BOPBiomeManager.overworldBiomes[2]);
        this.biomeLists[3].addAll(BOPBiomeManager.overworldBiomes[3]);
    }

    public int[] func_75904_a(int x, int z, int width, int length) {
        int[] inputBiomeIDs = this.field_75909_a.func_75904_a(x, z, width, length);
        int[] outputBiomeIDs = IntCache.func_76445_a((int)(width * length));
        for (int i1 = 0; i1 < length; ++i1) {
            for (int j1 = 0; j1 < width; ++j1) {
                this.func_75903_a(j1 + x, i1 + z);
                int currentBiomeID = inputBiomeIDs[j1 + i1 * width];
                int l1 = (currentBiomeID & 0xF00) >> 8;
                currentBiomeID &= 0xFFFFF0FF;
                if (BOPBiomes.onlyBiome != null) {
                    outputBiomeIDs[j1 + i1 * width] = BOPBiomes.onlyBiome.field_76756_M;
                    continue;
                }
                if (this.isBiomeOceanicAndEnabled(currentBiomeID)) {
                    outputBiomeIDs[j1 + i1 * width] = currentBiomeID;
                    continue;
                }
                if (currentBiomeID == BiomeGenBase.field_76789_p.field_76756_M && BOPConfigurationBiomeGen.mushroomIslandGen) {
                    outputBiomeIDs[j1 + i1 * width] = currentBiomeID;
                    continue;
                }
                if (currentBiomeID == 1) {
                    if (l1 > 0) {
                        if (this.func_75902_a(3) == 0 && BOPConfigurationBiomeGen.mesaPlateauGen) {
                            outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_150608_ab.field_76756_M;
                            continue;
                        }
                        if (BOPConfigurationBiomeGen.mesaPlateauFGen) {
                            outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_150607_aa.field_76756_M;
                            continue;
                        }
                        outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(0);
                        continue;
                    }
                    outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(0);
                    continue;
                }
                if (currentBiomeID == 2) {
                    if (l1 > 0 && BOPConfigurationBiomeGen.jungleGen) {
                        outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_76782_w.field_76756_M;
                        continue;
                    }
                    outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(1);
                    continue;
                }
                if (currentBiomeID == 3) {
                    if (l1 > 0 && BOPConfigurationBiomeGen.megaTaigaGen) {
                        outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_150578_U.field_76756_M;
                        continue;
                    }
                    outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(2);
                    continue;
                }
                outputBiomeIDs[j1 + i1 * width] = currentBiomeID == 4 ? this.getBiomeIdFromList(3) : (BOPConfigurationBiomeGen.mushroomIslandGen ? BiomeGenBase.field_76789_p.field_76756_M : this.getBiomeIdFromMixedList(new int[0]));
            }
        }
        return outputBiomeIDs;
    }

    private int getBiomeIdFromList(int listId) {
        if (!this.biomeLists[listId].isEmpty()) {
            return this.getWeightedBiomeFromList(this.biomeLists[listId]);
        }
        return this.getBiomeIdFromMixedList(listId);
    }

    private int getBiomeIdFromMixedList(int ... listIdExclusions) {
        List listIdExclusionList = Arrays.asList(new int[][]{listIdExclusions});
        ArrayList<BOPBiomeManager.BiomeEntry> mixedBiomeList = new ArrayList<BOPBiomeManager.BiomeEntry>();
        for (int i = 0; i < 4; ++i) {
            if (listIdExclusionList.contains(i) || this.biomeLists[i].isEmpty()) continue;
            mixedBiomeList.addAll(this.biomeLists[i]);
        }
        if (!mixedBiomeList.isEmpty()) {
            return this.getWeightedBiomeFromList(mixedBiomeList);
        }
        throw new RuntimeException("No biomes are enabled!");
    }

    private int getWeightedBiomeFromList(List<BOPBiomeManager.BiomeEntry> biomeList) {
        return ((BOPBiomeManager.BiomeEntry)WeightedRandom.getItem(biomeList, (int)this.func_75902_a((int)WeightedRandom.func_76272_a(biomeList)))).biome.field_76756_M;
    }

    private boolean isBiomeOceanicAndEnabled(int biomeId) {
        return biomeId == BiomeGenBase.field_76771_b.field_76756_M && BOPConfigurationBiomeGen.oceanGen || biomeId == BiomeGenBase.field_150575_M.field_76756_M && BOPConfigurationBiomeGen.deepOceanGen || biomeId == BiomeGenBase.field_76776_l.field_76756_M && BOPConfigurationBiomeGen.frozenOceanGen;
    }
}

