/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import java.security.MessageDigest;
import java.util.HashMap;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import noppes.mpm.ModelPartConfig;
import noppes.mpm.ModelPartData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.constants.EnumAnimation;

public class ModelData {
    public String username;
    public ModelPartConfig arms = new ModelPartConfig();
    public ModelPartConfig body = new ModelPartConfig();
    public ModelPartConfig legs = new ModelPartConfig();
    public ModelPartConfig head = new ModelPartConfig();
    public ModelPartData legParts = new ModelPartData();
    public Class<? extends EntityLivingBase> entityClass;
    private EntityLivingBase entity;
    private NBTTagCompound extra = new NBTTagCompound();
    private HashMap<String, ModelPartData> parts = new HashMap();
    public byte breasts = 0;
    public boolean loaded = false;
    public Object playerResource;
    public byte headwear = (byte)2;
    public int rev = MorePlayerModels.Revision;
    public ItemStack backItem;
    public int inLove = 0;
    public int animationTime = 0;
    public EnumAnimation animation = EnumAnimation.NONE;
    public int animationStart = 0;
    public short soundType = 0;

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Revision", this.rev);
        if (this.entityClass != null) {
            compound.func_74778_a("EntityClass", this.entityClass.getCanonicalName());
        }
        compound.func_74782_a("ArmsConfig", (NBTBase)this.arms.writeToNBT());
        compound.func_74782_a("BodyConfig", (NBTBase)this.body.writeToNBT());
        compound.func_74782_a("LegsConfig", (NBTBase)this.legs.writeToNBT());
        compound.func_74782_a("HeadConfig", (NBTBase)this.head.writeToNBT());
        compound.func_74782_a("LegParts", (NBTBase)this.legParts.writeToNBT());
        compound.func_74774_a("Headwear", this.headwear);
        compound.func_74774_a("Breasts", this.breasts);
        compound.func_74782_a("ExtraData", (NBTBase)this.extra);
        compound.func_74768_a("Animation", this.animation.ordinal());
        compound.func_74777_a("SoundType", this.soundType);
        NBTTagList list = new NBTTagList();
        for (String name : this.parts.keySet()) {
            NBTTagCompound item = this.parts.get(name).writeToNBT();
            item.func_74778_a("PartName", name);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Parts", (NBTBase)list);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.rev = compound.func_74762_e("Revision");
        this.setEntityClass(compound.func_74779_i("EntityClass"));
        this.checkCompatability(compound);
        this.arms.readFromNBT(compound.func_74775_l("ArmsConfig"));
        this.body.readFromNBT(compound.func_74775_l("BodyConfig"));
        this.legs.readFromNBT(compound.func_74775_l("LegsConfig"));
        this.head.readFromNBT(compound.func_74775_l("HeadConfig"));
        this.legParts.readFromNBT(compound.func_74775_l("LegParts"));
        this.headwear = compound.func_74771_c("Headwear");
        this.breasts = compound.func_74771_c("Breasts");
        this.extra = compound.func_74775_l("ExtraData");
        this.soundType = compound.func_74765_d("SoundType");
        this.setAnimation(compound.func_74762_e("Animation"));
        HashMap<String, ModelPartData> parts = new HashMap<String, ModelPartData>();
        NBTTagList list = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            ModelPartData part = new ModelPartData();
            part.readFromNBT(item);
            parts.put(item.func_74779_i("PartName"), part);
        }
        this.parts = parts;
    }

    public void setAnimation(int i) {
        this.animation = i < EnumAnimation.values().length ? EnumAnimation.values()[i] : EnumAnimation.NONE;
        if (this.animation == EnumAnimation.WAVING) {
            this.animationTime = 80;
        }
    }

    private void checkCompatability(NBTTagCompound compound) {
        if (this.rev == MorePlayerModels.Revision) {
            return;
        }
        NBTTagCompound check = this.writeToNBT();
        this.rev = MorePlayerModels.Revision;
    }

    private void setEntityClass(String string) {
        this.entityClass = null;
        this.entity = null;
        try {
            Class<?> cls = Class.forName(string);
            if (EntityLivingBase.class.isAssignableFrom(cls)) {
                this.entityClass = cls.asSubclass(EntityLivingBase.class);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setEntityClass(Class<? extends EntityLivingBase> entityClass) {
        this.entityClass = entityClass;
        this.entity = null;
        this.extra = new NBTTagCompound();
    }

    public Class<? extends EntityLivingBase> getEntityClass() {
        return this.entityClass;
    }

    public EntityLivingBase getEntity(World world) {
        if (this.entityClass == null) {
            return null;
        }
        if (this.entity == null) {
            try {
                this.entity = this.entityClass.getConstructor(World.class).newInstance(world);
                this.doExtras(this.entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.entity;
    }

    public float offsetY() {
        if (this.entity == null) {
            return -this.getBodyY();
        }
        return this.entity.field_70131_O - 1.8f;
    }

    public boolean isChild() {
        return this.extra.func_74767_n("IsChild");
    }

    public void setChild(boolean bo) {
        if (bo) {
            this.extra.func_74757_a("IsChild", bo);
        } else {
            this.extra.func_82580_o("IsChild");
        }
    }

    private void doExtras(EntityLivingBase entity) {
        if (entity instanceof EntityAgeable) {
            entity.func_70096_w().func_75692_b(12, (Object)(this.isChild() ? -100 : 10));
        }
        if (entity instanceof EntityLiving) {
            entity.func_70096_w().func_75692_b(10, (Object)this.username);
            entity.func_70096_w().func_75692_b(11, (Object)1);
        }
        if (entity instanceof EntityBat) {
            ((EntityBat)entity).func_82236_f(false);
        }
    }

    public void clearEntity() {
        this.entity = null;
    }

    public ModelPartData getPartData(String type) {
        return this.parts.get(type);
    }

    public void removePart(String type) {
        this.parts.remove(type);
    }

    public ModelPartData getOrCreatePart(String type) {
        ModelPartData part = this.parts.get(type);
        if (part == null) {
            part = new ModelPartData();
            this.parts.put(type, part);
        }
        return part;
    }

    public float getBodyY() {
        if (this.legParts.type == 3) {
            return (0.9f - this.body.scaleY) * 0.75f + this.getLegsY();
        }
        if (this.legParts.type == 3) {
            return (0.5f - this.body.scaleY) * 0.75f + this.getLegsY();
        }
        return (1.0f - this.body.scaleY) * 0.75f + this.getLegsY();
    }

    public float getLegsY() {
        if (this.legParts.type == 3) {
            return (0.87f - this.legs.scaleY) * 1.0f;
        }
        return (1.0f - this.legs.scaleY) * 0.75f;
    }

    public String getHash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String toHash = this.arms.toString() + this.legs.toString() + this.body.toString() + this.head.toString();
            if (this.entityClass != null) {
                toHash = toHash + this.entityClass.getCanonicalName();
            }
            toHash = toHash + this.legParts.toString() + this.headwear + this.breasts + this.isChild() + this.soundType;
            for (String name : this.parts.keySet()) {
                toHash = toHash + name + ":" + this.parts.get(name).toString();
            }
            byte[] hash = digest.digest(toHash.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public ModelData copy() {
        ModelData data = new ModelData();
        data.readFromNBT(this.writeToNBT());
        return data;
    }

    public boolean isSleeping() {
        return this.isSleeping(this.animation);
    }

    private boolean isSleeping(EnumAnimation animation) {
        return animation == EnumAnimation.SLEEPING_EAST || animation == EnumAnimation.SLEEPING_NORTH || animation == EnumAnimation.SLEEPING_SOUTH || animation == EnumAnimation.SLEEPING_WEST;
    }

    public boolean animationEquals(EnumAnimation animation2) {
        return animation2 == this.animation || this.isSleeping() && this.isSleeping(animation2);
    }
}

