/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import noppes.mpm.ModelData;
import noppes.mpm.PlayerDataController;
import noppes.mpm.Server;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBufInputStream buf = new ByteBufInputStream(event.packet.payload());
        try {
            this.handlePacket(buf, player, EnumPackets.values()[buf.readInt()]);
        }
        catch (Exception e) {
            System.err.println(player + e.getMessage());
        }
    }

    private void handlePacket(ByteBufInputStream dis, EntityPlayerMP player, EnumPackets type) throws IOException {
        if (type == EnumPackets.PING) {
            ModelData data = PlayerDataController.instance.getPlayerData(player.func_70005_c_());
            data.readFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            if (!player.field_70170_p.func_82736_K().func_82766_b("mpmAllowEntityModels")) {
                data.entityClass = null;
            }
            PlayerDataController.instance.savePlayerData(player.func_70005_c_(), data);
            Server.sendAssociatedData(player, EnumPackets.SEND_PLAYER_DATA, player.func_70005_c_(), data.writeToNBT());
            ItemStack back = player.field_71071_by.field_70462_a[0];
            if (back != null) {
                Server.sendAssociatedData(player, EnumPackets.BACK_ITEM_UPDATE, player.func_70005_c_(), back.func_77955_b(new NBTTagCompound()));
            }
            Server.sendData(player, EnumPackets.PING, new Object[0]);
        } else if (type == EnumPackets.REQUEST_PLAYER_DATA) {
            EntityPlayer pl;
            ModelData data;
            String username = dis.readUTF();
            String hash = dis.readUTF();
            if (!hash.equals((data = PlayerDataController.instance.getPlayerData(username)).getHash())) {
                Server.sendData(player, EnumPackets.SEND_PLAYER_DATA, username, data.writeToNBT());
            }
            if ((pl = player.field_70170_p.func_72924_a(username)) == null) {
                return;
            }
            ItemStack back = pl.field_71071_by.field_70462_a[0];
            if (back != null) {
                Server.sendData(player, EnumPackets.BACK_ITEM_UPDATE, username, back.func_77955_b(new NBTTagCompound()));
            } else {
                Server.sendData(player, EnumPackets.BACK_ITEM_REMOVE, username);
            }
        } else if (type == EnumPackets.UPDATE_PLAYER_DATA) {
            ModelData data = PlayerDataController.instance.getPlayerData(player.func_70005_c_());
            data.readFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            if (!player.field_70170_p.func_82736_K().func_82766_b("mpmAllowEntityModels")) {
                data.entityClass = null;
            }
            PlayerDataController.instance.savePlayerData(player.func_70005_c_(), data);
            Server.sendAssociatedData(player, EnumPackets.SEND_PLAYER_DATA, player.func_70005_c_(), data.writeToNBT());
        } else if (type == EnumPackets.ANIMATION) {
            ModelData data;
            EnumAnimation animation = EnumAnimation.values()[dis.readInt()];
            if (animation == EnumAnimation.SLEEPING_SOUTH) {
                float rotation;
                for (rotation = player.field_70177_z; rotation < 0.0f; rotation += 360.0f) {
                }
                while (rotation > 360.0f) {
                    rotation -= 360.0f;
                }
                int rotate = (int)((rotation + 45.0f) / 90.0f);
                if (rotate == 1) {
                    animation = EnumAnimation.SLEEPING_WEST;
                }
                if (rotate == 2) {
                    animation = EnumAnimation.SLEEPING_NORTH;
                }
                if (rotate == 3) {
                    animation = EnumAnimation.SLEEPING_EAST;
                }
            }
            if ((data = PlayerDataController.instance.getPlayerData(player.func_70005_c_())).animationEquals(animation)) {
                animation = EnumAnimation.NONE;
            }
            Server.sendAssociatedData(player, EnumPackets.ANIMATION, new Object[]{player.func_70005_c_(), animation});
            data.animation = animation;
        }
    }
}

