/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import noppes.mpm.ModelData;
import noppes.mpm.PlayerDataController;
import noppes.mpm.Server;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;

public class ServerEventHandler {
    @SubscribeEvent
    public void chat(ServerChatEvent event) {
        Server.sendToAll(EnumPackets.CHAT_EVENT, event.player.func_70005_c_(), event.message);
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        if (!(event.entity instanceof EntityPlayer) || !event.name.equals("game.player.hurt")) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        ModelData data = this.getModelData((EntityLivingBase)player);
        if (data.soundType == 0) {
            return;
        }
        if (player.func_110143_aJ() <= 1.0f || player.field_70128_L) {
            if (data.soundType == 1) {
                event.name = "moreplayermodels:human.female.death";
            }
        } else if (data.soundType == 1) {
            event.name = "moreplayermodels:human.female.hurt";
        }
        System.out.println(event.name);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        boolean flag;
        if (event.entityLiving.field_70170_p.field_72995_K || event.ammount < 1.0f || !event.source.field_76373_n.equals("player") || !(event.source.func_76364_f() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
        boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null;
        if (!flag || event.entityLiving.func_110143_aJ() < 0.0f || (float)player.field_70172_ad > (float)player.field_70771_an / 2.0f) {
            return;
        }
        ModelData data = this.getModelData((EntityLivingBase)player);
        if (data == null) {
            return;
        }
        String sound = "";
        switch (data.soundType) {
            case 1: {
                sound = "moreplayermodels:human.female.attack";
            }
        }
        float pitch = (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.2f + 1.0f;
        player.field_70170_p.func_72956_a((Entity)player, sound, 0.9876543f, pitch);
    }

    private ModelData getModelData(EntityLivingBase entityLiving) {
        if (entityLiving == null || !(entityLiving instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        return PlayerDataController.instance.getPlayerData(player.func_70005_c_());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ModelData data = PlayerDataController.instance.getPlayerData(player.func_70005_c_());
        ItemStack item = player.field_71071_by.field_70462_a[0];
        if (data.backItem == item) {
            return;
        }
        if (item == null) {
            Server.sendAssociatedData(player, EnumPackets.BACK_ITEM_REMOVE, player.func_70005_c_());
        } else {
            NBTTagCompound tag = item.func_77955_b(new NBTTagCompound());
            Server.sendAssociatedData(player, EnumPackets.BACK_ITEM_UPDATE, player.func_70005_c_(), tag);
        }
        data.backItem = item;
        if (data.animation != EnumAnimation.NONE) {
            ServerEventHandler.checkAnimation((EntityPlayer)player, data);
        }
    }

    public static void checkAnimation(EntityPlayer player, ModelData data) {
        boolean isJumping;
        double motionX = player.field_70169_q - player.field_70165_t;
        double motionY = player.field_70167_r - player.field_70163_u;
        double motionZ = player.field_70166_s - player.field_70161_v;
        double speed = motionX * motionX + motionZ * motionZ;
        boolean bl = isJumping = motionY * motionY > 0.08;
        if (data.animationTime > 0) {
            --data.animationTime;
        }
        if (player.func_70608_bn() || player.func_70115_ae() || data.animationTime == 0 && data.animation == EnumAnimation.WAVING || data.animation == EnumAnimation.BOW && player.func_70093_af()) {
            data.animation = EnumAnimation.NONE;
        }
        if (!isJumping && player.func_70093_af() && (data.animation == EnumAnimation.HUG || data.animation == EnumAnimation.CRAWLING || data.animation == EnumAnimation.SITTING || data.animation == EnumAnimation.DANCING)) {
            return;
        }
        if (speed > 0.01 || isJumping || player.func_70608_bn() || player.func_70115_ae()) {
            data.animation = EnumAnimation.NONE;
        }
    }
}

