/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.mpm.ModelData;
import noppes.mpm.ModelPartData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.PlayerDataController;
import noppes.mpm.ServerEventHandler;
import noppes.mpm.client.Client;
import noppes.mpm.client.ClientProxy;
import noppes.mpm.client.EntityRendererAlt;
import noppes.mpm.client.fx.EntityEnderFX;
import noppes.mpm.client.fx.EntityRainbowFX;
import noppes.mpm.client.gui.GuiCreationScreen;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;

public class ClientEventHandler {
    public static float partialTicks = 0.0f;
    private World prevWorld;
    private List<EntityPlayer> playerlist;
    private EntityRendererAlt alt;
    private EntityRenderer prevAlt;

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        if (ClientProxy.Screen.func_151468_f()) {
            ModelData data = PlayerDataController.instance.getPlayerData(mc.field_71439_g.func_70005_c_());
            data.animation = EnumAnimation.NONE;
            if (mc.field_71462_r == null) {
                mc.func_147108_a((GuiScreen)new GuiCreationScreen());
            } else if (mc.field_71462_r instanceof GuiCreationScreen) {
                mc.func_71381_h();
            }
        }
        if (!mc.field_71415_G) {
            return;
        }
        if (ClientProxy.Sleep.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button1);
        }
        if (ClientProxy.Sit.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button2);
        }
        if (ClientProxy.Dance.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button3);
        }
        if (ClientProxy.Hug.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button4);
        }
        if (ClientProxy.Crawl.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button5);
        }
    }

    private void processAnimation(int type) {
        if (type <= 0) {
            return;
        }
        if (MorePlayerModels.HasServerSide) {
            Client.sendData(EnumPackets.ANIMATION, type);
        } else {
            ModelData data;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            EnumAnimation animation = EnumAnimation.values()[type];
            if (animation == EnumAnimation.SLEEPING_SOUTH) {
                float rotation;
                for (rotation = player.field_70177_z; rotation < 0.0f; rotation += 360.0f) {
                }
                while (rotation > 360.0f) {
                    rotation -= 360.0f;
                }
                int rotate = (int)((rotation + 45.0f) / 90.0f);
                if (rotate == 1) {
                    animation = EnumAnimation.SLEEPING_WEST;
                }
                if (rotate == 2) {
                    animation = EnumAnimation.SLEEPING_NORTH;
                }
                if (rotate == 3) {
                    animation = EnumAnimation.SLEEPING_EAST;
                }
            }
            if ((data = PlayerDataController.instance.getPlayerData(player.func_70005_c_())).animationEquals(animation)) {
                animation = EnumAnimation.NONE;
            }
            data.setAnimation(animation.ordinal());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        partialTicks = event.renderTickTime;
        Minecraft mc = Minecraft.func_71410_x();
        if (MorePlayerModels.EnablePOV) {
            if (this.alt == null) {
                this.alt = new EntityRendererAlt(mc);
            }
            if (mc.field_71460_t != this.alt) {
                this.prevAlt = mc.field_71460_t;
                mc.field_71460_t = this.alt;
            }
        } else if (this.prevAlt != null && mc.field_71460_t != this.prevAlt) {
            mc.field_71460_t = this.prevAlt;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (world != null && this.prevWorld != world) {
            MorePlayerModels.HasServerSide = false;
            ModelData data = PlayerDataController.instance.getPlayerData(mc.field_71439_g.func_70005_c_());
            Client.sendData(EnumPackets.PING, data.writeToNBT());
            this.prevWorld = world;
        }
        if (MorePlayerModels.HasServerSide && mc.field_71439_g != null && world.func_72820_D() % 20L == 0L) {
            List list = world.func_72872_a(EntityPlayer.class, mc.field_71439_g.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayer player : list) {
                if (player == mc.field_71439_g || this.playerlist != null && this.playerlist.contains(player)) continue;
                ModelData data = PlayerDataController.instance.getPlayerData(player.func_70005_c_());
                Client.sendData(EnumPackets.REQUEST_PLAYER_DATA, player.func_70005_c_(), data.getHash());
            }
            this.playerlist = list;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ModelPartData particles;
        if (event.side == Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        ModelData data = PlayerDataController.instance.getPlayerData(player.func_70005_c_());
        if (data.inLove > 0) {
            --data.inLove;
            if (player.func_70681_au().nextBoolean()) {
                String s = "heart";
                double d0 = player.func_70681_au().nextGaussian() * 0.02;
                double d1 = player.func_70681_au().nextGaussian() * 0.02;
                double d2 = player.func_70681_au().nextGaussian() * 0.02;
                player.field_70170_p.func_72869_a(s, player.field_70165_t + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, player.field_70163_u + 0.5 + (double)(player.func_70681_au().nextFloat() * player.field_70131_O) - (double)player.field_70129_M, player.field_70161_v + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, d0, d1, d2);
            }
        }
        if (data.animation == EnumAnimation.CRY) {
            float f1 = player.field_70177_z * (float)Math.PI / 180.0f;
            float dx = -MathHelper.func_76126_a((float)f1);
            float dz = MathHelper.func_76134_b((float)f1);
            int i = 0;
            while ((float)i < 10.0f) {
                float f2 = (player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 0.5f + dx * 0.15f;
                float f3 = (player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 0.5f + dz * 0.15f;
                player.field_70170_p.func_72869_a("splash", player.field_70165_t + (double)f2, player.field_70163_u - (double)data.getBodyY() + (double)1.1f - player.func_70033_W(), player.field_70161_v + (double)f3, (double)1.0E-25f, 0.0, (double)1.0E-25f);
                ++i;
            }
        }
        if (data.animation != EnumAnimation.NONE) {
            ServerEventHandler.checkAnimation(player, data);
        }
        if ((particles = data.getPartData("particles")) != null) {
            this.spawnParticles(player, data, particles);
        }
    }

    private void spawnParticles(EntityPlayer player, ModelData data, ModelPartData particles) {
        block3: {
            Random rand;
            double height;
            Minecraft minecraft;
            block2: {
                minecraft = Minecraft.func_71410_x();
                height = player.func_70033_W() + (double)data.getBodyY();
                rand = player.func_70681_au();
                if (particles.type != 0) break block2;
                for (int i = 0; i < 2; ++i) {
                    EntityEnderFX fx = new EntityEnderFX((AbstractClientPlayer)player, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, rand.nextDouble() * (double)player.field_70131_O - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                    minecraft.field_71452_i.func_78873_a((EntityFX)fx);
                }
                break block3;
            }
            if (particles.type != 1) break block3;
            for (int i = 0; i < 2; ++i) {
                double x = player.field_70165_t + (rand.nextDouble() - 0.5) * 0.9;
                double y = player.field_70163_u + rand.nextDouble() * 1.9 - 0.25 - height;
                double z = player.field_70161_v + (rand.nextDouble() - 0.5) * 0.9;
                double f = (rand.nextDouble() - 0.5) * 2.0;
                double f1 = -rand.nextDouble();
                double f2 = (rand.nextDouble() - 0.5) * 2.0;
                minecraft.field_71452_i.func_78873_a((EntityFX)new EntityRainbowFX(player.field_70170_p, x, y, z, f, f1, f2));
            }
        }
    }
}

