/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import noppes.animalbikes.Server;
import noppes.animalbikes.entity.types.EntityRidable;

public class EntityCreeperBike
extends EntityRidable {
    int timeSinceIgnited = 0;
    int lastActiveTime;

    public EntityCreeperBike(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.8f);
    }

    public EntityCreeperBike(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70071_h_() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.isExploding()) {
            if (this.timeSinceIgnited == 5) {
                this.field_70170_p.func_72956_a((Entity)this, "random.fuse", 1.0f, 0.5f);
            }
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited == 30) {
                this.explosion();
                this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                super.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    private void explosion() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        float power = 2.0f;
        if (this.getPowered()) {
            power = 6.0f;
        }
        Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power);
        explosion.field_77286_a = false;
        explosion.func_77278_a();
        if (!MinecraftServer.func_71276_C().func_71218_a(0).func_82736_K().func_82766_b("animalbikesTerrainDamage")) {
            explosion.field_77281_g.clear();
        }
        explosion.func_77279_a(true);
        Server.doExplosion(this.field_70170_p, explosion);
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (!this.field_70170_p.field_72995_K && !this.isExploding() && i > 0.0f && this.field_70170_p.field_73012_v.nextInt(5) == 1) {
            this.field_70180_af.func_75692_b(18, (Object)1);
            EntityPlayer entity = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            if (entity != null) {
                // empty if block
            }
        }
        return super.func_70097_a(damagesource, i);
    }

    public void func_70106_y() {
        if (!this.isExploding()) {
            super.func_70106_y();
        }
    }

    public double func_70042_X() {
        return 0.6;
    }

    public boolean getPowered() {
        return this.isSpecial();
    }

    public void func_70077_a(EntityLightningBolt entitylightningbolt) {
        super.func_70077_a(entitylightningbolt);
        this.setIsSpecial(true);
    }

    public boolean isExploding() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    protected String func_70639_aQ() {
        return "mob.creeper";
    }

    protected String func_70621_aR() {
        return "mob.creeper";
    }

    protected String func_70673_aS() {
        return "mob.creeperdeath";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public float setCreeperFlashTime(float f) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * f) / 28.0f;
    }
}

