/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.entity.EntityPonyBike;
import noppes.animalbikes.entity.EntityPonyFlyingBike;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.items.ItemAnimalBike;
import noppes.animalbikes.permissions.AnimalbikesPermissions;

public class ItemPonyBike
extends ItemAnimalBike {
    public static final List<String> textures = new ArrayList<String>();
    public static final List<String> dyablePonies = new ArrayList<String>();

    public ItemPonyBike(int par1) {
        super(par1);
    }

    @Override
    public EntityRidable getBike(World world) {
        int rand = world.field_73012_v.nextInt(textures.size());
        byte b = ItemPonyBike.getType(rand);
        if (b == 2 || b == 3) {
            EntityPonyFlyingBike pony = new EntityPonyFlyingBike(world);
            pony.setType(b);
            pony.setColor(rand);
            return pony;
        }
        EntityPonyBike pony = new EntityPonyBike(world);
        pony.setType(b);
        pony.setColor(rand);
        return pony;
    }

    public static byte getType(int index) {
        String texture = textures.get(index);
        if (texture.startsWith("animalbikes:textures/entity/ponies/alicorn")) {
            return 3;
        }
        if (texture.startsWith("animalbikes:textures/entity/ponies/pegasus")) {
            return 2;
        }
        if (texture.startsWith("animalbikes:textures/entity/ponies/unicorn")) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return !AnimalBikes.DisablePony && AnimalbikesPermissions.Instance.hasPermission(player.func_70005_c_(), "animalbikes.pony.use");
    }

    @Override
    public boolean isBike(EntityRidable entity) {
        return EntityPonyBike.class.isInstance((Object)entity);
    }

    static {
        if (textures.isEmpty()) {
            textures.add("animalbikes:textures/entity/ponies/alicorn/MineLP Princess Celestia.png");
            textures.add("animalbikes:textures/entity/ponies/alicorn/MineLP Princess Luna S2.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Aloe.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Apple Bloom.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Applejack.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Berry Punch.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Big Mac.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Bon Bon.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Caramel.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Carrot Top.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Cheerilee.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Cherry.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Doctor Whooves.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Golden Harvest.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Lotus.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Nurse Redheart.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Octavia.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Pinkie Pie.png");
            textures.add("animalbikes:textures/entity/ponies/earth/MineLP Roseluck.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Blueberry Muffin.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Brolly.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Cherries Jubilee.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Cloud Kicker.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Derpy Hooves.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Endless Clouds.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Fluttershy.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Orange Box.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Pegasus Guard.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Rainbow Dash.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Raindrop.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Roy G Bow.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Scootaloo.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Soarin.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Spitfire.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Under D Weather.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/MineLP Velvet Hooves.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Chocolate Sun.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Colgate.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Crescent.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP DJ Pon3.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Heartstrings.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Holly Dash.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Lemon Hearts.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Lemon Tart.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Lyra.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP North Pole.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Orchid Dew.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Rarity.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Sparkler.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Star Sparkle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Sweetie Belle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Trixie.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Twilight Sparkle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/MineLP Unicorn Guard.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/alicorn/MineLP Princess Luna S2.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/MineLP Big Mac.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/MineLP Lyra.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/MineLP Chocolate Sun.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/MineLP Rainbow Dash.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/MineLP Rarity.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/MineLP Heartstrings.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/MineLP Derpy Hooves.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/MineLP Octavia.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/MineLP Pinkie Pie.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/MineLP Under D Weather.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/MineLP Fluttershy.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/MineLP DJ Pon3.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/MineLP Twilight Sparkle.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/MineLP Applejack.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/alicorn/MineLP Princess Celestia.png");
        }
    }
}

