/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.ModPack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityChestBoat
extends Entity
implements IInventory {
    public double speed = 0.0;
    protected ItemStack[] cargo = new ItemStack[5];
    protected double speedMultiplier = 0.14;
    protected double maxSpeed = 0.35;
    protected double minSpeed = 0.07;
    private double boatPitch;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;

    public EntityChestBoat(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.6f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityChestBoat(World world, double par2, double par4, double par6) {
        this(world);
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
    }

    public boolean addFuel() {
        if (this.cargo[0] == null) {
            this.cargo[0] = new ItemStack(Items.field_151044_h);
            return true;
        }
        if (this.cargo[0].field_77994_a >= this.func_70297_j_()) {
            return false;
        }
        ++this.cargo[0].field_77994_a;
        this.func_70296_d();
        return true;
    }

    public boolean addItemStackToCargo(ItemStack itemstack) {
        if (!itemstack.func_77951_h()) {
            int i;
            do {
                i = itemstack.field_77994_a;
                itemstack.field_77994_a = this.storePartialItemStack(itemstack);
            } while (itemstack.field_77994_a > 0 && itemstack.field_77994_a < i);
            this.func_70296_d();
            return itemstack.field_77994_a < i;
        }
        int j = this.getFirstEmptyStack();
        if (j > 0) {
            this.cargo[j] = ItemStack.func_77944_b((ItemStack)itemstack);
            this.cargo[j].field_77992_b = 5;
            itemstack.field_77994_a = 0;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.field_70170_p.func_72956_a((Entity)this, "paraknight:clank", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            if (source.func_76347_k()) {
                this.setDamageTaken(this.getDamageTaken() + par2 * 15.0f);
            } else {
                this.setDamageTaken(this.getDamageTaken() + par2 * 8.0f);
            }
            this.func_70018_K();
            if (source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamageTaken(100.0f);
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70099_a(new ItemStack(ModPack.ride, 1, this.getItemDamage()), 0.0f);
                this.func_70106_y();
            }
            if (this.getDamageTaken() > 80.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70106_y();
                this.onDeath();
            }
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void func_70305_f() {
    }

    public void decrementAnimations() {
        for (int i = 0; i < this.cargo.length; ++i) {
            if (this.cargo[i] == null) continue;
            this.cargo[i].func_77945_a(this.field_70170_p, this.field_70153_n, i, false);
        }
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack[] aitemstack = this.cargo;
        if (aitemstack[i] != null) {
            if (aitemstack[i].field_77994_a <= j) {
                ItemStack itemstack = aitemstack[i];
                aitemstack[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i].func_77979_a(j);
            if (aitemstack[i].field_77994_a == 0) {
                aitemstack[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.field_70121_D;
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public abstract int getFuelDuration();

    public int getFuelTime() {
        return this.field_70180_af.func_75679_c(25);
    }

    public int getInventorySlotContainItem(Item i) {
        for (int j = 0; j < this.cargo.length; ++j) {
            if (this.cargo[j] == null || this.cargo[j].func_77973_b() != i) continue;
            return j;
        }
        return -1;
    }

    public int func_70297_j_() {
        return 64;
    }

    public abstract int getItemDamage();

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    public int func_70302_i_() {
        return this.cargo.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.cargo[i];
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public int getTimeInWater() {
        return this.field_70180_af.func_75679_c(26);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public abstract void handleSoundEffects();

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack item) {
        return i == 0 && item.func_77973_b() == Items.field_151044_h || i > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.field_70128_L && player.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70296_d() {
        this.setFuelTime(this.cargo[0] != null ? Math.round(this.cargo[0].field_77994_a * 100 / 64) : 0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getFuelTime() > 0) {
            this.setFuelTime(this.getFuelTime() - 1);
        }
        if (this.getFuelTime() == 0 && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.field_70153_n).field_71071_by.func_146028_b(Items.field_151044_h)) {
            this.setFuelTime(this.getFuelDuration());
            ((EntityPlayer)this.field_70153_n).field_71071_by.func_146026_a(Items.field_151044_h);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double d0 = 0.0;
        double d3 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            if (this.boatPosRotationIncrements > 0) {
                double d4 = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                double d5 = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double d11 = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                double d10 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d10 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(d4, d5, d11);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double d4 = this.field_70165_t + this.field_70159_w;
                double d5 = this.field_70163_u + this.field_70181_x;
                double d11 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d4, d5, d11);
                if (this.getFuelTime() == 0) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        } else {
            double d12;
            double d5;
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                float f = this.field_70153_n.field_70177_z - ((EntityLivingBase)this.field_70153_n).field_70702_br * 90.0f;
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)((EntityLivingBase)this.field_70153_n).field_70701_bs * 0.05;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)((EntityLivingBase)this.field_70153_n).field_70701_bs * 0.05;
                this.field_70138_W = 1.0f;
            } else {
                this.field_70138_W = 0.5f;
            }
            double d4 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d4 > this.maxSpeed) {
                d5 = this.maxSpeed / d4;
                this.field_70159_w *= d5;
                this.field_70179_y *= d5;
                d4 = this.maxSpeed;
            }
            if (d4 > d3 && this.speedMultiplier < this.maxSpeed) {
                this.speedMultiplier += (this.maxSpeed - this.speedMultiplier) / (this.maxSpeed * 100.0);
                if (this.speedMultiplier > this.maxSpeed) {
                    this.speedMultiplier = this.maxSpeed;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - this.minSpeed) / (this.maxSpeed * 100.0);
                if (this.speedMultiplier < this.minSpeed) {
                    this.speedMultiplier = this.minSpeed;
                }
            }
            if (this.getFuelTime() == 0) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && d3 > this.getMaxCollisionSpeed()) {
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
            this.field_70125_A = 0.0f;
            d5 = this.field_70177_z;
            double d11 = this.field_70169_q - this.field_70165_t;
            double d10 = this.field_70166_s - this.field_70161_v;
            if (d11 * d11 + d10 * d10 > 0.001) {
                d5 = (float)(Math.atan2(d10, d11) * 180.0 / Math.PI);
            }
            if ((d12 = MathHelper.func_76138_g((double)(d5 - (double)this.field_70177_z))) > 20.0) {
                d12 = 20.0;
            }
            if (d12 < -20.0) {
                d12 = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + d12);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                int l;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (l = 0; l < list.size(); ++l) {
                        Entity entity = (Entity)list.get(l);
                        if (entity == this.field_70153_n || !entity.func_70104_M()) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                for (l = 0; l < 4; ++l) {
                    int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 0.8));
                    int j1 = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 0.8));
                    for (int k1 = 0; k1 < 2; ++k1) {
                        int l1 = MathHelper.func_76128_c((double)this.field_70163_u) + k1;
                        Block i2 = this.field_70170_p.func_147439_a(i1, l1, j1);
                        if (i2 != Blocks.field_150433_aE) continue;
                        this.field_70170_p.func_147468_f(i1, l1, j1);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
            }
        }
        this.updateSpeedModel();
        this.handleEntityCollisions();
        this.handleBlockCollisions();
        this.handleDamage();
        this.handleSoundEffects();
        this.handleParticleEffects();
    }

    public abstract double getMaxCollisionSpeed();

    public void func_70295_k_() {
    }

    public void readFromNBT(NBTTagList nbttaglist) {
        this.cargo = new ItemStack[5];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            if (itemstack.func_77973_b() == null || j < 0 || j >= this.cargo.length) continue;
            this.cargo[j] = itemstack;
        }
        this.func_70296_d();
    }

    public void setDamageTaken(float par1) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(par1));
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public void setFuelTime(int par1) {
        this.field_70180_af.func_75692_b(25, (Object)par1);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.cargo[i] = itemstack;
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.boatPosRotationIncrements = par9 + 5;
        this.boatX = par1;
        this.boatY = par3;
        this.boatZ = par5;
        this.boatYaw = par7;
        this.boatPitch = par8;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void setTimeInWater(int par1) {
        this.field_70180_af.func_75692_b(26, (Object)par1);
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.velocityX = this.field_70159_w = par1;
        this.velocityY = this.field_70181_x = par3;
        this.velocityZ = this.field_70179_y = par5;
    }

    public abstract void updateSpeedModel();

    public NBTTagList writeToNBT(NBTTagList nbttaglist) {
        for (int i = 0; i < this.cargo.length; ++i) {
            if (this.cargo[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.cargo[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(25, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(26, (Object)new Integer(0));
    }

    protected void handleBlockCollisions() {
        if (this.func_70090_H()) {
            this.setTimeInWater(this.getTimeInWater() + 1);
        } else {
            this.setTimeInWater(0);
        }
        if (this.getTimeInWater() > 20) {
            this.setDamageTaken(this.getDamageTaken() + 1.0f);
            this.setTimeInWater(0);
        }
    }

    protected void handleDamage() {
        if (this.getDamageTaken() > 60.0f && this.field_70146_Z.nextInt(100) < 5) {
            this.setDamageTaken(this.getDamageTaken() + 1.0f);
        }
    }

    protected void handleParticleEffects() {
        if (this.getFuelTime() > 0) {
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u - 0.15, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (this.getDamageTaken() > 50.0f && !this.func_70090_H()) {
            double xOffset = -Math.sin(Math.toRadians(this.field_70177_z + 50.0f - (float)this.field_70146_Z.nextInt(101))) * 0.8;
            double zOffset = Math.cos(Math.toRadians(this.field_70177_z + 50.0f - (float)this.field_70146_Z.nextInt(101))) * 0.8;
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t + xOffset, this.field_70163_u, this.field_70161_v + zOffset, 0.0, 0.0, 0.0);
            if (this.getDamageTaken() > 60.0f) {
                this.field_70170_p.func_72869_a("flame", this.field_70165_t + xOffset, this.field_70163_u, this.field_70161_v + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.readFromNBT((NBTTagList)nbttagcompound.func_74781_a("Cargo"));
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("Cargo", (NBTBase)this.writeToNBT(new NBTTagList()));
    }

    private int getFirstEmptyStack() {
        for (int i = 1; i < this.cargo.length; ++i) {
            if (this.cargo[i] != null) continue;
            return i;
        }
        return -1;
    }

    private void handleEntityCollisions() {
        List var1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
        for (Entity var3 : var1) {
            if (var3 instanceof EntityItem && ((EntityItem)var3).func_92059_d().func_77973_b() == Items.field_151014_N && this.addItemStackToCargo(new ItemStack(Items.field_151014_N, ((EntityItem)var3).func_92059_d().field_77994_a))) {
                var3.func_70106_y();
            }
            if (this.field_70153_n != null && var3 != this.field_70153_n && var3 instanceof EntityLiving && this.speed > 0.0 && var3.func_70097_a(DamageSource.field_76377_j, 4.0f)) {
                this.field_70170_p.func_72956_a(var3, "damage.hurtflesh", 1.0f, 0.5f);
            }
            if (var3 == this.field_70153_n || !var3.func_70104_M()) continue;
            var3.func_70108_f((Entity)this);
        }
    }

    private void onDeath() {
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(this.getFuelTime() / 25), true);
        this.cargo[0] = null;
        for (int i = 1; i < this.cargo.length; ++i) {
            if (this.cargo[i] == null) continue;
            for (int j = 0; j < this.cargo[i].field_77994_a; ++j) {
                this.func_70099_a(this.cargo[i], (new Random().nextFloat() - 0.5f) * 2.0f);
            }
            this.cargo[i] = null;
        }
    }

    private int storeItemStack(ItemStack itemstack) {
        for (int i = 1; i < this.cargo.length; ++i) {
            if (this.cargo[i] == null || this.cargo[i].func_77973_b() != itemstack.func_77973_b() || !this.cargo[i].func_77985_e() || this.cargo[i].field_77994_a >= this.cargo[i].func_77976_d() || this.cargo[i].field_77994_a >= this.func_70297_j_() || this.cargo[i].func_77981_g() && this.cargo[i].func_77960_j() != itemstack.func_77960_j()) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemstack) {
        int l;
        Item i = itemstack.func_77973_b();
        int j = itemstack.field_77994_a;
        int k = this.storeItemStack(itemstack);
        if (k < 0) {
            k = this.getFirstEmptyStack();
        }
        if (k < 0) {
            return j;
        }
        if (this.cargo[k] == null) {
            this.cargo[k] = new ItemStack(i, 0, itemstack.func_77960_j());
        }
        if ((l = j) > this.cargo[k].func_77976_d() - this.cargo[k].field_77994_a) {
            l = this.cargo[k].func_77976_d() - this.cargo[k].field_77994_a;
        }
        if (l > this.func_70297_j_() - this.cargo[k].field_77994_a) {
            l = this.func_70297_j_() - this.cargo[k].field_77994_a;
        }
        if (l == 0) {
            return j;
        }
        this.cargo[k].field_77994_a += l;
        this.cargo[k].field_77992_b = 5;
        return j -= l;
    }
}

