/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksContainerManager;
import invtweaks.api.container.ContainerSection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InvTweaksContainerSectionManager {
    private InvTweaksContainerManager containerMgr;
    private ContainerSection section;

    public InvTweaksContainerSectionManager(Minecraft minecraft, ContainerSection containerSection) throws Exception {
        this(new InvTweaksContainerManager(minecraft), containerSection);
    }

    public void setClickDelay(int n) {
        this.containerMgr.setClickDelay(n);
    }

    public InvTweaksContainerSectionManager(InvTweaksContainerManager invTweaksContainerManager, ContainerSection containerSection) throws Exception {
        this.containerMgr = invTweaksContainerManager;
        this.section = containerSection;
        if (!this.containerMgr.hasSection(containerSection)) {
            throw new Exception("Section not available");
        }
    }

    public boolean move(int n, int n2) throws TimeoutException {
        return this.containerMgr.move(this.section, n, this.section, n2);
    }

    public boolean moveSome(int n, int n2, int n3) throws TimeoutException {
        return this.containerMgr.moveSome(this.section, n, this.section, n2, n3);
    }

    public boolean drop(int n) throws TimeoutException {
        return this.containerMgr.drop(this.section, n);
    }

    public boolean dropSome(int n, int n2) throws TimeoutException {
        return this.containerMgr.dropSome(this.section, n, n2);
    }

    public boolean putHoldItemDown(int n) throws TimeoutException {
        return this.containerMgr.putHoldItemDown(this.section, n);
    }

    public void leftClick(int n) throws TimeoutException {
        this.containerMgr.leftClick(this.section, n);
    }

    public void rightClick(int n) throws TimeoutException {
        this.containerMgr.rightClick(this.section, n);
    }

    public void click(int n, boolean bl) throws TimeoutException {
        this.containerMgr.click(this.section, n, bl);
    }

    public List<Slot> getSlots() {
        return this.containerMgr.getSlots(this.section);
    }

    public int getSize() {
        return this.containerMgr.getSize(this.section);
    }

    public int getFirstEmptyIndex() {
        return this.containerMgr.getFirstEmptyIndex(this.section);
    }

    public boolean isSlotEmpty(int n) {
        return this.containerMgr.isSlotEmpty(this.section, n);
    }

    public Slot getSlot(int n) {
        return this.containerMgr.getSlot(this.section, n);
    }

    public int getSlotIndex(int n) {
        if (this.isSlotInSection(n)) {
            return this.containerMgr.getSlotIndex(n);
        }
        return -1;
    }

    public boolean isSlotInSection(int n) {
        return this.containerMgr.getSlotSection(n) == this.section;
    }

    public ItemStack getItemStack(int n) throws NullPointerException, IndexOutOfBoundsException {
        return this.containerMgr.getItemStack(this.section, n);
    }

    public Container getContainer() {
        return this.containerMgr.getContainer();
    }
}

