/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.addon;

import com.pahimar.ee3.addon.AddonHandler;
import com.pahimar.ee3.api.OreStack;
import com.pahimar.ee3.api.WrappedStack;
import com.pahimar.ee3.emc.EmcValue;
import com.pahimar.ee3.helper.LogHelper;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class AddonIndustrialCraft2 {
    private static final EmcValue COPPER_EMC_VALUE = new EmcValue(72);
    private static final EmcValue TIN_EMC_VALUE = new EmcValue(256);
    private static final EmcValue LEAD_EMC_VALUE = new EmcValue(512);
    private static final EmcValue SILVER_EMC_VALUE = new EmcValue(1024);
    private static final EmcValue URANIUM_EMC_VALUE = new EmcValue(4096);
    private static final EmcValue SULFUR_EMC_VALUE = new EmcValue(512);
    private static final EmcValue LITHIUM_EMC_VALUE = new EmcValue(512);
    private static final EmcValue SILICON_DIOXIDE_EMC_VALUE = new EmcValue(256);
    private static final EmcValue RUBBER_WOOD_EMC_VALUE = new EmcValue(24);

    public static void init() {
        AddonIndustrialCraft2.addRecipes();
        AddonIndustrialCraft2.addPreAssignmentEmcValues();
        AddonIndustrialCraft2.addPostAssignmentEmcValues();
    }

    private static void addRecipes() {
        AddonHandler.sendAddRecipe(new OreStack("dustBronze"), new OreStack("dustTin"), new OreStack("dustCopper", 3));
        AddonHandler.sendAddRecipe(new OreStack("ingotBronze"), new OreStack("dustBronze"));
        AddonHandler.sendAddRecipe(new OreStack("plateBronze"), new OreStack("ingotBronze"));
        AddonHandler.sendAddRecipe(new OreStack("blockBronze"), new OreStack("ingotBronze", 9));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseBronze"), new OreStack("ingotBronze", 9));
        AddonHandler.sendAddRecipe(new OreStack("dustClay", 2), Block.field_72041_aW);
        AddonHandler.sendAddRecipe(new OreStack("dustCoal"), new ItemStack(Item.field_77705_m, 1));
        AddonHandler.sendAddRecipe(new OreStack("dustHydratedCoal"), new OreStack("dustCoal"), new WrappedStack(FluidRegistry.WATER));
        AddonHandler.sendAddRecipe(new OreStack("dustCopper"), new OreStack("oreCopper"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinyCopper", 9), new OreStack("dustCopper"));
        AddonHandler.sendAddRecipe(new OreStack("crushedCopper"), new OreStack("dustCopper"));
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedCopper"), new OreStack("crushedCopper"));
        AddonHandler.sendAddRecipe(new OreStack("ingotCopper"), new OreStack("dustCopper"));
        AddonHandler.sendAddRecipe(new OreStack("plateCopper"), new OreStack("ingotCopper"));
        AddonHandler.sendAddRecipe(new OreStack("blockCopper"), new OreStack("ingotCopper", 9));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseCopper"), new OreStack("ingotCopper", 9));
        AddonHandler.sendAddRecipe(new OreStack("dustDiamond"), Item.field_77702_n);
        AddonHandler.sendAddRecipe(new OreStack("crushedGold"), Block.field_71941_G);
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedGold"), new OreStack("crushedGold"));
        AddonHandler.sendAddRecipe(new OreStack("dustGold"), new OreStack("crushedPurifiedGold"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinyGold", 9), Block.field_71941_G);
        AddonHandler.sendAddRecipe(new OreStack("plateGold"), Item.field_77717_p);
        AddonHandler.sendAddRecipe(new OreStack("plateDenseGold"), new ItemStack(Item.field_77717_p, 9));
        AddonHandler.sendAddRecipe(new OreStack("gemDiamond"), Item.field_77702_n);
        AddonHandler.sendAddRecipe(new OreStack("crushedIron"), Block.field_71949_H);
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedIron"), new OreStack("crushedIron"));
        AddonHandler.sendAddRecipe(new OreStack("dustIron"), new OreStack("crushedPurifiedIron"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinyIron", 9), Block.field_71949_H);
        AddonHandler.sendAddRecipe(new OreStack("ingotRefinedIron"), Item.field_77703_o);
        AddonHandler.sendAddRecipe(new OreStack("plateIron"), Item.field_77703_o);
        AddonHandler.sendAddRecipe(new OreStack("plateRefinedIron"), new OreStack("ingotRefinedIron"));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseIron"), new ItemStack(Item.field_77703_o, 9));
        AddonHandler.sendAddRecipe(new OreStack("dustLapis"), new ItemStack(Item.field_77756_aW, 1, 4));
        AddonHandler.sendAddRecipe(new OreStack("plateLapis"), new OreStack("dustLapis"));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseLapis"), new OreStack("plateLapis", 9));
        AddonHandler.sendAddRecipe(new OreStack("crushedLead"), new OreStack("oreLead"));
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedLead"), new OreStack("crushedLead"));
        AddonHandler.sendAddRecipe(new OreStack("dustLead"), new OreStack("crushedPurifiedLead"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinyLead", 9), new OreStack("dustLead"));
        AddonHandler.sendAddRecipe(new OreStack("ingotLead"), new OreStack("dustLead"));
        AddonHandler.sendAddRecipe(new OreStack("plateLead"), new OreStack("ingotLead"));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseLead"), new OreStack("ingotLead", 9));
        AddonHandler.sendAddRecipe(new OreStack("blockLead"), new OreStack("ingotLead", 9));
        AddonHandler.sendAddRecipe(new OreStack("dustTinyLithium", 9), new OreStack("dustLithium"));
        AddonHandler.sendAddRecipe(new OreStack("dustObsidian", 4), Block.field_72089_ap);
        AddonHandler.sendAddRecipe(new OreStack("plateObsidian"), new OreStack("dustObsidian"));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseObsidian"), new OreStack("plateObsidian", 9));
        AddonHandler.sendAddRecipe(new OreStack("crushedSilver"), new OreStack("oreSilver"));
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedSilver"), new OreStack("crushedSilver"));
        AddonHandler.sendAddRecipe(new OreStack("dustSilver"), new OreStack("crushedPurifiedSilver"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinySilver", 9), new OreStack("dustSilver"));
        AddonHandler.sendAddRecipe(new OreStack("ingotSilver"), new OreStack("dustSilver"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinySulfur", 9), new OreStack("dustSulfur"));
        AddonHandler.sendAddRecipe(new OreStack("dustTin"), new OreStack("oreTin"));
        AddonHandler.sendAddRecipe(new OreStack("dustTinyTin", 9), new OreStack("dustTin"));
        AddonHandler.sendAddRecipe(new OreStack("crushedTin"), new OreStack("dustTin"));
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedTin"), new OreStack("crushedTin"));
        AddonHandler.sendAddRecipe(new OreStack("ingotTin"), new OreStack("dustTin"));
        AddonHandler.sendAddRecipe(new OreStack("plateTin"), new OreStack("ingotTin"));
        AddonHandler.sendAddRecipe(new OreStack("blockTin"), new OreStack("ingotTin", 9));
        AddonHandler.sendAddRecipe(new OreStack("plateDenseTin"), new OreStack("ingotTin", 9));
        AddonHandler.sendAddRecipe(new OreStack("crushedUranium"), new OreStack("oreUranium"));
        AddonHandler.sendAddRecipe(new OreStack("crushedPurifiedUranium"), new OreStack("crushedUranium"));
        AddonHandler.sendAddRecipe(new OreStack("blockUranium"), new OreStack("oreUranium", 9));
        AddonHandler.sendAddRecipe(new OreStack("craftingToolForgeHammer"), new ItemStack(Item.field_77703_o, 5), new OreStack("stickWood", 2));
        AddonHandler.sendAddRecipe(new OreStack("craftingToolWireCutter"), new ItemStack(Item.field_77703_o, 2), new OreStack("plateIron", 3));
        AddonHandler.sendAddRecipe(new OreStack("itemRubber"), new OreStack("woodRubber"));
    }

    private static void addPreAssignmentEmcValues() {
        AddonHandler.sendPreValueAssignment(new OreStack("oreCopper"), COPPER_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("oreTin"), TIN_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("oreLead"), LEAD_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("oreSilver"), SILVER_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("oreUranium"), URANIUM_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("dustSulfur"), SULFUR_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("dustLithium"), LITHIUM_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("dustSiliconDioxide"), SILICON_DIOXIDE_EMC_VALUE);
        AddonHandler.sendPreValueAssignment(new OreStack("woodRubber"), RUBBER_WOOD_EMC_VALUE);
    }

    private static void addPostAssignmentEmcValues() {
    }

    public static Item grabIC2ItemByName(String name) {
        try {
            Object object = Class.forName("ic2.api.item.Items").getDeclaredMethod("getItem", String.class).invoke(null, name);
            LogHelper.debug(object);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

